/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.server;

import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_1304;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_151;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3898;
import net.minecraft.class_4050;
import net.minecraft.class_5131;
import net.minecraft.class_5629;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vivecraft.client.Xplat;
import org.vivecraft.common.CommonDataHolder;
import org.vivecraft.common.network.BodyPart;
import org.vivecraft.common.network.FBTMode;
import org.vivecraft.common.network.VrPlayerState;
import org.vivecraft.common.network.packet.PayloadIdentifier;
import org.vivecraft.common.network.packet.c2s.ActiveBodyPartPayloadC2S;
import org.vivecraft.common.network.packet.c2s.CrawlPayloadC2S;
import org.vivecraft.common.network.packet.c2s.DrawPayloadC2S;
import org.vivecraft.common.network.packet.c2s.HeightPayloadC2S;
import org.vivecraft.common.network.packet.c2s.LegacyController0DataPayloadC2S;
import org.vivecraft.common.network.packet.c2s.LegacyController1DataPayloadC2S;
import org.vivecraft.common.network.packet.c2s.LegacyHeadDataPayloadC2S;
import org.vivecraft.common.network.packet.c2s.TeleportPayloadC2S;
import org.vivecraft.common.network.packet.c2s.UnknownPayloadC2S;
import org.vivecraft.common.network.packet.c2s.VRActivePayloadC2S;
import org.vivecraft.common.network.packet.c2s.VRPlayerStatePayloadC2S;
import org.vivecraft.common.network.packet.c2s.VersionPayloadC2S;
import org.vivecraft.common.network.packet.c2s.VivecraftPayloadC2S;
import org.vivecraft.common.network.packet.c2s.WorldScalePayloadC2S;
import org.vivecraft.common.network.packet.s2c.ClimbingPayloadS2C;
import org.vivecraft.common.network.packet.s2c.CrawlPayloadS2C;
import org.vivecraft.common.network.packet.s2c.DualWieldingPayloadS2C;
import org.vivecraft.common.network.packet.s2c.NetworkVersionPayloadS2C;
import org.vivecraft.common.network.packet.s2c.RequestDataPayloadS2C;
import org.vivecraft.common.network.packet.s2c.SettingOverridePayloadS2C;
import org.vivecraft.common.network.packet.s2c.TeleportPayloadS2C;
import org.vivecraft.common.network.packet.s2c.UberPacketPayloadS2C;
import org.vivecraft.common.network.packet.s2c.VRActivePayloadS2C;
import org.vivecraft.common.network.packet.s2c.VRSwitchingPayloadS2C;
import org.vivecraft.common.network.packet.s2c.VersionPayloadS2C;
import org.vivecraft.common.network.packet.s2c.VivecraftPayloadS2C;
import org.vivecraft.mixin.server.ChunkMapAccessor;
import org.vivecraft.mixin.server.TrackedEntityAccessor;
import org.vivecraft.server.ServerVRPlayers;
import org.vivecraft.server.ServerVivePlayer;
import org.vivecraft.server.config.ClimbeyBlockmode;
import org.vivecraft.server.config.ServerConfig;

public class ServerNetworking {
    private static final Map<UUID, Map<PayloadIdentifier, VivecraftPayloadC2S>> LEGACY_DATA_MAP = new HashMap<UUID, Map<PayloadIdentifier, VivecraftPayloadC2S>>();
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"VivecraftServer");

    /*
     * Unable to fully structure code
     */
    public static void handlePacket(VivecraftPayloadC2S c2sPayload, class_3222 player, Consumer<VivecraftPayloadS2C> packetConsumer) {
        if (c2sPayload instanceof UnknownPayloadC2S) {
            return;
        }
        vivePlayer = ServerVRPlayers.getVivePlayer(player);
        if (vivePlayer == null && c2sPayload.payloadId() != PayloadIdentifier.VERSION) {
            return;
        }
        if (vivePlayer != null) {
            vivePlayer.player = player;
        }
        switch (1.$SwitchMap$org$vivecraft$common$network$packet$PayloadIdentifier[c2sPayload.payloadId().ordinal()]) {
            case 1: {
                vivePlayer = new ServerVivePlayer(player);
                payload = (VersionPayloadC2S)c2sPayload;
                if (((Boolean)ServerConfig.DEBUG.get()).booleanValue()) {
                    ServerNetworking.LOGGER.info("Vivecraft: player '{}' joined with {}", (Object)player.method_5477().getString(), (Object)payload.version());
                }
                if (payload.legacy()) ** GOTO lbl24
                if (0 <= payload.maxVersion() && payload.minVersion() <= 2) {
                    vivePlayer.networkVersion = Math.min(payload.maxVersion(), 2);
                    if (((Boolean)ServerConfig.DEBUG.get()).booleanValue()) {
                        ServerNetworking.LOGGER.info("Vivecraft: {} networking supported, using version {}", (Object)player.method_5477().getString(), (Object)vivePlayer.networkVersion);
                    }
                } else {
                    player.method_43496((class_2561)class_2561.method_43470((String)"Unsupported vivecraft version, VR features will not work"));
                    if (((Boolean)ServerConfig.DEBUG.get()).booleanValue()) {
                        ServerNetworking.LOGGER.info("Vivecraft: {} networking not supported. client range [{},{}], server range [{},{}]", new Object[]{player.method_5820(), payload.minVersion(), payload.maxVersion(), 0, 2});
                    }
                    return;
lbl24:
                    // 1 sources

                    vivePlayer.networkVersion = -1;
                    if (((Boolean)ServerConfig.DEBUG.get()).booleanValue()) {
                        ServerNetworking.LOGGER.info("Vivecraft: {} using legacy networking", (Object)player.method_5820());
                    }
                }
                vivePlayer.setVR(payload.vr());
                ServerVRPlayers.getPlayersWithVivecraft(player.field_13995).put(player.method_5667(), vivePlayer);
                packetConsumer.accept(new VersionPayloadS2C(CommonDataHolder.getInstance().versionIdentifier));
                packetConsumer.accept(new RequestDataPayloadS2C());
                if (((Boolean)ServerConfig.CLIMBEY_ENABLED.get()).booleanValue()) {
                    packetConsumer.accept(ServerNetworking.getClimbeyServerPayload());
                }
                if (((Boolean)ServerConfig.TELEPORT_ENABLED.get()).booleanValue()) {
                    packetConsumer.accept(new TeleportPayloadS2C());
                }
                if (((Boolean)ServerConfig.TELEPORT_LIMITED_SURVIVAL.get()).booleanValue()) {
                    packetConsumer.accept(new SettingOverridePayloadS2C(Map.of("limitedTeleport", "true", "teleportLimitUp", String.valueOf(ServerConfig.TELEPORT_UP_LIMIT.get()), "teleportLimitDown", String.valueOf(ServerConfig.TELEPORT_DOWN_LIMIT.get()), "teleportLimitHoriz", String.valueOf(ServerConfig.TELEPORT_HORIZONTAL_LIMIT.get()))));
                }
                if (((Boolean)ServerConfig.WORLDSCALE_LIMITED.get()).booleanValue()) {
                    packetConsumer.accept(new SettingOverridePayloadS2C(Map.of("worldScale.min", String.valueOf(ServerConfig.WORLDSCALE_MIN.get()), "worldScale.max", String.valueOf(ServerConfig.WORLDSCALE_MAX.get()))));
                }
                if (((Boolean)ServerConfig.FORCE_THIRD_PERSON_ITEMS.get()).booleanValue()) {
                    packetConsumer.accept(new SettingOverridePayloadS2C(Map.of("thirdPersonItems", "true")));
                }
                if (((Boolean)ServerConfig.FORCE_THIRD_PERSON_ITEMS_CUSTOM.get()).booleanValue()) {
                    packetConsumer.accept(new SettingOverridePayloadS2C(Map.of("thirdPersonItemsCustom", "true")));
                }
                if (((Boolean)ServerConfig.CRAWLING_ENABLED.get()).booleanValue()) {
                    packetConsumer.accept(new CrawlPayloadS2C());
                }
                packetConsumer.accept(new VRSwitchingPayloadS2C((Boolean)ServerConfig.VR_SWITCHING_ENABLED.get() != false && (Boolean)ServerConfig.VR_ONLY.get() == false));
                if (vivePlayer.networkVersion >= 2) {
                    packetConsumer.accept(new DualWieldingPayloadS2C((Boolean)ServerConfig.DUAL_WIELDING.get()));
                }
                packetConsumer.accept(new NetworkVersionPayloadS2C(vivePlayer.networkVersion));
                break;
            }
            case 2: {
                payload = (VRActivePayloadC2S)c2sPayload;
                if (vivePlayer.isVR() == payload.vr()) break;
                vivePlayer.setVR(vivePlayer.isVR() == false);
                if (vivePlayer.isVR()) break;
                ServerNetworking.sendPacketToTrackingPlayers(vivePlayer, new VRActivePayloadS2C(false, player.method_5667()));
                break;
            }
            case 3: {
                vivePlayer.draw = ((DrawPayloadC2S)c2sPayload).draw();
                break;
            }
            case 4: {
                vivePlayer.vrPlayerState = ((VRPlayerStatePayloadC2S)c2sPayload).playerState();
                break;
            }
            case 5: {
                vivePlayer.worldScale = ((WorldScalePayloadC2S)c2sPayload).worldScale();
                break;
            }
            case 6: {
                vivePlayer.heightScale = ((HeightPayloadC2S)c2sPayload).heightScale();
                break;
            }
            case 7: {
                payload = (TeleportPayloadC2S)c2sPayload;
                player.method_5641((double)payload.x(), (double)payload.y(), (double)payload.z(), player.method_36454(), player.method_36455());
                break;
            }
            case 8: {
                player.field_6017 = 0.0f;
                player.field_13987.field_14138 = 0;
                break;
            }
            case 9: {
                v0 = newBodyPart = vivePlayer.isSeated() != false ? BodyPart.MAIN_HAND : ((ActiveBodyPartPayloadC2S)c2sPayload).bodyPart();
                if (vivePlayer.activeBodyPart == newBodyPart) break;
                oldItem = player.method_6118(class_1304.field_6173);
                vivePlayer.activeBodyPart = newBodyPart;
                newItem = player.method_6118(class_1304.field_6173);
                if (!player.method_45324(oldItem, newItem)) break;
                attributeMap = player.method_6127();
                if (!oldItem.method_7960()) {
                    oldItem.method_57354(class_1304.field_6173, (BiConsumer<class_6880, class_1322>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)V, lambda$handlePacket$0(net.minecraft.class_5131 net.minecraft.class_6880 net.minecraft.class_1322 ), (Lnet/minecraft/class_6880;Lnet/minecraft/class_1322;)V)((class_5131)attributeMap));
                }
                if (newItem.method_7960()) break;
                newItem.method_57354(class_1304.field_6173, (BiConsumer<class_6880, class_1322>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)V, lambda$handlePacket$1(net.minecraft.class_5131 net.minecraft.class_6880 net.minecraft.class_1322 ), (Lnet/minecraft/class_6880;Lnet/minecraft/class_1322;)V)((class_5131)attributeMap));
                break;
            }
            case 10: {
                vivePlayer.crawling = ((CrawlPayloadC2S)c2sPayload).crawling();
                if (!vivePlayer.crawling) break;
                player.method_18380(class_4050.field_18079);
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                playerData = ServerNetworking.LEGACY_DATA_MAP.get(player.method_5667());
                if (playerData == null) {
                    playerData = new HashMap<PayloadIdentifier, VivecraftPayloadC2S>();
                    ServerNetworking.LEGACY_DATA_MAP.put(player.method_5667(), playerData);
                }
                playerData.put(c2sPayload.payloadId(), c2sPayload);
                if (playerData.size() != 3) break;
                controller0Data = (LegacyController0DataPayloadC2S)playerData.get((Object)PayloadIdentifier.CONTROLLER0DATA);
                controller1Data = (LegacyController1DataPayloadC2S)playerData.get((Object)PayloadIdentifier.CONTROLLER1DATA);
                headData = (LegacyHeadDataPayloadC2S)playerData.get((Object)PayloadIdentifier.HEADDATA);
                vivePlayer.vrPlayerState = new VrPlayerState(headData.seated(), headData.hmdPose(), controller0Data.leftHanded(), controller0Data.mainHand(), controller1Data.leftHanded(), controller1Data.offHand(), FBTMode.ARMS_ONLY, null, null, null, null, null, null, null);
                ServerNetworking.LEGACY_DATA_MAP.remove(player.method_5667());
                break;
            }
            default: {
                throw new IllegalStateException("Vivecraft: got unexpected packet on server: " + String.valueOf((Object)c2sPayload.payloadId()));
            }
        }
    }

    public static VivecraftPayloadS2C getClimbeyServerPayload() {
        ArrayList<String> blocks = null;
        if (ServerConfig.CLIMBEY_BLOCKMODE.get() != ClimbeyBlockmode.DISABLED) {
            blocks = new ArrayList<String>();
            for (String block : (List)ServerConfig.CLIMBEY_BLOCKLIST.get()) {
                try {
                    class_2248 b = (class_2248)class_7923.field_41175.method_10223(class_2960.method_60654((String)block));
                    if (b == class_2246.field_10124) continue;
                    blocks.add(block);
                }
                catch (class_151 class_1512) {}
            }
        }
        return new ClimbingPayloadS2C(true, (ClimbeyBlockmode)((Object)ServerConfig.CLIMBEY_BLOCKMODE.get()), blocks);
    }

    public static void sendVrPlayerStateToClients(ServerVivePlayer vivePlayer) {
        class_2596<?> legacyPacket = Xplat.getS2CPacket(new UberPacketPayloadS2C(vivePlayer.player.method_5667(), new VrPlayerState(vivePlayer.vrPlayerState, 0), vivePlayer.worldScale, vivePlayer.heightScale));
        class_2596<?> newPacket = Xplat.getS2CPacket(new UberPacketPayloadS2C(vivePlayer.player.method_5667(), vivePlayer.vrPlayerState, vivePlayer.worldScale, vivePlayer.heightScale));
        ServerNetworking.sendPacketToTrackingPlayers(vivePlayer, (Integer version) -> version < 1 ? legacyPacket : newPacket);
    }

    public static Set<class_5629> getTrackingPlayers(class_3222 player) {
        class_3898 chunkMap = player.method_51469().method_14178().field_17254;
        TrackedEntityAccessor playerTracker = (TrackedEntityAccessor)((ChunkMapAccessor)chunkMap).getTrackedEntities().get(player.method_5628());
        return playerTracker != null ? Collections.unmodifiableSet(playerTracker.getPlayersTracking()) : Collections.emptySet();
    }

    private static void sendPacketToTrackingPlayers(ServerVivePlayer vivePlayer, VivecraftPayloadS2C payload) {
        class_2596<?> packet = Xplat.getS2CPacket(payload);
        ServerNetworking.sendPacketToTrackingPlayers(vivePlayer, (Integer v) -> packet);
    }

    private static void sendPacketToTrackingPlayers(ServerVivePlayer vivePlayer, Function<Integer, class_2596<?>> packetProvider) {
        Map<UUID, ServerVivePlayer> vivePlayers = ServerVRPlayers.getPlayersWithVivecraft(vivePlayer.player.field_13995);
        for (class_5629 trackedPlayer : ServerNetworking.getTrackingPlayers(vivePlayer.player)) {
            if (!vivePlayers.containsKey(trackedPlayer.method_32311().method_5667()) || trackedPlayer.method_32311() == vivePlayer.player) continue;
            trackedPlayer.method_14364(packetProvider.apply(vivePlayer.networkVersion));
        }
        if (((Boolean)ServerConfig.SEND_DATA_TO_OWNER.get()).booleanValue() || Xplat.isModLoaded("replaymod") || Xplat.isModLoaded("reforgedplaymod") || Xplat.isModLoaded("flashback")) {
            vivePlayer.player.field_13987.method_14364(packetProvider.apply(vivePlayer.networkVersion));
        }
    }

    private static /* synthetic */ void lambda$handlePacket$1(class_5131 attributeMap, class_6880 holder, class_1322 attributeModifier) {
        class_1324 attributeInstance = attributeMap.method_45329(holder);
        if (attributeInstance != null) {
            attributeInstance.method_6200(attributeModifier.comp_2447());
            attributeInstance.method_26835(attributeModifier);
        }
    }

    private static /* synthetic */ void lambda$handlePacket$0(class_5131 attributeMap, class_6880 holder, class_1322 attributeModifier) {
        class_1324 attributeInstance = attributeMap.method_45329(holder);
        if (attributeInstance != null) {
            attributeInstance.method_6202(attributeModifier);
        }
    }
}

