/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.mod_compat_vr.sodium;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraft.class_1058;
import net.minecraft.class_630;
import org.joml.Vector2f;
import org.vivecraft.client.Xplat;
import org.vivecraft.client_vr.settings.VRSettings;
import org.vivecraft.mod_compat_vr.sodium.extensions.ModelCuboidExtension;

public class SodiumHelper {
    private static boolean INITIALIZED = false;
    private static boolean INIT_FAILED = false;
    private static Method SpriteUtil_markSpriteActive;
    private static boolean HAS_MODELCUBOID_QUADS;
    private static boolean HAS_MODELCUBOID_FLOATS;
    private static boolean HAS_MODELCUBOID_CUBES;
    private static Field ModelPart_sodium$cuboids;
    private static Field ModelCuboid_quads;
    private static Field Cube_sodium$cuboid;
    private static Field ModelCuboid_u0;
    private static Field ModelCuboid_u1;
    private static Field ModelCuboid_u2;
    private static Field ModelCuboid_u3;
    private static Field ModelCuboid_u4;
    private static Field ModelCuboid_u5;
    private static Field ModelCuboid_v0;
    private static Field ModelCuboid_v1;
    private static Field ModelCuboid_v2;
    private static Field ModelCuboid$Quad_textures;

    public static boolean isLoaded() {
        return Xplat.isModLoaded("sodium") || Xplat.isModLoaded("rubidium") || Xplat.isModLoaded("embeddium");
    }

    public static boolean hasIssuesWithParallelBlockBuilding() {
        try {
            Class.forName("me.jellysquid.mods.sodium.client.render.immediate.model.BakedModelEncoder");
            return true;
        }
        catch (ClassNotFoundException ignored) {
            return false;
        }
    }

    public static void markTextureAsActive(class_1058 sprite) {
        if (SodiumHelper.init()) {
            try {
                SpriteUtil_markSpriteActive.invoke(null, sprite);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                VRSettings.LOGGER.error("Vivecraft: couldn't set Sodium sprite as animated:", (Throwable)e);
            }
        }
    }

    public static void copyModelCuboidUV(class_630 source, class_630 dest, int sourcePoly, int destPoly) {
        if (SodiumHelper.init()) {
            try {
                if (HAS_MODELCUBOID_QUADS) {
                    Object sourceQuad = ((Object[])ModelCuboid_quads.get(((Object[])ModelPart_sodium$cuboids.get(source))[0]))[sourcePoly];
                    Object destQuad = ((Object[])ModelCuboid_quads.get(((Object[])ModelPart_sodium$cuboids.get(dest))[0]))[destPoly];
                    Vector2f[] sourceTextures = (Vector2f[])ModelCuboid$Quad_textures.get(sourceQuad);
                    Vector2f[] destTextures = (Vector2f[])ModelCuboid$Quad_textures.get(destQuad);
                    for (int i = 0; i < sourceTextures.length; ++i) {
                        destTextures[i].x = sourceTextures[i].x;
                        destTextures[i].y = sourceTextures[i].y;
                    }
                } else if (HAS_MODELCUBOID_FLOATS) {
                    Object sourceCuboid = HAS_MODELCUBOID_CUBES ? Cube_sodium$cuboid.get(source.field_3663.get(0)) : ((Object[])ModelPart_sodium$cuboids.get(source))[0];
                    float[][] UVs = new float[][]{{((Float)ModelCuboid_u0.get(sourceCuboid)).floatValue(), ((Float)ModelCuboid_u1.get(sourceCuboid)).floatValue(), ((Float)ModelCuboid_u2.get(sourceCuboid)).floatValue(), ((Float)ModelCuboid_u3.get(sourceCuboid)).floatValue(), ((Float)ModelCuboid_u4.get(sourceCuboid)).floatValue(), ((Float)ModelCuboid_u5.get(sourceCuboid)).floatValue()}, {((Float)ModelCuboid_v0.get(sourceCuboid)).floatValue(), ((Float)ModelCuboid_v1.get(sourceCuboid)).floatValue(), ((Float)ModelCuboid_v2.get(sourceCuboid)).floatValue()}};
                    Object destCuboid = HAS_MODELCUBOID_CUBES ? Cube_sodium$cuboid.get(dest.field_3663.get(0)) : ((Object[])ModelPart_sodium$cuboids.get(dest))[0];
                    ((ModelCuboidExtension)destCuboid).vivecraft$addOverrides(SodiumHelper.mapDirection(destPoly), SodiumHelper.mapDirection(sourcePoly), UVs);
                }
            }
            catch (ClassCastException | IllegalAccessException e) {
                VRSettings.LOGGER.error("Vivecraft: sodium version has ModelCuboids, but fields are an unexpected type. VR hands will probably look wrong:", (Throwable)e);
                HAS_MODELCUBOID_FLOATS = false;
                HAS_MODELCUBOID_QUADS = false;
            }
        }
    }

    private static int mapDirection(int old) {
        return switch (old) {
            case 1 -> 2;
            case 2 -> 0;
            case 3 -> 1;
            case 4 -> 3;
            case 5 -> 5;
            default -> 4;
        };
    }

    private static boolean init() {
        if (INITIALIZED) {
            return !INIT_FAILED;
        }
        try {
            Class<?> spriteUtil = SodiumHelper.getClassWithAlternative("me.jellysquid.mods.sodium.client.render.texture.SpriteUtil", "net.caffeinemc.mods.sodium.client.render.texture.SpriteUtil");
            SpriteUtil_markSpriteActive = spriteUtil.getMethod("markSpriteActive", class_1058.class);
            try {
                Class<?> ModelCuboid = SodiumHelper.getClassWithAlternative("me.jellysquid.mods.sodium.client.render.immediate.model.ModelCuboid", "net.caffeinemc.mods.sodium.client.render.immediate.model.ModelCuboid");
                try {
                    ModelPart_sodium$cuboids = class_630.class.getDeclaredField("sodium$cuboids");
                    ModelPart_sodium$cuboids.setAccessible(true);
                }
                catch (NoSuchFieldException ignored) {
                    Cube_sodium$cuboid = class_630.class_628.class.getDeclaredField("sodium$cuboid");
                    Cube_sodium$cuboid.setAccessible(true);
                    HAS_MODELCUBOID_CUBES = true;
                }
                try {
                    Class<?> ModelCuboid$Quad = SodiumHelper.getClassWithAlternative("me.jellysquid.mods.sodium.client.render.immediate.model.ModelCuboid$Quad", "net.caffeinemc.mods.sodium.client.render.immediate.model.ModelCuboid$Quad");
                    ModelCuboid_quads = ModelCuboid.getDeclaredField("quads");
                    ModelCuboid$Quad_textures = ModelCuboid$Quad.getDeclaredField("textures");
                    HAS_MODELCUBOID_QUADS = true;
                }
                catch (ClassNotFoundException noQuads) {
                    ModelCuboid_u0 = ModelCuboid.getDeclaredField("u0");
                    ModelCuboid_u1 = ModelCuboid.getDeclaredField("u1");
                    ModelCuboid_u2 = ModelCuboid.getDeclaredField("u2");
                    ModelCuboid_u3 = ModelCuboid.getDeclaredField("u3");
                    ModelCuboid_u4 = ModelCuboid.getDeclaredField("u4");
                    ModelCuboid_u5 = ModelCuboid.getDeclaredField("u5");
                    ModelCuboid_v0 = ModelCuboid.getDeclaredField("v0");
                    ModelCuboid_v1 = ModelCuboid.getDeclaredField("v1");
                    ModelCuboid_v2 = ModelCuboid.getDeclaredField("v2");
                    HAS_MODELCUBOID_FLOATS = true;
                }
            }
            catch (ClassNotFoundException ModelCuboid) {
            }
            catch (NoSuchFieldException e) {
                VRSettings.LOGGER.error("Vivecraft: sodium version has ModelCuboids, but some fields are not found. VR hands will probably look wrong:", (Throwable)e);
            }
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            INIT_FAILED = true;
            VRSettings.LOGGER.error("Vivecraft: Failed to initialize Sodium compat:", (Throwable)e);
        }
        INITIALIZED = true;
        return !INIT_FAILED;
    }

    private static Class<?> getClassWithAlternative(String class1, String class2) throws ClassNotFoundException {
        try {
            return Class.forName(class1);
        }
        catch (ClassNotFoundException e) {
            return Class.forName(class2);
        }
    }
}

