/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.mixin.client_vr.multiplayer;

import net.minecraft.class_243;
import net.minecraft.class_2535;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_634;
import net.minecraft.class_7438;
import net.minecraft.class_7439;
import net.minecraft.class_7923;
import net.minecraft.class_8673;
import net.minecraft.class_8675;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.vivecraft.client.network.ClientNetworking;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.VRState;
import org.vivecraft.client_vr.gameplay.screenhandlers.GuiHandler;
import org.vivecraft.client_vr.provider.ControllerType;
import org.vivecraft.client_vr.settings.VRSettings;

@Mixin(value={class_634.class})
public abstract class ClientPacketListenerVRMixin
extends class_8673 {
    @Unique
    private String vivecraft$lastMsg = null;

    protected ClientPacketListenerVRMixin(class_310 minecraft, class_2535 connection, class_8675 commonListenerCookie) {
        super(minecraft, connection, commonListenerCookie);
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void vivecraft$init(CallbackInfo ci) {
        if (ClientNetworking.NEEDS_RESET) {
            ClientNetworking.resetServerSettings();
            ClientNetworking.DISPLAYED_CHAT_MESSAGE = false;
            ClientNetworking.DISPLAYED_CHAT_WARNING = false;
            ClientNetworking.NEEDS_RESET = false;
        }
    }

    @Inject(method={"handleLogin"}, at={@At(value="TAIL")})
    private void vivecraft$resetOnLogin(CallbackInfo ci) {
        ClientNetworking.resetServerSettings();
        ClientNetworking.sendVersionInfo();
        if (VRState.VR_INITIALIZED) {
            ClientDataHolderVR.getInstance().vrPlayer.chatWarningTimer = 200;
            ClientDataHolderVR.getInstance().vrPlayer.teleportWarning = true;
            ClientDataHolderVR.getInstance().vrPlayer.vrSwitchWarning = false;
        }
    }

    @Inject(method={"handleRespawn"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/Minecraft;setLevel(Lnet/minecraft/client/multiplayer/ClientLevel;Lnet/minecraft/client/gui/screens/ReceivingLevelScreen$Reason;)V", shift=At.Shift.AFTER)})
    private void vivecraft$resetOnDimensionChange(CallbackInfo ci) {
        ClientNetworking.resetServerSettings();
        ClientNetworking.sendVersionInfo();
        if (VRState.VR_INITIALIZED) {
            ClientDataHolderVR.getInstance().vrPlayer.chatWarningTimer = 200;
            ClientDataHolderVR.getInstance().vrPlayer.teleportWarning = true;
            ClientDataHolderVR.getInstance().vrPlayer.vrSwitchWarning = false;
        }
    }

    @Inject(method={"close"}, at={@At(value="TAIL")})
    private void vivecraft$cleanup(CallbackInfo ci) {
        ClientNetworking.resetServerSettings();
        ClientNetworking.DISPLAYED_CHAT_MESSAGE = false;
        ClientNetworking.DISPLAYED_CHAT_WARNING = false;
        ClientNetworking.NEEDS_RESET = true;
    }

    @Inject(method={"sendChat"}, at={@At(value="TAIL")})
    private void vivecraft$storeChatMsg(String message, CallbackInfo ci) {
        this.vivecraft$lastMsg = message;
    }

    @Inject(method={"sendCommand"}, at={@At(value="TAIL")})
    private void vivecraft$storeCommandMsg(String command, CallbackInfo ci) {
        this.vivecraft$lastMsg = command;
    }

    @Inject(method={"handlePlayerChat"}, at={@At(value="TAIL")})
    private void vivecraft$chatHapticsPlayer(class_7438 packet, CallbackInfo ci) {
        if (VRState.VR_RUNNING && (this.field_45588.field_1724 == null || this.vivecraft$lastMsg == null || packet.comp_1099() == this.field_45588.field_1724.method_5667())) {
            this.vivecraft$triggerHapticSound();
        }
        this.vivecraft$lastMsg = null;
    }

    @Inject(method={"handleSystemChat"}, at={@At(value="TAIL")})
    private void vivecraft$chatHapticsSystem(class_7439 packet, CallbackInfo ci) {
        if (VRState.VR_RUNNING && (this.field_45588.field_1724 == null || this.vivecraft$lastMsg == null || packet.comp_763().getString().contains(this.vivecraft$lastMsg))) {
            this.vivecraft$triggerHapticSound();
        }
        this.vivecraft$lastMsg = null;
    }

    @Unique
    private void vivecraft$triggerHapticSound() {
        ClientDataHolderVR dataHolder = ClientDataHolderVR.getInstance();
        if (dataHolder.vrSettings.chatNotifications != VRSettings.ChatNotifications.NONE) {
            if (!(dataHolder.vrSettings.seated || dataHolder.vrSettings.chatNotifications != VRSettings.ChatNotifications.HAPTIC && dataHolder.vrSettings.chatNotifications != VRSettings.ChatNotifications.BOTH)) {
                dataHolder.vr.triggerHapticPulse(ControllerType.LEFT, 0.2f, 1000.0f, 1.0f);
            }
            if (dataHolder.vrSettings.chatNotifications == VRSettings.ChatNotifications.SOUND || dataHolder.vrSettings.chatNotifications == VRSettings.ChatNotifications.BOTH) {
                class_243 controllerPos = dataHolder.vrPlayer.vrdata_world_pre.getController(1).getPosition();
                this.field_45588.field_1687.method_8486(controllerPos.method_10216(), controllerPos.method_10214(), controllerPos.method_10215(), (class_3414)class_7923.field_41172.method_10223(class_2960.method_60654((String)dataHolder.vrSettings.chatNotificationSound)), class_3419.field_15254, 0.3f, 0.1f, false);
            }
        }
    }

    @Inject(method={"handleOpenScreen"}, at={@At(value="HEAD")})
    private void vivecraft$markScreenActive(CallbackInfo ci) {
        GuiHandler.GUI_APPEAR_OVER_BLOCK_ACTIVE = true;
    }
}

