/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.common.utils;

import net.minecraft.class_243;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class MathUtils {
    public static final Vector3fc FORWARD = new Vector3f(0.0f, 0.0f, 1.0f);
    public static final Vector3fc BACK = new Vector3f(0.0f, 0.0f, -1.0f);
    public static final Vector3fc LEFT = new Vector3f(1.0f, 0.0f, 0.0f);
    public static final Vector3fc RIGHT = new Vector3f(-1.0f, 0.0f, 0.0f);
    public static final Vector3fc UP = new Vector3f(0.0f, 1.0f, 0.0f);
    public static final Vector3fc DOWN = new Vector3f(0.0f, -1.0f, 0.0f);
    public static final Vector3fc ZERO = new Vector3f();
    public static final class_243 FORWARD_D = new class_243(0.0, 0.0, 1.0);
    public static final class_243 BACK_D = new class_243(0.0, 0.0, -1.0);
    public static final class_243 LEFT_D = new class_243(1.0, 0.0, 0.0);
    public static final class_243 RIGHT_D = new class_243(-1.0, 0.0, 0.0);
    public static final class_243 UP_D = new class_243(0.0, 1.0, 0.0);
    public static final class_243 DOWN_D = new class_243(0.0, -1.0, 0.0);
    public static final Matrix4fc IDENTITY = new Matrix4f();

    public static Vector3f subtractToVector3f(class_243 a, class_243 b) {
        return new Vector3f((float)(a.field_1352 - b.field_1352), (float)(a.field_1351 - b.field_1351), (float)(a.field_1350 - b.field_1350));
    }

    public static double lerpMod(double from, double to, double percent, double mod) {
        return Math.abs(to - from) < mod / 2.0 ? from + (to - from) * percent : from + (to - from - Math.signum(to - from) * mod) * percent;
    }

    public static float angleDiff(float a, float b) {
        float d = Math.abs(a - b) % 360.0f;
        float r = d > 180.0f ? 360.0f - d : d;
        float diff = a - b;
        int sign = diff >= 0.0f && diff <= 180.0f || diff <= -180.0f && diff >= -360.0f ? 1 : -1;
        return r * (float)sign;
    }

    public static float angleNormalize(float angle) {
        if ((angle %= 360.0f) < 0.0f) {
            angle += 360.0f;
        }
        return angle;
    }

    public static float wrapRadians(float value) {
        float wrapped = value % ((float)Math.PI * 2);
        if (wrapped >= (float)Math.PI) {
            wrapped -= (float)Math.PI * 2;
        }
        if (wrapped < (float)(-Math.PI)) {
            wrapped += (float)Math.PI * 2;
        }
        return wrapped;
    }

    public static float rotLerpRad(float delta, float start, float end) {
        return start + delta * MathUtils.wrapRadians(end - start);
    }

    public static class_243 vecDLerp(class_243 start, class_243 end, double fraction) {
        double x = start.field_1352 + (end.field_1352 - start.field_1352) * fraction;
        double y = start.field_1351 + (end.field_1351 - start.field_1351) * fraction;
        double z = start.field_1350 + (end.field_1350 - start.field_1350) * fraction;
        return new class_243(x, y, z);
    }

    public static Vector3f vecLerp(Vector3f start, float endX, float endY, float endZ, float fraction) {
        return start.set(start.x + (endX - start.x) * fraction, start.y + (endY - start.y) * fraction, start.z + (endZ - start.z) * fraction);
    }

    public static float applyDeadzone(float axis, float deadzone) {
        if (Math.abs(axis) > deadzone) {
            float scalar = 1.0f / (1.0f - deadzone);
            return (Math.abs(axis) - deadzone) * scalar * Math.signum(axis);
        }
        return 0.0f;
    }

    public static float normalizedDotXZ(Vector3fc a, Vector3fc b) {
        return (a.x() * b.x() + a.z() * b.z()) / (float)Math.sqrt((a.x() * a.x() + a.z() * a.z()) * (b.x() * b.x() + b.z() * b.z()));
    }

    public static void rotateX(Vector3f v, float sin, float cos) {
        float ogY = v.y;
        v.y = ogY * cos - v.z * sin;
        v.z = ogY * sin + v.z * cos;
    }

    public static Vector3f getEulerAnglesYZX(Quaternionf rot) {
        return new Vector3f((float)Math.asin(-2.0f * (rot.y * rot.z - rot.w * rot.x)), (float)Math.atan2(2.0f * (rot.x * rot.z + rot.w * rot.y), rot.w * rot.w - rot.x * rot.x - rot.y * rot.y + rot.z * rot.z), (float)Math.atan2(2.0f * (rot.x * rot.y + rot.w * rot.z), rot.w * rot.w - rot.x * rot.x + rot.y * rot.y - rot.z * rot.z));
    }

    public static Vector3f getEulerAnglesZYX(Quaternionfc rot, Vector3f eulerAngles) {
        eulerAngles.x = org.joml.Math.atan2((float)(rot.y() * rot.z() + rot.w() * rot.x()), (float)(0.5f - rot.x() * rot.x() - rot.y() * rot.y()));
        eulerAngles.y = org.joml.Math.safeAsin((float)(-2.0f * (rot.x() * rot.z() - rot.w() * rot.y())));
        eulerAngles.z = org.joml.Math.atan2((float)(rot.x() * rot.y() + rot.w() * rot.z()), (float)(0.5f - rot.y() * rot.y() - rot.z() * rot.z()));
        return eulerAngles;
    }

    public static Matrix4f addTranslation(Matrix4f matrix, Vector3f translation) {
        return matrix.m30(matrix.m30() + translation.x).m31(matrix.m31() + translation.y).m32(matrix.m32() + translation.z);
    }

    public static float bodyYawRad(Vector3fc rightHand, Vector3fc leftHand, Vector3fc headDir) {
        Vector3f dir = leftHand.add(rightHand, new Vector3f());
        float hDot = MathUtils.normalizedDotXZ((Vector3fc)dir, headDir);
        Vector3f armsForward = leftHand.sub(rightHand, new Vector3f()).rotateY(-1.5707964f);
        if (armsForward.dot(headDir) < 0.0f) {
            armsForward.mul(-1.0f);
        }
        armsForward.lerp((Vector3fc)dir, Math.max(0.0f, hDot), dir);
        dir.normalize().lerp(headDir, 0.5f, dir);
        return (float)Math.atan2(-dir.x, dir.z);
    }
}

