/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.common.network;

import org.vivecraft.common.network.FBTMode;

public enum BodyPart {
    MAIN_HAND,
    OFF_HAND,
    RIGHT_FOOT,
    LEFT_FOOT,
    WAIST,
    RIGHT_KNEE,
    LEFT_KNEE,
    RIGHT_ELBOW,
    LEFT_ELBOW;


    public BodyPart opposite() {
        return switch (this.ordinal()) {
            case 0 -> OFF_HAND;
            case 1 -> MAIN_HAND;
            case 2 -> LEFT_FOOT;
            case 3 -> RIGHT_FOOT;
            case 5 -> LEFT_KNEE;
            case 6 -> RIGHT_KNEE;
            case 7 -> LEFT_ELBOW;
            case 8 -> RIGHT_ELBOW;
            default -> this;
        };
    }

    public boolean isValid(FBTMode fbtMode) {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0, 1 -> true;
            case 2, 3, 4 -> {
                if (fbtMode != FBTMode.ARMS_ONLY) {
                    yield true;
                }
                yield false;
            }
            case 5, 6, 7, 8 -> fbtMode == FBTMode.WITH_JOINTS;
        };
    }

    public boolean isFoot() {
        return this == RIGHT_FOOT || this == LEFT_FOOT;
    }

    public boolean isHand() {
        return this == MAIN_HAND || this == OFF_HAND;
    }
}

