/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.render.helpers;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5348;
import net.minecraft.class_757;
import net.minecraft.class_9801;
import org.apache.commons.lang3.tuple.Triple;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.vivecraft.client.ClientVRPlayers;
import org.vivecraft.client.gui.screens.FBTCalibrationScreen;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.VRData;
import org.vivecraft.client_vr.extensions.GameRendererExtension;
import org.vivecraft.client_vr.gameplay.VRPlayer;
import org.vivecraft.client_vr.gameplay.trackers.TelescopeTracker;
import org.vivecraft.client_vr.provider.DeviceSource;
import org.vivecraft.client_vr.provider.MCVR;
import org.vivecraft.client_vr.render.RenderPass;
import org.vivecraft.client_vr.render.helpers.RenderHelper;
import org.vivecraft.common.network.FBTMode;
import org.vivecraft.common.utils.MathUtils;

public class DebugRenderHelper {
    private static final ClientDataHolderVR DATA_HOLDER = ClientDataHolderVR.getInstance();
    private static final class_310 MC = class_310.method_1551();
    private static final Vector3fc RED = new Vector3f(1.0f, 0.0f, 0.0f);
    private static final Vector3fc GREEN = new Vector3f(0.0f, 1.0f, 0.0f);
    private static final Vector3fc BLUE = new Vector3f(0.0f, 0.0f, 1.0f);
    private static final Vector3fc DARK_GRAY = new Vector3f(0.25f);

    public static void renderDebug(float partialTick) {
        if (DebugRenderHelper.DATA_HOLDER.vrSettings.renderDeviceAxes) {
            DebugRenderHelper.renderDeviceAxes(DebugRenderHelper.DATA_HOLDER.vrPlayer.getVRDataWorld());
        }
        if (DebugRenderHelper.DATA_HOLDER.vrSettings.renderVrPlayerAxes) {
            DebugRenderHelper.renderPlayerAxes(partialTick);
        }
        if (DebugRenderHelper.DATA_HOLDER.vrSettings.renderTrackerPositions || DebugRenderHelper.MC.field_1755 instanceof FBTCalibrationScreen) {
            boolean showNames = true;
            class_437 class_4372 = DebugRenderHelper.MC.field_1755;
            if (class_4372 instanceof FBTCalibrationScreen) {
                FBTCalibrationScreen fbtScreen = (FBTCalibrationScreen)class_4372;
                showNames = fbtScreen.isCalibrated();
            }
            DebugRenderHelper.renderTackerPositions(showNames);
        }
    }

    public static void renderPlayerAxes(float partialTick) {
        if (DebugRenderHelper.MC.field_1724 != null) {
            class_287 bufferbuilder = null;
            class_243 camPos = RenderHelper.getSmoothCameraPosition(DebugRenderHelper.DATA_HOLDER.currentPass, DebugRenderHelper.DATA_HOLDER.vrPlayer.getVRDataWorld());
            for (class_1657 p : DebugRenderHelper.MC.field_1724.method_37908().method_18456()) {
                if (!ClientVRPlayers.getInstance().isVRPlayer((class_1297)p)) continue;
                ClientVRPlayers.RotInfo info = ClientVRPlayers.getInstance().getRotationsForPlayer(p.method_5667());
                if (bufferbuilder == null) {
                    RenderSystem.setShader(class_757::method_34540);
                    bufferbuilder = class_289.method_1348().method_60827(class_293.class_5596.field_29345, class_290.field_1576);
                }
                Vector3f playerPos = p.method_30950(partialTick).method_1020(camPos).method_46409();
                if (p == DebugRenderHelper.MC.field_1724) {
                    playerPos = ((GameRendererExtension)DebugRenderHelper.MC.field_1773).vivecraft$getRvePos(partialTick).method_1020(camPos).method_46409();
                }
                if (p != DebugRenderHelper.MC.field_1724 || DebugRenderHelper.DATA_HOLDER.currentPass == RenderPass.THIRD) {
                    DebugRenderHelper.addAxes(bufferbuilder, (Vector3fc)playerPos, info.headPos, info.headRot, info.headQuat);
                }
                if (!info.seated) {
                    DebugRenderHelper.addAxes(bufferbuilder, (Vector3fc)playerPos, info.mainHandPos, info.mainHandRot, info.mainHandQuat);
                    DebugRenderHelper.addAxes(bufferbuilder, (Vector3fc)playerPos, info.offHandPos, info.offHandRot, info.offHandQuat);
                }
                if (info.fbtMode != FBTMode.ARMS_ONLY) {
                    DebugRenderHelper.addAxes(bufferbuilder, (Vector3fc)playerPos, info.waistPos, info.waistQuat);
                    DebugRenderHelper.addAxes(bufferbuilder, (Vector3fc)playerPos, info.rightFootPos, info.rightFootQuat);
                    DebugRenderHelper.addAxes(bufferbuilder, (Vector3fc)playerPos, info.leftFootPos, info.leftFootQuat);
                }
                if (info.fbtMode != FBTMode.WITH_JOINTS) continue;
                DebugRenderHelper.addAxes(bufferbuilder, (Vector3fc)playerPos, info.rightElbowPos, info.rightElbowQuat);
                DebugRenderHelper.addAxes(bufferbuilder, (Vector3fc)playerPos, info.leftElbowPos, info.leftElbowQuat);
                DebugRenderHelper.addAxes(bufferbuilder, (Vector3fc)playerPos, info.rightKneePos, info.rightKneeQuat);
                DebugRenderHelper.addAxes(bufferbuilder, (Vector3fc)playerPos, info.leftKneePos, info.leftKneeQuat);
            }
            if (bufferbuilder != null) {
                class_286.method_43433((class_9801)bufferbuilder.method_60800());
            }
        }
    }

    public static void renderDeviceAxes(VRData data) {
        RenderSystem.setShader(class_757::method_34540);
        class_287 bufferbuilder = class_289.method_1348().method_60827(class_293.class_5596.field_29345, class_290.field_1576);
        ArrayList<VRData.VRDevicePose> list = new ArrayList<VRData.VRDevicePose>();
        list.add(data.c2);
        if (DebugRenderHelper.DATA_HOLDER.currentPass == RenderPass.THIRD) {
            list.add(data.hmd);
        }
        if (DebugRenderHelper.DATA_HOLDER.cameraTracker.isVisible()) {
            list.add(data.cam);
        }
        if (DebugRenderHelper.MC.field_1724 != null && TelescopeTracker.isTelescope(DebugRenderHelper.MC.field_1724.method_6047()) && TelescopeTracker.isViewing(0)) {
            list.add(data.t0);
        } else {
            list.add(DebugRenderHelper.MC.field_1724 != null && DebugRenderHelper.MC.field_1724.method_5715() ? data.h0 : data.c0);
        }
        if (DebugRenderHelper.MC.field_1724 != null && TelescopeTracker.isTelescope(DebugRenderHelper.MC.field_1724.method_6079()) && TelescopeTracker.isViewing(0)) {
            list.add(data.t1);
        } else {
            list.add(DebugRenderHelper.MC.field_1724 != null && DebugRenderHelper.MC.field_1724.method_5715() ? data.h1 : data.c1);
        }
        if (data.fbtMode != FBTMode.ARMS_ONLY) {
            list.add(data.waist);
            list.add(data.foot_left);
            list.add(data.foot_right);
        }
        if (data.fbtMode == FBTMode.WITH_JOINTS) {
            list.add(data.elbow_left);
            list.add(data.knee_left);
            list.add(data.elbow_right);
            list.add(data.knee_right);
        }
        list.forEach(p -> DebugRenderHelper.addAxes(bufferbuilder, data, p));
        class_286.method_43433((class_9801)bufferbuilder.method_60800());
    }

    private static void renderTackerPositions(boolean showNames) {
        VRData data = DebugRenderHelper.DATA_HOLDER.vrPlayer.getVRDataWorld();
        class_243 camPos = RenderHelper.getSmoothCameraPosition(DebugRenderHelper.DATA_HOLDER.currentPass, data);
        Quaternionf orientation = data.getEye(DebugRenderHelper.DATA_HOLDER.currentPass).getMatrix().getNormalizedRotation(new Quaternionf()).rotateY((float)Math.PI);
        class_2561[] labels = new class_2561[]{class_2561.method_43471((String)"vivecraft.toasts.point_controller.right"), class_2561.method_43471((String)"vivecraft.toasts.point_controller.left"), class_2561.method_43471((String)"vivecraft.messages.tracker.camera"), class_2561.method_43471((String)"vivecraft.messages.tracker.waist"), class_2561.method_43471((String)"vivecraft.messages.tracker.rightFoot"), class_2561.method_43471((String)"vivecraft.messages.tracker.leftFoot"), class_2561.method_43471((String)"vivecraft.messages.tracker.rightElbow"), class_2561.method_43471((String)"vivecraft.messages.tracker.leftElbow"), class_2561.method_43471((String)"vivecraft.messages.tracker.rightKnee"), class_2561.method_43471((String)"vivecraft.messages.tracker.leftKnee")};
        for (Triple<DeviceSource, Integer, Matrix4fc> tracker : MCVR.get().getTrackers()) {
            Vector3f pos = ((Matrix4fc)tracker.getRight()).getTranslation(new Vector3f());
            class_243 trackerPos = VRPlayer.roomToWorldPos((Vector3fc)pos, data).method_1020(camPos);
            pos.set((float)trackerPos.field_1352, (float)trackerPos.field_1351, (float)trackerPos.field_1350);
            if (showNames) {
                if ((Integer)tracker.getMiddle() >= 0) {
                    DebugRenderHelper.addNamedCube((Vector3fc)pos, orientation, (class_2561)class_2561.method_43469((String)"vivecraft.formatting.name_value", (Object[])new Object[]{class_2561.method_43470((String)((DeviceSource)tracker.getLeft()).source.toString()), labels[(Integer)tracker.getMiddle()]}), 0.05f, DARK_GRAY);
                    continue;
                }
                DebugRenderHelper.addNamedCube((Vector3fc)pos, orientation, (class_2561)class_2561.method_43469((String)"vivecraft.formatting.name_value", (Object[])new Object[]{class_2561.method_43470((String)(((DeviceSource)tracker.getLeft()).source.toString() + ((DeviceSource)tracker.getLeft()).deviceIndex)), class_2561.method_43471((String)"vivecraft.messages.tracker.unknown")}), 0.05f, DARK_GRAY);
                continue;
            }
            DebugRenderHelper.addCube((Vector3fc)pos, 0.05f, DARK_GRAY);
        }
        MC.method_22940().method_23000().method_37104();
    }

    public static void renderLocalAxes(Matrix4f matrix) {
        RenderSystem.getModelViewStack().pushMatrix().mul((Matrix4fc)matrix);
        RenderSystem.applyModelViewMatrix();
        RenderSystem.setShader(class_757::method_34540);
        class_287 bufferbuilder = class_289.method_1348().method_60827(class_293.class_5596.field_29345, class_290.field_1576);
        Vector3f position = new Vector3f();
        DebugRenderHelper.addLine(bufferbuilder, (Vector3fc)position, MathUtils.BACK, BLUE);
        DebugRenderHelper.addLine(bufferbuilder, (Vector3fc)position, MathUtils.UP, GREEN);
        DebugRenderHelper.addLine(bufferbuilder, (Vector3fc)position, MathUtils.RIGHT, RED);
        class_286.method_43433((class_9801)bufferbuilder.method_60800());
        RenderSystem.getModelViewStack().popMatrix();
        RenderSystem.applyModelViewMatrix();
    }

    private static void addAxes(class_287 bufferBuilder, VRData data, VRData.VRDevicePose pose) {
        Vector3f position = pose.getPosition().method_1020(RenderHelper.getSmoothCameraPosition(DebugRenderHelper.DATA_HOLDER.currentPass, data)).method_46409();
        float scale = 0.25f * DebugRenderHelper.DATA_HOLDER.vrPlayer.worldScale;
        Vector3f forward = pose.getDirection().mul(scale);
        Vector3f up = pose.getCustomVector(MathUtils.UP).mul(scale);
        Vector3f right = pose.getCustomVector(MathUtils.RIGHT).mul(scale);
        DebugRenderHelper.addLine(bufferBuilder, (Vector3fc)position, (Vector3fc)forward, BLUE);
        DebugRenderHelper.addLine(bufferBuilder, (Vector3fc)position, (Vector3fc)up, GREEN);
        DebugRenderHelper.addLine(bufferBuilder, (Vector3fc)position, (Vector3fc)right, RED);
    }

    private static void addAxes(class_287 bufferBuilder, Vector3fc playerPos, Vector3fc devicePos, Quaternionfc rot) {
        DebugRenderHelper.addAxes(bufferBuilder, playerPos, devicePos, (Vector3fc)rot.transform(MathUtils.BACK, new Vector3f()), rot);
    }

    private static void addAxes(class_287 bufferBuilder, Vector3fc playerPos, Vector3fc devicePos, Vector3fc dir, Quaternionfc rot) {
        Vector3f position = playerPos.add(devicePos, new Vector3f());
        float scale = 0.25f * DebugRenderHelper.DATA_HOLDER.vrPlayer.worldScale;
        Vector3f forward = dir.mul(scale, new Vector3f());
        Vector3f up = rot.transform(MathUtils.UP, new Vector3f()).mul(scale);
        Vector3f right = rot.transform(MathUtils.RIGHT, new Vector3f()).mul(scale);
        DebugRenderHelper.addLine(bufferBuilder, (Vector3fc)position, (Vector3fc)forward, BLUE);
        DebugRenderHelper.addLine(bufferBuilder, (Vector3fc)position, (Vector3fc)up, GREEN);
        DebugRenderHelper.addLine(bufferBuilder, (Vector3fc)position, (Vector3fc)right, RED);
    }

    private static void addLine(class_287 bufferBuilder, Vector3fc position, Vector3fc dir, Vector3fc color) {
        bufferBuilder.method_22912(position.x(), position.y(), position.z()).method_22915(color.x(), color.y(), color.z(), 0.0f);
        bufferBuilder.method_22912(position.x(), position.y(), position.z()).method_22915(color.x(), color.y(), color.z(), 1.0f);
        bufferBuilder.method_22912(position.x() + dir.x(), position.y() + dir.y(), position.z() + dir.z()).method_22915(color.x(), color.y(), color.z(), 1.0f);
        bufferBuilder.method_22912(position.x() + dir.x(), position.y() + dir.y(), position.z() + dir.z()).method_22915(color.x(), color.y(), color.z(), 0.0f);
    }

    private static void addNamedCube(Vector3fc cubePos, Quaternionf rot, class_2561 label, float size, Vector3fc color) {
        DebugRenderHelper.addCube(cubePos, size, color);
        if (label != null) {
            DebugRenderHelper.renderTextAtRelativePosition(cubePos.x(), cubePos.y(), cubePos.z(), rot, label);
        }
    }

    public static void renderTextAtDevice(class_4587 poseStack, int device, String text) {
        DebugRenderHelper.renderTextAtPosition(poseStack, DebugRenderHelper.DATA_HOLDER.vrPlayer.getVRDataWorld().getDevice(device).getPosition(), text);
    }

    public static void renderTextAtPosition(class_4587 poseStack, class_243 position, String text) {
        VRData data = DebugRenderHelper.DATA_HOLDER.vrPlayer.getVRDataWorld();
        class_243 camPos = RenderHelper.getSmoothCameraPosition(DebugRenderHelper.DATA_HOLDER.currentPass, data);
        Quaternionf rot = data.getEye(DebugRenderHelper.DATA_HOLDER.currentPass).getMatrix().getNormalizedRotation(new Quaternionf()).rotateY((float)Math.PI);
        Vector3f pos = MathUtils.subtractToVector3f(position, camPos);
        DebugRenderHelper.renderTextAtRelativePosition(pos.x, pos.y, pos.z, rot, text);
    }

    public static void renderTextAtRelativePosition(float x, float y, float z, Quaternionf rot, String text) {
        DebugRenderHelper.renderTextAtRelativePosition(x, y, z, rot, (class_2561)class_2561.method_43470((String)text));
    }

    public static void renderTextAtRelativePosition(float x, float y, float z, Quaternionf rot, class_2561 text) {
        Matrix4f matrix = new Matrix4f();
        matrix.translate(x, y + 0.05f, z);
        matrix.rotate((Quaternionfc)rot);
        matrix.scale(-0.005f, -0.005f, 0.005f);
        class_327 class_3272 = DebugRenderHelper.MC.field_1772;
        float f = (float)DebugRenderHelper.MC.field_1772.method_27525((class_5348)text) * -0.5f;
        Objects.requireNonNull(DebugRenderHelper.MC.field_1772);
        class_3272.method_30882(text, f, (float)(-9), -1, false, matrix, (class_4597)MC.method_22940().method_23000(), class_327.class_6415.field_33993, 0, 0xF000F0);
    }

    private static void addCube(Vector3fc position, float size, Vector3fc color) {
        RenderSystem.setShader(class_757::method_34540);
        RenderSystem.setShaderTexture((int)0, (class_2960)RenderHelper.WHITE_TEXTURE);
        class_287 bufferbuilder = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1576);
        class_2382 iColor = new class_2382((int)(color.x() * 255.0f), (int)(color.y() * 255.0f), (int)(color.z() * 255.0f));
        class_243 start = new class_243((double)position.x(), (double)position.y(), (double)position.z()).method_1019(MathUtils.FORWARD_D.method_1021((double)(size * 0.5f)));
        class_243 end = new class_243((double)position.x(), (double)position.y(), (double)position.z()).method_1019(MathUtils.BACK_D.method_1021((double)(size * 0.5f)));
        RenderHelper.renderBox((class_4588)bufferbuilder, start, end, size, size, iColor, (byte)-1, new Matrix4f());
        class_286.method_43433((class_9801)bufferbuilder.method_60800());
    }
}

