/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.gameplay.trackers;

import java.util.Collections;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1744;
import net.minecraft.class_1758;
import net.minecraft.class_1766;
import net.minecraft.class_1786;
import net.minecraft.class_1787;
import net.minecraft.class_1792;
import net.minecraft.class_1794;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1820;
import net.minecraft.class_1829;
import net.minecraft.class_1835;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_2195;
import net.minecraft.class_2302;
import net.minecraft.class_2323;
import net.minecraft.class_2338;
import net.minecraft.class_2349;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_2399;
import net.minecraft.class_2428;
import net.minecraft.class_243;
import net.minecraft.class_2513;
import net.minecraft.class_2533;
import net.minecraft.class_2541;
import net.minecraft.class_2680;
import net.minecraft.class_2750;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_746;
import net.minecraft.class_8162;
import net.minecraft.class_8170;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.vivecraft.client.VivecraftVRMod;
import org.vivecraft.client.network.ClientNetworking;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.Vector3fHistory;
import org.vivecraft.client_vr.gameplay.trackers.Tracker;
import org.vivecraft.client_vr.provider.ControllerType;
import org.vivecraft.client_vr.settings.VRSettings;
import org.vivecraft.common.network.BodyPart;
import org.vivecraft.common.network.FBTMode;
import org.vivecraft.common.utils.MathUtils;
import org.vivecraft.data.BlockTags;
import org.vivecraft.data.ItemTags;
import org.vivecraft.mod_compat_vr.bettercombat.BetterCombatHelper;
import org.vivecraft.mod_compat_vr.epicfight.EpicFightHelper;

public class SwingTracker
extends Tracker {
    private static final int[] CONTROLLER_AND_FEET = new int[]{0, 1, 4, 5};
    private static final float SPEED_THRESH = 3.0f;
    private final class_243[] lastWeaponEndAir = new class_243[]{class_243.field_1353, class_243.field_1353, class_243.field_1353, class_243.field_1353};
    private final boolean[] lastWeaponSolid = new boolean[4];
    private final List<class_1297>[] lastHitEntities = new List[]{Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList()};
    public final class_243[] miningPoint = new class_243[4];
    public final class_243[] attackingPoint = new class_243[4];
    public final Vector3fHistory[] tipHistory = new Vector3fHistory[]{new Vector3fHistory(), new Vector3fHistory(), new Vector3fHistory(), new Vector3fHistory()};
    public boolean[] canAct = new boolean[4];
    public int disableSwing = 3;

    public SwingTracker(class_310 mc, ClientDataHolderVR dh) {
        super(mc, dh);
    }

    @Override
    public boolean isActive(class_746 player) {
        if (this.disableSwing > 0) {
            --this.disableSwing;
            return false;
        }
        if (this.mc.field_1761 == null) {
            return false;
        }
        if (player == null) {
            return false;
        }
        if (!player.method_5805()) {
            return false;
        }
        if (player.method_6113()) {
            return false;
        }
        if (this.mc.field_1755 != null) {
            return false;
        }
        if (this.dh.vrSettings.weaponCollision == VRSettings.WeaponCollision.OFF) {
            return false;
        }
        if (this.dh.vrSettings.weaponCollision == VRSettings.WeaponCollision.AUTO) {
            return !player.method_7337();
        }
        if (this.dh.vrSettings.seated) {
            return false;
        }
        if (this.dh.vrSettings.vrFreeMoveMode == VRSettings.FreeMove.RUN_IN_PLACE && player.field_6250 > 0.0f) {
            return false;
        }
        if (player.method_6039()) {
            return false;
        }
        return !this.dh.jumpTracker.isjumping();
    }

    public static boolean isTool(class_1792 item) {
        return item instanceof class_1766 || item instanceof class_1744 || item instanceof class_1787 || item instanceof class_1758 || item instanceof class_1820 || item == class_1802.field_8606 || item == class_1802.field_8894 || item == class_1802.field_8648 || item == class_1802.field_8810 || item == class_1802.field_8530 || item == class_1802.field_8600 || item == class_1802.field_8688 || item instanceof class_1786 || item instanceof class_8162 || item.method_7854().method_31573(ItemTags.VIVECRAFT_TOOLS);
    }

    @Override
    public void doProcess(class_746 player) {
        float speedTreshhold = 3.0f;
        if (player.method_7337()) {
            speedTreshhold *= 1.5f;
        }
        this.mc.method_16011().method_15396("updateSwingAttack");
        int trackers = 2;
        if (this.dh.vrSettings.feetCollision && this.dh.vrPlayer.vrdata_world_pre.fbtMode != FBTMode.ARMS_ONLY) {
            trackers = 4;
        }
        for (int i = 0; i < trackers; ++i) {
            class_3965 blockhitresult;
            boolean isHand;
            int c = CONTROLLER_AND_FEET[i];
            boolean bl = isHand = i < 2;
            if (isHand && this.dh.climbTracker.isGrabbingLadder(c)) continue;
            class_243 handPos = this.dh.vrPlayer.vrdata_world_pre.getDevice(c).getPosition();
            Vector3f handDirection = this.dh.vrPlayer.vrdata_world_pre.getHand(c).getCustomVector(MathUtils.BACK);
            class_1799 itemstack = player.method_5998(c == 1 ? class_1268.field_5810 : class_1268.field_5808);
            class_1792 item = itemstack.method_7909();
            boolean isTool = false;
            boolean isSword = false;
            if (this.dh.vrSettings.onlySwordCollision && !(item instanceof class_1829) && !itemstack.method_31573(ItemTags.VIVECRAFT_SWORDS)) continue;
            if (!(item instanceof class_1829 || itemstack.method_31573(ItemTags.VIVECRAFT_SWORDS) || item instanceof class_1835 || itemstack.method_31573(ItemTags.VIVECRAFT_SPEARS))) {
                if (SwingTracker.isTool(item)) {
                    isTool = true;
                }
            } else {
                isSword = true;
                isTool = true;
            }
            float weaponLength = 0.0f;
            float entityReachAdd = 0.3f;
            if (isHand) {
                double playerEntityReach = player.method_55755();
                if (BetterCombatHelper.isLoaded()) {
                    playerEntityReach = BetterCombatHelper.getItemRange(playerEntityReach, itemstack);
                }
                playerEntityReach = Math.min(playerEntityReach, 6.0) - 0.5;
                if (isSword) {
                    weaponLength = 0.6f;
                    entityReachAdd = (float)playerEntityReach - weaponLength;
                } else if (isTool) {
                    weaponLength = 0.35f;
                    entityReachAdd = (float)playerEntityReach * 0.62f - weaponLength;
                } else if (!itemstack.method_7960()) {
                    weaponLength = 0.1f;
                    entityReachAdd = (float)playerEntityReach * 0.16f - weaponLength;
                }
            }
            Vector3f weaponEnd = handDirection.mul(weaponLength *= this.dh.vrPlayer.vrdata_world_pre.worldScale, new Vector3f());
            this.miningPoint[i] = handPos.method_1031((double)weaponEnd.x, (double)weaponEnd.y, (double)weaponEnd.z);
            Vector3f tip = this.dh.vrPlayer.vrdata_room_pre.getDevice(c).getPositionF().add((Vector3fc)this.dh.vrPlayer.vrdata_room_pre.getHand(c).getCustomVector(MathUtils.BACK).mul(0.3f));
            this.tipHistory[i].add((Vector3fc)tip);
            float speed = this.tipHistory[i].averageSpeed(0.33);
            boolean inAnEntity = false;
            this.canAct[i] = speed > speedTreshhold && !this.lastWeaponSolid[i];
            boolean entityAct = this.canAct[i];
            if (entityAct && (blockhitresult = this.mc.field_1687.method_17742(new class_3959(this.dh.vrPlayer.vrdata_world_pre.hmd.getPosition(), handPos, class_3959.class_3960.field_17559, class_3959.class_242.field_1348, (class_1297)this.mc.field_1724))).method_17783() != class_239.class_240.field_1333) {
                entityAct = false;
            }
            this.attackingPoint[i] = this.constrain(handPos, this.miningPoint[i]);
            Vector3f weaponEntityEnd = handDirection.mul(weaponLength + entityReachAdd, new Vector3f());
            class_243 weaponTip = handPos.method_1031((double)weaponEntityEnd.x, (double)weaponEntityEnd.y, (double)weaponEntityEnd.z);
            weaponTip = this.constrain(handPos, weaponTip);
            class_238 weaponBB = new class_238(handPos, this.attackingPoint[i]);
            class_238 weaponTipBB = new class_238(handPos, weaponTip);
            List<Object> mobs = this.mc.field_1687.method_8335((class_1297)this.mc.field_1724, weaponTipBB);
            if (this.dh.vrSettings.reducedPlayerReach) {
                mobs.removeIf(e -> e instanceof class_1657);
                List players = this.mc.field_1687.method_8335((class_1297)this.mc.field_1724, weaponBB);
                players.removeIf(e -> !(e instanceof class_1657));
                mobs.addAll(players);
            }
            for (class_1297 class_12972 : mobs) {
                if (!class_12972.method_5863() || class_12972 == this.mc.method_1560().method_5854() || this.lastHitEntities[i].contains(class_12972)) continue;
                if (entityAct) {
                    if (!EpicFightHelper.isLoaded() || !EpicFightHelper.attack()) {
                        ClientNetworking.sendActiveBodyPart(BodyPart.values()[i]);
                        this.mc.field_1761.method_2918((class_1657)player, class_12972);
                    } else {
                        entityAct = false;
                    }
                    this.dh.vr.triggerHapticPulse(c, 1000);
                    this.lastWeaponSolid[i] = true;
                }
                inAnEntity = true;
            }
            this.lastHitEntities[i] = speed > speedTreshhold ? mobs : Collections.emptyList();
            if (isHand && this.dh.climbTracker.isClimbeyClimb() && (!isTool || c == 0 && VivecraftVRMod.INSTANCE.keyClimbeyGrab.isDown(ControllerType.RIGHT) || c == 1 && VivecraftVRMod.INSTANCE.keyClimbeyGrab.isDown(ControllerType.LEFT))) continue;
            class_2338 blockpos = class_2338.method_49638((class_2374)this.miningPoint[i]);
            class_2680 class_26802 = this.mc.field_1687.method_8320(blockpos);
            boolean mineableByItem = this.dh.vrSettings.swordBlockCollision && (itemstack.method_7951(class_26802) || class_26802.method_26165((class_1657)player, (class_1922)player.method_37908(), blockpos) == 1.0f);
            this.canAct[i] = this.canAct[i] && (!isSword || mineableByItem) && !inAnEntity;
            class_3965 blockHit = this.mc.field_1687.method_17742(new class_3959(this.lastWeaponEndAir[i], this.miningPoint[i], class_3959.class_3960.field_17559, class_3959.class_242.field_1348, (class_1297)this.mc.field_1724));
            if (!class_26802.method_26215() && blockHit.method_17783() == class_239.class_240.field_1332 && this.lastWeaponEndAir[i].method_1033() != 0.0) {
                boolean protectedBlock;
                this.lastWeaponSolid[i] = true;
                boolean sameBlock = blockHit.method_17777().equals((Object)blockpos);
                boolean bl2 = protectedBlock = this.dh.vrSettings.realisticClimbEnabled && (class_26802.method_26204() instanceof class_2399 || class_26802.method_26204() instanceof class_2541 || class_26802.method_26164(BlockTags.VIVECRAFT_CLIMBABLE));
                if (blockHit.method_17783() != class_239.class_240.field_1332 || !sameBlock || !this.canAct[i] || protectedBlock) continue;
                int totalHits = 3;
                if (!this.dh.vrSettings.doorHitting || !this.isOpenable(class_26802, this.tipHistory[i].netMovement(0.3)) || this.mc.field_1761.method_2896(player, c == 1 ? class_1268.field_5810 : class_1268.field_5808, blockHit) == class_1269.field_5811) {
                    if (isHand && (item instanceof class_1794 || itemstack.method_31573(ItemTags.VIVECRAFT_HOES) || itemstack.method_31573(ItemTags.VIVECRAFT_SCYTHES)) && (class_26802.method_26204() instanceof class_2302 || class_26802.method_26204() instanceof class_2513 || class_26802.method_26204() instanceof class_2195 || class_26802.method_26164(BlockTags.VIVECRAFT_CROPS) || item.method_7884(new class_1838((class_1657)player, c == 0 ? class_1268.field_5808 : class_1268.field_5810, blockHit)).method_23666())) {
                        boolean useSuccessful = this.mc.field_1761.method_2896(player, i == 0 ? class_1268.field_5808 : class_1268.field_5810, blockHit).method_23666();
                        if (itemstack.method_31573(ItemTags.VIVECRAFT_SCYTHES) && !useSuccessful) {
                            this.mc.field_1761.method_2919((class_1657)player, c == 0 ? class_1268.field_5808 : class_1268.field_5810);
                        }
                    } else if (isHand && item instanceof class_8162) {
                        ((class_8162)item).method_49184(player.method_37908(), blockHit, class_26802, player.method_5828(0.0f), c == 0 ? player.method_6068() : player.method_6068().method_5928());
                        player.method_37908().method_45447((class_1657)player, blockHit.method_17777(), class_26802.method_26204() instanceof class_8170 ? ((class_8170)class_26802.method_26204()).method_49811() : class_3417.field_43155, class_3419.field_15245);
                        this.mc.field_1761.method_2896(player, c == 0 ? class_1268.field_5808 : class_1268.field_5810, blockHit);
                    } else if (class_26802.method_26204() instanceof class_2428 || class_26802.method_26164(BlockTags.VIVECRAFT_MUSIC_BLOCKS)) {
                        this.mc.field_1761.method_2902(blockHit.method_17777(), blockHit.method_17780());
                    } else {
                        totalHits = (int)((float)totalHits + Math.min(speed - speedTreshhold, 4.0f));
                        ClientNetworking.sendActiveBodyPart(BodyPart.values()[i]);
                        this.mc.field_1761.method_2910(blockHit.method_17777(), blockHit.method_17780());
                        if (this.getIsHittingBlock()) {
                            for (int hit = 0; hit < totalHits; ++hit) {
                                if (this.mc.field_1761.method_2902(blockHit.method_17777(), blockHit.method_17780())) {
                                    this.mc.field_1713.method_3054(blockHit.method_17777(), blockHit.method_17780());
                                }
                                this.clearBlockHitDelay();
                                if (!this.getIsHittingBlock()) break;
                            }
                            this.mc.field_1761.field_3716 = 0;
                        }
                        this.dh.vrPlayer.blockDust(blockHit.method_17784().field_1352, blockHit.method_17784().field_1351, blockHit.method_17784().field_1350, 3 * totalHits, blockpos, class_26802, 0.6f, 1.0f);
                    }
                }
                this.dh.vr.triggerHapticPulse(c, 250 * totalHits);
                continue;
            }
            this.lastWeaponEndAir[i] = this.miningPoint[i];
            this.lastWeaponSolid[i] = false;
        }
        ClientNetworking.sendActiveBodyPart(BodyPart.MAIN_HAND);
        this.mc.method_16011().method_15407();
    }

    private boolean getIsHittingBlock() {
        return this.mc.field_1761.method_2923();
    }

    private void clearBlockHitDelay() {
    }

    private class_243 constrain(class_243 start, class_243 end) {
        class_3965 blockhitresult = this.mc.field_1687.method_17742(new class_3959(start, end, class_3959.class_3960.field_17559, class_3959.class_242.field_1348, (class_1297)this.mc.field_1724));
        return blockhitresult.method_17783() == class_239.class_240.field_1332 ? blockhitresult.method_17784() : end;
    }

    private boolean isOpenable(class_2680 state, Vector3f roomDirection) {
        float t = 0.25f;
        Vector3f direction = roomDirection.normalize().rotateY(this.dh.vrPlayer.vrdata_world_pre.rotation_radians);
        if (state.method_26164(class_3481.field_15495) || state.method_26204() instanceof class_2323) {
            class_2350 d = (class_2350)state.method_11654((class_2769)class_2323.field_10938);
            boolean open = (Boolean)state.method_11654((class_2769)class_2323.field_10945);
            class_2750 hinge = (class_2750)state.method_11654((class_2769)class_2323.field_10941);
            if (direction.z < -0.25f && (d == class_2350.field_11043 && !open || d == class_2350.field_11039 && open && hinge == class_2750.field_12588 || d == class_2350.field_11034 && open && hinge == class_2750.field_12586)) {
                return true;
            }
            if (direction.x > 0.25f && (d == class_2350.field_11034 && !open || d == class_2350.field_11043 && open && hinge == class_2750.field_12588 || d == class_2350.field_11035 && open && hinge == class_2750.field_12586)) {
                return true;
            }
            if (direction.z > 0.25f && (d == class_2350.field_11035 && !open || d == class_2350.field_11034 && open && hinge == class_2750.field_12588 || d == class_2350.field_11039 && open && hinge == class_2750.field_12586)) {
                return true;
            }
            return direction.x < -0.25f && (d == class_2350.field_11039 && !open || d == class_2350.field_11035 && open && hinge == class_2750.field_12588 || d == class_2350.field_11043 && open && hinge == class_2750.field_12586);
        }
        if (state.method_26164(class_3481.field_15487) || state.method_26204() instanceof class_2533) {
            class_2350 d = (class_2350)state.method_11654((class_2769)class_2533.field_11177);
            boolean open = (Boolean)state.method_11654((class_2769)class_2533.field_11631);
            return direction.y > 0.25f && !open || direction.x < -0.25f && open && d == class_2350.field_11039 || direction.x > 0.25f && open && d == class_2350.field_11034 || direction.z < -0.25f && open && d == class_2350.field_11043 || direction.z > 0.25f && open && d == class_2350.field_11035;
        }
        if (state.method_26164(class_3481.field_25147) || state.method_26204() instanceof class_2349) {
            class_2350 d = (class_2350)state.method_11654((class_2769)class_2349.field_11177);
            boolean open = (Boolean)state.method_11654((class_2769)class_2349.field_11026);
            return !open && (direction.x > 0.25f || direction.x < 0.25f) && (d == class_2350.field_11039 || d == class_2350.field_11034) || !open && (direction.z > 0.25f || direction.z < 0.25f) && (d == class_2350.field_11043 || d == class_2350.field_11035);
        }
        return false;
    }

    public static float getItemFade(class_746 player, class_1799 itemStack) {
        float fade = player.method_7261(0.0f) * 0.75f + 0.25f;
        if (player.method_5715()) {
            fade = 0.75f;
        }
        if (ClientDataHolderVR.getInstance().swingTracker.lastWeaponSolid[ClientDataHolderVR.IS_MAIN_HAND ? 0 : 1]) {
            fade -= 0.25f;
        }
        if (itemStack != class_1799.field_8037) {
            if (player.method_6039() && player.method_6030() != itemStack) {
                fade -= 0.25f;
            }
            if (itemStack.method_7909() == class_1802.field_8255 && !player.method_6039()) {
                fade -= 0.25f;
            }
        }
        if ((double)fade < 0.1) {
            fade = 0.1f;
        }
        if (fade > 1.0f) {
            fade = 1.0f;
        }
        return fade;
    }
}

