/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.gameplay.trackers;

import net.minecraft.class_1690;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_746;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.gameplay.trackers.Tracker;
import org.vivecraft.common.utils.MathUtils;

public class RowTracker
extends Tracker {
    private static final double TRANSMISSION_EFFICIENCY = 0.9;
    public double[] forces = new double[]{0.0, 0.0};
    public float LOar;
    public float ROar;
    public float FOar;
    private final class_243[] lastUWPs = new class_243[2];

    public RowTracker(class_310 mc, ClientDataHolderVR dh) {
        super(mc, dh);
    }

    @Override
    public boolean isActive(class_746 player) {
        if (this.dh.vrSettings.seated) {
            return false;
        }
        if (!this.dh.vrSettings.realisticRowEnabled) {
            return false;
        }
        if (player == null || !player.method_5805()) {
            return false;
        }
        if (this.mc.field_1761 == null) {
            return false;
        }
        if (this.mc.field_1690.field_1894.method_1434()) {
            return false;
        }
        if (!(player.method_5854() instanceof class_1690)) {
            return false;
        }
        return !this.dh.bowTracker.isNotched();
    }

    public boolean isRowing() {
        return this.ROar + this.LOar + this.FOar > 0.0f;
    }

    @Override
    public void reset(class_746 player) {
        this.LOar = 0.0f;
        this.ROar = 0.0f;
        this.FOar = 0.0f;
    }

    @Override
    public void doProcess(class_746 player) {
        float c0Move = this.dh.vr.controllerHistory[0].averageSpeed(0.5);
        float c1Move = this.dh.vr.controllerHistory[1].averageSpeed(0.5);
        float minSpeed = 0.5f;
        float maxSpeed = 2.0f;
        this.ROar = Math.max(c0Move - 0.5f, 0.0f);
        this.LOar = Math.max(c1Move - 0.5f, 0.0f);
        float f = this.FOar = this.ROar > 0.0f && this.LOar > 0.0f ? (this.ROar + this.LOar) / 2.0f : 0.0f;
        if (this.FOar > 2.0f) {
            this.FOar = 2.0f;
        }
        if (this.ROar > 2.0f) {
            this.ROar = 2.0f;
        }
        if (this.LOar > 2.0f) {
            this.LOar = 2.0f;
        }
    }

    public void doProcessFinaltransmithastofixthis(class_746 player) {
        class_1690 boat = (class_1690)player.method_5854();
        Quaternionf boatRot = new Quaternionf().rotationYXZ((float)Math.PI / 180 * -(boat.method_36454() % 360.0f), (float)Math.PI / 180 * boat.method_36455(), 0.0f).normalize();
        for (int paddle = 0; paddle <= 1; ++paddle) {
            if (this.isPaddleUnderWater(paddle, boat)) {
                class_243 arm2Pad = this.getArmToPaddleVector(paddle, boat);
                class_243 attach = this.getAttachmentPoint(paddle, boat);
                class_243 underWaterPoint = attach.method_1019(arm2Pad.method_1029()).method_1020(boat.method_19538());
                if (this.lastUWPs[paddle] != null) {
                    Vector3f forward;
                    Vector3f forceVector = MathUtils.subtractToVector3f(this.lastUWPs[paddle], underWaterPoint);
                    double force = (double)(forceVector = forceVector.sub((float)boat.method_18798().field_1352, (float)boat.method_18798().field_1351, (float)boat.method_18798().field_1350)).dot((Vector3fc)(forward = boatRot.transform(MathUtils.FORWARD, new Vector3f()))) * 0.9 / 5.0;
                    this.forces[paddle] = force < 0.0 && this.forces[paddle] > 0.0 || force > 0.0 && this.forces[paddle] < 0.0 ? 0.0 : Math.min(Math.max(force, -0.1), 0.1);
                }
                this.lastUWPs[paddle] = underWaterPoint;
                continue;
            }
            this.forces[paddle] = 0.0;
            this.lastUWPs[paddle] = null;
        }
    }

    private class_243 getArmToPaddleVector(int paddle, class_1690 boat) {
        class_243 attachAbs = this.getAttachmentPoint(paddle, boat);
        class_243 armAbs = this.getAbsArmPos(paddle == 0 ? 1 : 0);
        return attachAbs.method_1020(armAbs);
    }

    private class_243 getAttachmentPoint(int paddle, class_1690 boat) {
        Vector3f attachmentPoint = new Vector3f((paddle == 0 ? 9.0f : -9.0f) / 16.0f, 0.625f, 0.1875f);
        Quaternionf boatRot = new Quaternionf().rotationYXZ((float)Math.PI / 180 * -(boat.method_36454() % 360.0f), (float)Math.PI / 180 * boat.method_36455(), 0.0f).normalize();
        return boat.method_19538().method_1019(new class_243(boatRot.transform(attachmentPoint)));
    }

    private class_243 getAbsArmPos(int side) {
        Vector3f arm = this.dh.vr.controllerHistory[side].averagePosition(0.1).rotateY((float)Math.PI / 180 * this.dh.vrSettings.worldRotation);
        return this.dh.vrPlayer.roomOrigin.method_1031((double)arm.x, (double)arm.y, (double)arm.z);
    }

    private boolean isPaddleUnderWater(int paddle, class_1690 boat) {
        class_243 attachAbs = this.getAttachmentPoint(paddle, boat);
        class_243 armToPaddle = this.getArmToPaddleVector(paddle, boat).method_1029();
        class_2338 blockPos = class_2338.method_49638((class_2374)attachAbs.method_1019(armToPaddle));
        return boat.method_37908().method_8320(blockPos).method_51176();
    }
}

