/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.gameplay.trackers;

import java.util.HashSet;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1675;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_2846;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_4970;
import net.minecraft.class_746;
import net.minecraft.class_7923;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.vivecraft.client.VivecraftVRMod;
import org.vivecraft.client.Xplat;
import org.vivecraft.client.network.ClientNetworking;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.VRData;
import org.vivecraft.client_vr.gameplay.trackers.Tracker;
import org.vivecraft.client_vr.provider.ControllerType;
import org.vivecraft.client_vr.render.RenderPass;
import org.vivecraft.client_vr.render.VRFirstPersonArmSwing;
import org.vivecraft.client_vr.settings.VRHotkeys;
import org.vivecraft.client_vr.settings.VRSettings;
import org.vivecraft.common.utils.MathUtils;

public class InteractTracker
extends Tracker {
    public boolean[] bukkit = new boolean[2];
    public int hotbar = -1;
    private final boolean[] inBow = new boolean[2];
    public class_3965[] inBlockHit = new class_3965[2];
    private final class_2338[] inBlockPos = new class_2338[2];
    private final class_1297[] inEntity = new class_1297[2];
    private final class_3966[] inEntityHit = new class_3966[2];
    private final boolean[] inCamera = new boolean[2];
    private final boolean[] inHandheldCamera = new boolean[2];
    private final boolean[] active = new boolean[2];
    private final boolean[] wasactive = new boolean[2];
    private HashSet<Class<?>> rightClickable = null;

    public InteractTracker(class_310 mc, ClientDataHolderVR dh) {
        super(mc, dh);
    }

    @Override
    public boolean isActive(class_746 player) {
        if (this.mc.field_1761 == null) {
            return false;
        }
        if (player == null) {
            return false;
        }
        if (!player.method_5805()) {
            return false;
        }
        if (player.method_6113()) {
            return false;
        }
        if (this.dh.vrSettings.seated) {
            return false;
        }
        return !player.method_6039() || this.hotbar >= 0;
    }

    @Override
    public void reset(class_746 player) {
        for (int c = 0; c < 2; ++c) {
            this.reset(player, c);
        }
    }

    private void reset(class_746 player, int c) {
        if (this.inCamera[c] && VRHotkeys.isMovingThirdPersonCam() && VRHotkeys.getMovingThirdPersonCamTriggerer() == VRHotkeys.Triggerer.INTERACTION && VRHotkeys.getMovingThirdPersonCamController() == c) {
            VRHotkeys.stopMovingThirdPersonCam();
        }
        if (this.inHandheldCamera[c] && this.dh.cameraTracker.isMoving() && this.dh.cameraTracker.getMovingController() == c && !this.dh.cameraTracker.isQuickMode()) {
            this.dh.cameraTracker.stopMoving();
        }
        this.inBow[c] = false;
        this.inBlockPos[c] = null;
        this.inBlockHit[c] = null;
        this.inEntity[c] = null;
        this.inEntityHit[c] = null;
        this.inCamera[c] = false;
        this.inHandheldCamera[c] = false;
        this.active[c] = false;
        this.dh.vr.getInputAction(VivecraftVRMod.INSTANCE.keyVRInteract).setEnabled(ControllerType.values()[c], false);
    }

    @Override
    public void doProcess(class_746 player) {
        if (this.rightClickable == null) {
            this.rightClickable = new HashSet();
            String name = Xplat.getUseMethodName();
            for (Object object : class_7923.field_41175) {
                Class<?> oclass = object.getClass();
                this.addIfClassHasMethod(name, oclass);
                this.addIfClassHasMethod(name, oclass.getSuperclass());
            }
            this.rightClickable.remove(class_2248.class);
            this.rightClickable.remove(class_4970.class);
            this.rightClickable.remove(class_4970.class_4971.class);
        }
        for (int c = 0; c < 2; ++c) {
            Vector3f offset;
            class_243 camPos;
            VRData.VRDevicePose camData;
            if ((this.inCamera[c] || this.inHandheldCamera[c] || this.inBow[c]) && VivecraftVRMod.INSTANCE.keyVRInteract.isDown(ControllerType.values()[c])) continue;
            this.reset(player, c);
            if (c == 0 && this.hotbar >= 0) {
                this.active[c] = true;
            }
            if (!this.active[c] && this.dh.bowTracker.isNotched() && c == (this.dh.vrSettings.reverseShootingEye && ClientNetworking.supportsReversedBow() ? 1 : 0)) {
                this.inBow[c] = true;
                this.active[c] = true;
            }
            class_243 hmdPos = this.dh.vrPlayer.vrdata_world_pre.getHeadPivot();
            class_243 handPos = this.dh.vrPlayer.vrdata_world_pre.getController(c).getPosition();
            Vector3f handDirection = this.dh.vrPlayer.vrdata_world_pre.getHand(c).getCustomVector(MathUtils.BACK);
            class_1799 handItem = player.method_5998(c == 0 ? class_1268.field_5808 : class_1268.field_5810);
            if (!this.active[c] && this.dh.vrSettings.mixedRealityRenderCameraModel && (this.dh.vrSettings.displayMirrorMode == VRSettings.MirrorMode.MIXED_REALITY || this.dh.vrSettings.displayMirrorMode == VRSettings.MirrorMode.THIRD_PERSON)) {
                camData = this.dh.vrPlayer.vrdata_world_pre.getEye(RenderPass.THIRD);
                camPos = camData.getPosition();
                offset = camData.getCustomVector(MathUtils.BACK).mul(0.15f * this.dh.vrPlayer.vrdata_world_pre.worldScale);
                offset.add((Vector3fc)camData.getCustomVector(MathUtils.DOWN).mul(0.05f * this.dh.vrPlayer.vrdata_world_pre.worldScale));
                camPos = camPos.method_1023((double)offset.x, (double)offset.y, (double)offset.z);
                if (handPos.method_1022(camPos) < (double)0.15f * (double)this.dh.vrPlayer.vrdata_world_pre.worldScale) {
                    this.inCamera[c] = true;
                    this.active[c] = true;
                }
            }
            if (!this.active[c] && this.dh.cameraTracker.isVisible() && !this.dh.cameraTracker.isQuickMode()) {
                camData = this.dh.vrPlayer.vrdata_world_pre.getEye(RenderPass.CAMERA);
                camPos = camData.getPosition();
                offset = camData.getCustomVector(MathUtils.BACK).mul(0.08f * this.dh.vrPlayer.vrdata_world_pre.worldScale);
                if (handPos.method_1022(camPos = camPos.method_1023((double)offset.x, (double)offset.y, (double)offset.z)) < (double)0.11f * (double)this.dh.vrPlayer.vrdata_world_pre.worldScale) {
                    this.inHandheldCamera[c] = true;
                    this.active[c] = true;
                }
            }
            if (this.dh.vrSettings.realisticEntityInteractEnabled && !this.active[c]) {
                class_243 extWeapon = new class_243(handPos.field_1352 + (double)(handDirection.x * -0.1f), handPos.field_1351 + (double)(handDirection.y * -0.1f), handPos.field_1350 + (double)(handDirection.z * -0.1f));
                class_238 weaponBB = new class_238(handPos, extWeapon);
                this.inEntityHit[c] = class_1675.method_18075((class_1297)this.mc.method_1560(), (class_243)hmdPos, (class_243)handPos, (class_238)weaponBB, e -> !e.method_7325() && e.method_5863() && e != this.mc.method_1560().method_5854(), (double)0.0);
                if (this.inEntityHit[c] != null) {
                    class_1297 entity;
                    this.inEntity[c] = entity = this.inEntityHit[c].method_17782();
                    this.active[c] = true;
                }
            }
            if (this.dh.vrSettings.realisticBlockInteractEnabled && !this.active[c]) {
                class_2338 blockpos = class_2338.method_49638((class_2374)handPos);
                class_2680 blockstate = this.mc.field_1687.method_8320(blockpos);
                class_3965 hit = blockstate.method_26218((class_1922)this.mc.field_1687, blockpos).method_1092(hmdPos, handPos, blockpos);
                this.inBlockPos[c] = blockpos;
                this.inBlockHit[c] = hit;
                this.active[c] = hit != null && (this.rightClickable.contains(blockstate.method_26204().getClass()) || this.rightClickable.contains(blockstate.method_26204().getClass().getSuperclass()));
                this.bukkit[c] = false;
                if (!this.active[c] && handItem.method_7909() == class_1802.field_8550 && blockstate.method_51176()) {
                    this.active[c] = true;
                    this.bukkit[c] = true;
                }
            }
            if (!this.wasactive[c] && this.active[c]) {
                this.dh.vr.triggerHapticPulse(c, 250);
            }
            this.dh.vr.getInputAction(VivecraftVRMod.INSTANCE.keyVRInteract).setEnabled(ControllerType.values()[c], this.active[c]);
            this.wasactive[c] = this.active[c];
        }
    }

    private void addIfClassHasMethod(String name, Class<?> oclass) {
        try {
            oclass.getDeclaredMethod(name, class_2680.class, class_1937.class, class_2338.class, class_1657.class, class_3965.class);
            this.rightClickable.add(oclass);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public boolean isInteractActive(int controller) {
        return this.active[controller];
    }

    public boolean isInCamera() {
        return this.inCamera[0] || this.inCamera[1];
    }

    public boolean isInHandheldCamera() {
        return this.inHandheldCamera[0] || this.inHandheldCamera[1];
    }

    public void processBindings() {
        for (int c = 0; c < 2; ++c) {
            if (!VivecraftVRMod.INSTANCE.keyVRInteract.consumeClick(ControllerType.values()[c]) || !this.active[c]) continue;
            class_1268 hand = class_1268.values()[c];
            boolean success = false;
            if (this.hotbar >= 0 && this.hotbar < 9 && this.mc.field_1724.method_31548().field_7545 != this.hotbar && hand == class_1268.field_5808) {
                this.mc.field_1724.method_31548().field_7545 = this.hotbar;
                success = true;
            } else if (this.hotbar == 9 && hand == class_1268.field_5808) {
                this.mc.field_1724.field_3944.method_52787((class_2596)new class_2846(class_2846.class_2847.field_12969, class_2338.field_10980, class_2350.field_11033));
                success = true;
            } else if (this.inCamera[c]) {
                VRHotkeys.startMovingThirdPersonCam(c, VRHotkeys.Triggerer.INTERACTION);
                success = true;
            } else if (this.inHandheldCamera[c]) {
                this.dh.cameraTracker.startMoving(c);
                success = true;
            } else if (this.inEntityHit[c] != null) {
                success = this.mc.field_1761.method_2917((class_1657)this.mc.field_1724, this.inEntity[c], this.inEntityHit[c], hand).method_23665() || this.mc.field_1761.method_2905((class_1657)this.mc.field_1724, this.inEntity[c], hand).method_23665();
            } else if (this.inBlockHit[c] != null) {
                ClientNetworking.sendActiveHand(hand);
                success = this.mc.field_1761.method_2896(this.mc.field_1724, class_1268.field_5808, this.inBlockHit[c]).method_23665();
                ClientNetworking.sendActiveHand(class_1268.field_5808);
            } else if (this.bukkit[c]) {
                success = this.mc.field_1761.method_2919((class_1657)this.mc.field_1724, hand).method_23665();
            }
            if (!success) continue;
            this.dh.swingType = VRFirstPersonArmSwing.Interact;
            this.mc.field_1724.method_6104(hand);
            this.dh.vr.triggerHapticPulse(c, 750);
        }
    }
}

