/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.gameplay.trackers;

import net.minecraft.class_1498;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_746;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.gameplay.VRPlayer;
import org.vivecraft.client_vr.gameplay.trackers.Tracker;
import org.vivecraft.client_vr.settings.VRSettings;
import org.vivecraft.common.utils.MathUtils;

public class HorseTracker
extends Tracker {
    private static final double BOOST_TRIGGER = 1.4;
    private static final double PULL_TRIGGER = 0.8;
    private static final int MAX_SPEED_LEVEL = 3;
    private static final long COOL_DOWN_MILLIS = 500L;
    private static final double TURN_SPEED = 6.0;
    private static final double BODY_TURN_SPEED = 0.2;
    private static final double BASE_SPEED = 0.2;
    private int speedLevel = 0;
    private long lastBoostMillis = -1L;
    private class_1498 horse = null;
    private final ModelInfo info = new ModelInfo();

    public HorseTracker(class_310 mc, ClientDataHolderVR dh) {
        super(mc, dh);
    }

    @Override
    public boolean isActive(class_746 player) {
        return false;
    }

    @Override
    public void reset(class_746 player) {
        if (this.horse != null) {
            this.horse.method_5977(false);
        }
    }

    @Override
    public void doProcess(class_746 player) {
        this.horse = (class_1498)player.method_5854();
        this.horse.method_5977(true);
        float absYaw = (this.horse.method_36454() + 360.0f) % 360.0f;
        float absYawOffset = (this.horse.field_6283 + 360.0f) % 360.0f;
        Vector3f speedLeft = this.dh.vr.controllerHistory[1].netMovement(0.1).mul(10.0f);
        Vector3f speedRight = this.dh.vr.controllerHistory[0].netMovement(0.1).mul(10.0f);
        float speedDown = Math.min(-speedLeft.y, -speedRight.y);
        if ((double)speedDown > 1.4) {
            this.doBoost();
        }
        Vector3f back = MathUtils.BACK.rotateY(-this.horse.field_6283, new Vector3f());
        Vector3f left = MathUtils.LEFT.rotateY(-this.horse.field_6283, new Vector3f());
        Vector3f right = MathUtils.RIGHT.rotateY(-this.horse.field_6283, new Vector3f());
        Vector3f roomPosL = this.dh.vr.controllerHistory[1].latest().rotateY(VRSettings.INSTANCE.worldRotation, new Vector3f());
        Vector3f roomPosR = this.dh.vr.controllerHistory[0].latest().rotateY(VRSettings.INSTANCE.worldRotation, new Vector3f());
        class_243 posL = VRPlayer.get().roomOrigin.method_1031((double)roomPosL.x, (double)roomPosL.y, (double)roomPosL.z);
        class_243 posR = VRPlayer.get().roomOrigin.method_1031((double)roomPosR.x, (double)roomPosR.y, (double)roomPosR.z);
        Vector3f offsetL = MathUtils.subtractToVector3f(posL, this.info.leftReinPos);
        Vector3f offsetR = MathUtils.subtractToVector3f(posR, this.info.leftReinPos);
        double distanceL = offsetL.dot((Vector3fc)back) + offsetL.dot((Vector3fc)left);
        double distanceR = offsetR.dot((Vector3fc)back) + offsetR.dot((Vector3fc)right);
        if (this.speedLevel < 0) {
            this.speedLevel = 0;
        }
        if (distanceL > 1.1 && distanceR > 1.1 && Math.abs(distanceR - distanceL) < 0.1) {
            if (this.speedLevel == 0 && System.currentTimeMillis() > this.lastBoostMillis + 500L) {
                this.speedLevel = -1;
            } else {
                this.doBreak();
            }
        } else {
            double pullL = 0.0;
            double pullR = 0.0;
            if (distanceL > 0.8) {
                pullL = distanceL - 0.8;
            }
            if (distanceR > 0.8) {
                pullR = distanceR - 0.8;
            }
            this.horse.method_36456((float)((double)absYaw + (pullR - pullL) * 6.0));
        }
        this.horse.field_6283 = (float)MathUtils.lerpMod(absYawOffset, absYaw, 0.2, 360.0);
        this.horse.field_6241 = absYaw;
        class_243 movement = new class_243(0.0, 0.0, (double)this.speedLevel * 0.2).method_1024(-this.horse.field_6283);
        this.horse.method_18800(movement.field_1352, this.horse.method_18798().field_1351, movement.field_1350);
    }

    private boolean doBoost() {
        if (this.speedLevel >= 3) {
            return false;
        }
        if (System.currentTimeMillis() < this.lastBoostMillis + 500L) {
            return false;
        }
        ++this.speedLevel;
        this.lastBoostMillis = System.currentTimeMillis();
        return true;
    }

    private boolean doBreak() {
        if (this.speedLevel <= 0) {
            return false;
        }
        if (System.currentTimeMillis() < this.lastBoostMillis + 500L) {
            return false;
        }
        System.out.println("Breaking");
        --this.speedLevel;
        this.lastBoostMillis = System.currentTimeMillis();
        return true;
    }

    public ModelInfo getModelInfo() {
        return this.info;
    }

    public static class ModelInfo {
        public class_243 leftReinPos = class_243.field_1353;
        public class_243 rightReinPos = class_243.field_1353;
    }
}

