/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr;

import java.util.LinkedList;
import java.util.ListIterator;
import net.minecraft.class_156;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class Vector3fHistory {
    private static final int CAPACITY = 450;
    private final LinkedList<Entry> data = new LinkedList();

    public void add(Vector3fc in) {
        this.data.add(new Entry(in));
        if (this.data.size() > 450) {
            this.data.removeFirst();
        }
    }

    public void clear() {
        this.data.clear();
    }

    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    public Vector3fc latest() {
        return this.data.getLast().vec;
    }

    public float totalMovement(double seconds) {
        long now = class_156.method_658();
        ListIterator<Entry> iterator = this.data.listIterator(this.data.size());
        Entry last = null;
        float distance = 0.0f;
        while (iterator.hasPrevious()) {
            Entry current = iterator.previous();
            if ((double)(now - current.ts) > seconds * 1000.0) break;
            if (last == null) {
                last = current;
                continue;
            }
            distance += last.vec.distance(current.vec);
        }
        return distance;
    }

    public Vector3f netMovement(double seconds) {
        long now = class_156.method_658();
        ListIterator<Entry> iterator = this.data.listIterator(this.data.size());
        Entry last = null;
        Entry first = null;
        while (iterator.hasPrevious()) {
            Entry current = iterator.previous();
            if ((double)(now - current.ts) > seconds * 1000.0) break;
            if (last == null) {
                last = current;
                continue;
            }
            first = current;
        }
        return last != null && first != null ? last.vec.sub(first.vec, new Vector3f()) : new Vector3f();
    }

    public float averageSpeed(double seconds) {
        long now = class_156.method_658();
        ListIterator<Entry> iterator = this.data.listIterator(this.data.size());
        float speedTotal = 0.0f;
        Entry last = null;
        int count = 0;
        while (iterator.hasPrevious()) {
            Entry current = iterator.previous();
            if ((double)(now - current.ts) > seconds * 1000.0) break;
            if (last == null) {
                last = current;
                continue;
            }
            ++count;
            float timeDelta = 0.001f * (float)(last.ts - current.ts);
            float positionDelta = last.vec.distance(current.vec);
            speedTotal += positionDelta / timeDelta;
        }
        return count == 0 ? speedTotal : speedTotal / (float)count;
    }

    public Vector3f averagePosition(double seconds) {
        long now = class_156.method_658();
        ListIterator<Entry> iterator = this.data.listIterator(this.data.size());
        Vector3f vec3 = new Vector3f();
        int count = 0;
        while (iterator.hasPrevious()) {
            Entry current = iterator.previous();
            if ((double)(now - current.ts) > seconds * 1000.0) break;
            vec3.add(current.vec);
            ++count;
        }
        return count == 0 ? vec3 : vec3.div((float)count);
    }

    private record Entry(Vector3fc vec, long ts) {
        public Entry(Vector3fc vec) {
            this(vec, class_156.method_658());
        }
    }
}

