/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.Random;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_276;
import net.minecraft.class_310;
import net.minecraft.class_318;
import net.minecraft.class_761;
import org.vivecraft.client_vr.extensions.MinecraftExtension;
import org.vivecraft.client_vr.settings.VRSettings;

public class ClientUtils {
    private static final class_310 MC = class_310.method_1551();
    private static final Random AV_RANDOMIZER = new Random();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readWinRegistry(String key) {
        try {
            Process process = Runtime.getRuntime().exec("reg query \"" + key.substring(0, key.lastIndexOf(92)) + "\" /v \"" + key.substring(key.lastIndexOf(92) + 1) + "\"");
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String line = reader.readLine();
                while (line != null) {
                    String[] split = line.split("REG_SZ|REG_DWORD");
                    if (split.length > 1) {
                        String string = split[1].trim();
                        return string;
                    }
                    line = reader.readLine();
                }
                return null;
            }
        }
        catch (Exception e) {
            VRSettings.LOGGER.error("Vivecraft: error reading registry key: ", (Throwable)e);
        }
        return null;
    }

    public static void spawnParticles(class_2394 type, int count, class_243 position, class_243 size, double speed) {
        class_310 minecraft = class_310.method_1551();
        for (int k = 0; k < count; ++k) {
            double offX = AV_RANDOMIZER.nextGaussian() * size.field_1352;
            double offY = AV_RANDOMIZER.nextGaussian() * size.field_1351;
            double offZ = AV_RANDOMIZER.nextGaussian() * size.field_1350;
            double dirX = AV_RANDOMIZER.nextGaussian() * speed;
            double dirY = AV_RANDOMIZER.nextGaussian() * speed;
            double dirZ = AV_RANDOMIZER.nextGaussian() * speed;
            try {
                minecraft.field_1687.method_8406(type, position.field_1352 + offX, position.field_1351 + offY, position.field_1350 + offZ, dirX, dirY, dirZ);
                continue;
            }
            catch (Throwable throwable) {
                VRSettings.LOGGER.warn("Vivecraft: Could not spawn particle effect {}", (Object)type);
                return;
            }
        }
    }

    public static int getCombinedLightWithMin(class_1920 lightReader, class_2338 pos, int minLight) {
        int light = class_761.method_23794((class_1920)lightReader, (class_2338)pos);
        int blockLight = light >> 4 & 0xF;
        if (blockLight < minLight) {
            light &= 0xFFFFFF00;
            light |= minLight << 4;
        }
        return light;
    }

    public static void takeScreenshot(class_276 fb) {
        class_310 minecraft = class_310.method_1551();
        class_318.method_1659((File)minecraft.field_1697, (class_276)fb, text -> minecraft.execute(() -> minecraft.field_1705.method_1743().method_1812(text)));
    }

    public static float getCurrentPartialTick() {
        return ((MinecraftExtension)MC).vivecraft$getPartialTick();
    }

    public static <T extends Enum<T>> T getNextEnum(T current, int offset) {
        Enum[] values = (Enum[])current.getClass().getEnumConstants();
        int index = (current.ordinal() + offset + values.length) % values.length;
        return (T)values[index];
    }

    public static long microTime() {
        return System.nanoTime() / 1000L;
    }

    public static long milliTime() {
        return System.nanoTime() / 1000000L;
    }
}

