/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client.gui.widgets;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import net.minecraft.class_1074;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_350;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4265;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.minecraft.class_6379;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_7919;
import net.minecraft.class_8016;
import net.minecraft.class_8023;
import org.vivecraft.client.gui.framework.GuiVROptionSlider;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.settings.VRSettings;
import org.vivecraft.server.config.ConfigBuilder;

public class SettingsList
extends class_4265<BaseEntry> {
    final class_437 parent;
    int maxNameWidth;

    public SettingsList(class_437 parent, class_310 minecraft, List<BaseEntry> entries) {
        super(minecraft, parent.field_22789 + 45, parent.field_22790 - 52, 20, 20);
        this.parent = parent;
        for (BaseEntry entry : entries) {
            int i = minecraft.field_1772.method_27525((class_5348)entry.name);
            if (i > this.maxNameWidth) {
                this.maxNameWidth = i;
            }
            this.method_25321((class_350.class_351)entry);
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.method_53812(button)) {
            BaseEntry hovered;
            this.method_25318(mouseX, mouseY, button);
            if (this.method_25405(mouseX, mouseY) && (hovered = this.getEntryAtPositionFixed(mouseX, mouseY)) != null && hovered.method_25402(mouseX, mouseY, button)) {
                if (this.method_25336() != hovered && this.method_25336() != null) {
                    ((BaseEntry)this.method_25336()).method_25395(null);
                }
                this.method_25395((class_364)hovered);
                this.method_25398(true);
                return true;
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    private BaseEntry getEntryAtPositionFixed(double mouseX, double mouseY) {
        int listY = class_3532.method_15357((double)(mouseY - (double)this.method_46427())) - this.field_22748 + (int)this.method_25341() - 4;
        int hoveredItem = listY / this.field_22741;
        return mouseX < (double)this.method_25329() && hoveredItem >= 0 && listY >= 0 && hoveredItem < this.method_25340() ? (BaseEntry)((Object)this.method_25396().get(hoveredItem)) : null;
    }

    protected int method_25329() {
        return super.method_25329() + 8;
    }

    public int method_25322() {
        return super.method_25322() + 32;
    }

    public static BaseEntry ConfigToEntry(ConfigBuilder.ConfigValue<?> configValue, class_2561 name) {
        class_339 widget = configValue.getWidget(125, 20).get();
        return new ResettableEntry(name, widget, configValue);
    }

    public static BaseEntry vrOptionToEntry(VRSettings.VrOptions option) {
        GuiVROptionSlider widget;
        class_7919 tooltip;
        ClientDataHolderVR dh = ClientDataHolderVR.getInstance();
        String optionString = "vivecraft.options." + option.name();
        String tooltipString = optionString + ".tooltip";
        if (class_1074.method_4663((String)tooltipString)) {
            String tooltipPrefix = "";
            if (dh.vrSettings.overrides.hasSetting(option)) {
                VRSettings.ServerOverrides.Setting setting = dh.vrSettings.overrides.getSetting(option);
                if (setting.isValueOverridden()) {
                    tooltipPrefix = class_1074.method_4662((String)"vivecraft.message.overriddenbyserver", (Object[])new Object[0]);
                } else if (setting.isFloat() && (setting.isValueMinOverridden() || setting.isValueMaxOverridden())) {
                    tooltipPrefix = class_1074.method_4662((String)"vivecraft.message.limitedbyserver", (Object[])new Object[]{Float.valueOf(setting.getValueMin()), Float.valueOf(setting.getValueMax())});
                }
            }
            tooltip = class_7919.method_47407((class_2561)class_2561.method_43470((String)(tooltipPrefix + class_1074.method_4662((String)tooltipString, (Object[])new Object[]{null}))));
        } else {
            tooltip = null;
        }
        if (option.getEnumFloat()) {
            widget = new GuiVROptionSlider(option.returnEnumOrdinal(), 0, 0, 145, 20, option, true);
            widget.method_47400(tooltip);
        } else {
            widget = class_4185.method_46430((class_2561)class_2561.method_43470((String)dh.vrSettings.getButtonDisplayString(option, true)), button -> {
                dh.vrSettings.setOptionValue(option);
                button.method_25355((class_2561)class_2561.method_43470((String)dh.vrSettings.getButtonDisplayString(option, true)));
            }).method_46437(145, 20).method_46436(tooltip).method_46431();
        }
        WidgetEntry entry = new WidgetEntry((class_2561)class_2561.method_43471((String)optionString), (class_339)widget);
        if (dh.vrSettings.overrides.hasSetting(option) && dh.vrSettings.overrides.getSetting(option).isValueOverridden()) {
            ((BaseEntry)entry).setActive(false);
        }
        return entry;
    }

    public static abstract class BaseEntry
    extends class_4265.class_4266<BaseEntry> {
        protected final class_2561 name;
        private boolean active = true;

        public BaseEntry(class_2561 name) {
            this.name = name;
        }

        public boolean isActive() {
            return this.active;
        }

        public void setActive(boolean active) {
            this.active = active;
        }
    }

    public static class ResettableEntry
    extends WidgetEntry {
        public static final int VALUE_BUTTON_WIDTH = 125;
        private final class_4185 resetButton;
        private final BooleanSupplier canReset = () -> !configValue.isDefault();

        public ResettableEntry(class_2561 name, class_339 valueWidget, ConfigBuilder.ConfigValue<?> configValue) {
            super(name, valueWidget);
            this.resetButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"X"), button -> {
                configValue.reset();
                this.valueWidget = configValue.getWidget(valueWidget.method_25368(), valueWidget.method_25364()).get();
            }).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"controls.reset"))).method_46434(0, 0, 20, 20).method_46431();
        }

        @Override
        public void method_25343(class_332 guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            super.method_25343(guiGraphics, index, top, left, width, height, mouseX, mouseY, hovering, partialTick);
            this.resetButton.method_46421(left + 230);
            this.resetButton.method_46419(top);
            this.resetButton.field_22763 = this.canReset.getAsBoolean();
            this.resetButton.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        }

        @Override
        public List<? extends class_364> method_25396() {
            return ImmutableList.of((Object)this.valueWidget, (Object)this.resetButton);
        }

        @Override
        public List<? extends class_6379> method_37025() {
            return ImmutableList.of((Object)this.valueWidget, (Object)this.resetButton);
        }

        @Override
        public void setActive(boolean active) {
            super.setActive(active);
            this.resetButton.field_22763 = active;
        }
    }

    public static class WidgetEntry
    extends BaseEntry {
        protected class_339 valueWidget;
        public static final int VALUE_BUTTON_WIDTH = 145;

        public WidgetEntry(class_2561 name, class_339 valueWidget) {
            super(name);
            this.valueWidget = valueWidget;
        }

        public void method_25343(class_332 guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            class_327 class_3272 = class_310.method_1551().field_1772;
            int n = top + height / 2;
            Objects.requireNonNull(class_310.method_1551().field_1772);
            guiGraphics.method_27535(class_3272, this.name, left + 90 - 140, n - 9 / 2, 0xFFFFFF);
            this.valueWidget.method_46421(left + 105);
            this.valueWidget.method_46419(top);
            this.valueWidget.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        }

        public List<? extends class_364> method_25396() {
            return ImmutableList.of((Object)this.valueWidget);
        }

        public List<? extends class_6379> method_37025() {
            return ImmutableList.of((Object)this.valueWidget);
        }

        @Override
        public void setActive(boolean active) {
            super.setActive(active);
            this.valueWidget.field_22763 = active;
        }
    }

    public static class CategoryEntry
    extends BaseEntry {
        private final int width;

        public CategoryEntry(class_2561 name) {
            super(name);
            this.width = class_310.method_1551().field_1772.method_27525((class_5348)this.name);
        }

        public void method_25343(class_332 guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            class_327 class_3272 = class_310.method_1551().field_1772;
            int n = class_310.method_1551().field_1755.field_22789 / 2 - this.width / 2;
            Objects.requireNonNull(class_310.method_1551().field_1772);
            guiGraphics.method_27535(class_3272, this.name, n, top + height - 9 - 1, 0xFFFFFF);
        }

        @Nullable
        public class_8016 method_48205(class_8023 event) {
            return null;
        }

        public List<? extends class_364> method_25396() {
            return Collections.emptyList();
        }

        public List<? extends class_6379> method_37025() {
            return ImmutableList.of((Object)new class_6379(){

                public class_6379.class_6380 method_37018() {
                    return class_6379.class_6380.field_33785;
                }

                public void method_37020(class_6382 narrationElementOutput) {
                    narrationElementOutput.method_37034(class_6381.field_33788, name);
                }
            });
        }
    }
}

