/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.mixin.shader.client;

import foundry.veil.Veil;
import foundry.veil.api.client.render.shader.program.ShaderUniformCache;
import foundry.veil.impl.client.render.shader.processor.VanillaShaderProcessor;
import foundry.veil.impl.client.render.shader.program.ShaderProgramImpl;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.List;
import java.util.Map;
import net.minecraft.class_281;
import net.minecraft.class_284;
import net.minecraft.class_3679;
import net.minecraft.class_5912;
import net.minecraft.class_5944;
import org.lwjgl.opengl.GL20C;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_5944.class}, priority=800)
public abstract class ShaderInstanceMixin
implements class_3679 {
    @Shadow
    @Final
    private int field_29493;
    @Shadow
    @Final
    private List<Integer> field_29491;
    @Shadow
    @Final
    public Map<String, class_284> field_29492;
    @Shadow
    @Final
    private String field_29494;
    @Shadow
    @Final
    private List<String> field_29488;
    @Shadow
    @Final
    private List<Integer> field_29489;
    @Unique
    private final Map<String, class_284> veil$uniforms = new Object2ObjectArrayMap();

    @Inject(method={"getOrCreate"}, at={@At(value="HEAD")}, cancellable=true)
    private static void veil$cancelDummyProgram(class_5912 provider, class_281.class_282 type, String name, CallbackInfoReturnable<class_281> cir) {
        if (ShaderProgramImpl.Wrapper.constructingProgram != null) {
            cir.setReturnValue((Object)new ShaderProgramImpl.ShaderWrapper(type, ShaderProgramImpl.Wrapper.constructingProgram));
        }
    }

    @Inject(method={"getOrCreate"}, at={@At(value="HEAD")})
    private static void veil$setupFallbackProcessor(class_5912 provider, class_281.class_282 type, String name, CallbackInfoReturnable<class_281> cir) {
        if (Veil.platform().hasErrors()) {
            return;
        }
        VanillaShaderProcessor.setup(provider);
    }

    @Inject(method={"getOrCreate"}, at={@At(value="RETURN")})
    private static void veil$clearFallbackProcessor(CallbackInfoReturnable<class_281> cir) {
        if (Veil.platform().hasErrors()) {
            return;
        }
        VanillaShaderProcessor.free();
    }

    @Inject(method={"close"}, at={@At(value="HEAD")})
    public void close(CallbackInfo ci) {
        if (this.veil$uniforms.isEmpty()) {
            return;
        }
        for (class_284 uniform : this.veil$uniforms.values()) {
            uniform.close();
        }
    }

    @Inject(method={"apply"}, at={@At(value="TAIL")})
    public void apply(CallbackInfo ci) {
        if (this.veil$uniforms.isEmpty()) {
            return;
        }
        for (class_284 uniform : this.veil$uniforms.values()) {
            uniform.method_1300();
        }
    }

    @Inject(method={"updateLocations"}, at={@At(value="HEAD")})
    public void clearSamplerLocations(CallbackInfo ci) {
        this.field_29489.clear();
    }

    @Inject(method={"updateLocations"}, at={@At(value="TAIL")})
    public void updateLocations(CallbackInfo ci) {
        if (this instanceof ShaderProgramImpl.Wrapper) {
            return;
        }
        for (class_284 uniform2 : this.veil$uniforms.values()) {
            uniform2.method_1297(-1);
        }
        int uniformCount = GL20C.glGetProgrami((int)this.field_29493, (int)35718);
        int maxUniformLength = GL20C.glGetProgrami((int)this.field_29493, (int)35719);
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer size = stack.mallocInt(1);
            IntBuffer type = stack.mallocInt(1);
            block19: for (int i = 0; i < uniformCount; ++i) {
                int minecraftCount;
                int minecraftType;
                String name = GL20C.glGetActiveUniform((int)this.field_29493, (int)i, (int)maxUniformLength, (IntBuffer)size, (IntBuffer)type);
                int length = size.get(0);
                if (length > 1) {
                    name = name.substring(0, name.length() - 3);
                }
                if (this.field_29492.containsKey(name) || this.field_29488.contains(name)) continue;
                int dataType = type.get(0);
                String typeName = ShaderUniformCache.getName(dataType);
                if (ShaderUniformCache.isSampler(dataType)) {
                    for (int j = 0; j < length; ++j) {
                        String samplerName = length > 1 ? name + "[" + j + "]" : name;
                        Veil.LOGGER.debug("Shader {} detected sampler: {}", (Object)this.field_29494, (Object)(typeName + " " + samplerName));
                        this.field_29488.add(samplerName);
                        this.field_29489.add(class_284.method_22096((int)this.field_29493, (CharSequence)samplerName));
                    }
                    continue;
                }
                switch (dataType) {
                    case 5124: {
                        minecraftType = 0;
                        minecraftCount = 1;
                        break;
                    }
                    case 35667: {
                        minecraftType = 1;
                        minecraftCount = 2;
                        break;
                    }
                    case 35668: {
                        minecraftType = 2;
                        minecraftCount = 3;
                        break;
                    }
                    case 35669: {
                        minecraftType = 3;
                        minecraftCount = 4;
                        break;
                    }
                    case 5126: {
                        minecraftType = 4;
                        minecraftCount = 1;
                        break;
                    }
                    case 35664: {
                        minecraftType = 5;
                        minecraftCount = 2;
                        break;
                    }
                    case 35665: {
                        minecraftType = 6;
                        minecraftCount = 3;
                        break;
                    }
                    case 35666: {
                        minecraftType = 7;
                        minecraftCount = 4;
                        break;
                    }
                    case 35674: {
                        minecraftType = 8;
                        minecraftCount = 4;
                        break;
                    }
                    case 35675: {
                        minecraftType = 9;
                        minecraftCount = 9;
                        break;
                    }
                    case 35676: {
                        minecraftType = 10;
                        minecraftCount = 16;
                        break;
                    }
                    default: {
                        Veil.LOGGER.error("Unsupported Uniform Type: {}", (Object)typeName);
                        continue block19;
                    }
                }
                for (int j = 0; j < length; ++j) {
                    FloatBuffer floatBuffer;
                    class_284 uniform3;
                    class_284 old;
                    Object uniformName = length > 1 ? name + "[" + j + "]" : name;
                    int location = class_284.method_22096((int)this.field_29493, (CharSequence)uniformName);
                    if (location == -1) {
                        if (length == 1) {
                            Veil.LOGGER.warn("Shader {} could not find uniform named {} in the specified shader program.", (Object)this.field_29494, uniformName);
                        }
                        if ((old = this.veil$uniforms.remove(uniformName)) == null) continue;
                        old.close();
                        continue;
                    }
                    Veil.LOGGER.debug("Shader {} detected uniform: {}", (Object)this.field_29494, (Object)(typeName + " " + (String)uniformName));
                    old = this.veil$uniforms.get(uniformName);
                    if (old != null) {
                        if (old.method_35662() != minecraftType) {
                            old.close();
                            uniform3 = new class_284((String)uniformName, minecraftType, minecraftCount, (class_3679)this);
                            this.veil$uniforms.put((String)uniformName, uniform3);
                        } else {
                            uniform3 = old;
                        }
                    } else {
                        uniform3 = new class_284((String)uniformName, minecraftType, minecraftCount, (class_3679)this);
                        this.veil$uniforms.put((String)uniformName, uniform3);
                    }
                    IntBuffer intBuffer = uniform3.method_35663();
                    if (intBuffer != null) {
                        MemoryUtil.memSet((IntBuffer)intBuffer, (int)0);
                    }
                    if ((floatBuffer = uniform3.method_35664()) != null) {
                        MemoryUtil.memSet((FloatBuffer)floatBuffer, (int)Float.floatToIntBits(0.0f));
                    }
                    this.field_29491.add(location);
                    uniform3.method_1297(location);
                    this.field_29492.put((String)uniformName, uniform3);
                }
            }
        }
        this.veil$uniforms.values().removeIf(uniform -> uniform.method_35660() == -1);
    }
}

