/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.mixin.performance.client;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import foundry.veil.Veil;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.shader.program.ShaderProgram;
import foundry.veil.ext.PerformanceRenderTargetExtension;
import java.nio.FloatBuffer;
import net.minecraft.class_276;
import net.minecraft.class_2960;
import net.minecraft.class_6364;
import org.lwjgl.opengl.ARBClearTexture;
import org.lwjgl.opengl.ARBCopyImage;
import org.lwjgl.opengl.ARBDirectStateAccess;
import org.lwjgl.opengl.GL11C;
import org.lwjgl.opengl.NVDrawTexture;
import org.lwjgl.system.MemoryStack;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_276.class})
public abstract class PerformanceRenderTargetMixin
implements PerformanceRenderTargetExtension {
    @Unique
    private static final class_2960 veil$BLIT_SHADER = Veil.veilPath("blit_screen");
    @Shadow
    public int field_1482;
    @Shadow
    public int field_1481;
    @Shadow
    @Final
    private float[] field_1479;
    @Shadow
    @Final
    public boolean field_1478;
    @Shadow
    public int field_1476;

    @Shadow
    public abstract int method_30277();

    @Shadow
    public abstract int method_30278();

    @Shadow
    public abstract void method_1235(boolean var1);

    @Shadow
    public abstract void method_1240();

    @Inject(method={"copyDepthFrom"}, at={@At(value="HEAD")}, cancellable=true)
    public void copyDepthFrom(class_276 otherTarget, CallbackInfo ci) {
        if (!(this.getClass() instanceof class_6364)) {
            return;
        }
        if (!this.field_1478 || !otherTarget.field_1478) {
            ci.cancel();
            return;
        }
        if (VeilRenderSystem.copyImageSupported() && this.field_1482 == otherTarget.field_1482 && this.field_1481 == otherTarget.field_1481) {
            ci.cancel();
            ARBCopyImage.glCopyImageSubData((int)otherTarget.method_30278(), (int)3553, (int)0, (int)0, (int)0, (int)0, (int)this.method_30278(), (int)3553, (int)0, (int)0, (int)0, (int)0, (int)this.field_1482, (int)this.field_1481, (int)1);
        } else if (VeilRenderSystem.directStateAccessSupported()) {
            ci.cancel();
            ARBDirectStateAccess.glBlitNamedFramebuffer((int)otherTarget.field_1476, (int)this.field_1476, (int)0, (int)0, (int)otherTarget.field_1482, (int)otherTarget.field_1481, (int)0, (int)0, (int)this.field_1482, (int)this.field_1481, (int)256, (int)9728);
        }
    }

    @Inject(method={"clear"}, at={@At(value="HEAD")}, cancellable=true)
    public void clear(boolean clearError, CallbackInfo ci) {
        if (!(this.getClass() instanceof class_6364)) {
            return;
        }
        boolean clearTex = VeilRenderSystem.clearTextureSupported();
        if (!clearTex && !VeilRenderSystem.directStateAccessSupported()) {
            return;
        }
        ci.cancel();
        try (MemoryStack stack = MemoryStack.stackPush();){
            if (clearTex) {
                ARBClearTexture.glClearTexImage((int)this.method_30277(), (int)0, (int)6408, (int)5126, (float[])this.field_1479);
            } else {
                ARBDirectStateAccess.glClearNamedFramebufferfv((int)this.field_1476, (int)6144, (int)0, (float[])this.field_1479);
            }
            if (this.field_1478) {
                if (clearTex) {
                    ARBClearTexture.glClearTexImage((int)this.method_30278(), (int)0, (int)6402, (int)5126, (FloatBuffer)stack.floats(1.0f));
                } else {
                    ARBDirectStateAccess.glClearNamedFramebufferfv((int)this.field_1476, (int)6145, (int)0, (FloatBuffer)stack.floats(1.0f));
                }
            }
        }
        if (clearError) {
            GL11C.glGetError();
        }
    }

    @Inject(method={"_blitToScreen"}, at={@At(value="HEAD")}, cancellable=true)
    private void _blitToScreen(int width, int height, boolean disableBlend, CallbackInfo ci) {
        GlStateManager._disableDepthTest();
        if (VeilRenderSystem.nvDrawTextureSupported()) {
            ci.cancel();
            RenderSystem.assertOnRenderThread();
            GlStateManager._colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            GlStateManager._depthMask((boolean)false);
            if (disableBlend) {
                GlStateManager._disableBlend();
            }
            NVDrawTexture.glDrawTextureNV((int)this.method_30277(), (int)0, (float)0.0f, (float)0.0f, (float)width, (float)height, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f);
            GlStateManager._colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            GlStateManager._depthMask((boolean)true);
            return;
        }
        if (disableBlend && VeilRenderSystem.directStateAccessSupported()) {
            ci.cancel();
            RenderSystem.assertOnRenderThread();
            GlStateManager._colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            ARBDirectStateAccess.glBlitNamedFramebuffer((int)this.field_1476, (int)0, (int)0, (int)0, (int)this.field_1482, (int)this.field_1481, (int)0, (int)0, (int)width, (int)height, (int)16384, (int)9728);
        } else {
            ShaderProgram shader = VeilRenderSystem.setShader(veil$BLIT_SHADER);
            if (shader == null) {
                return;
            }
            ci.cancel();
            RenderSystem.assertOnRenderThread();
            GlStateManager._viewport((int)0, (int)0, (int)width, (int)height);
            GlStateManager._colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            GlStateManager._depthMask((boolean)false);
            if (disableBlend) {
                GlStateManager._disableBlend();
            }
            VeilRenderSystem.bindTextures(0, this.method_30277());
            shader.bind();
            VeilRenderSystem.drawScreenQuad();
            ShaderProgram.unbind();
        }
        GlStateManager._colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GlStateManager._depthMask((boolean)true);
    }

    @Override
    public void veil$clearColorBuffer(boolean clearError) {
        RenderSystem.assertOnRenderThreadOrInit();
        int colorTextureId = this.method_30277();
        if (VeilRenderSystem.clearTextureSupported() && GL11C.glIsTexture((int)colorTextureId)) {
            ARBClearTexture.glClearTexImage((int)colorTextureId, (int)0, (int)6408, (int)5126, (float[])this.field_1479);
        } else if (VeilRenderSystem.directStateAccessSupported()) {
            ARBDirectStateAccess.glClearNamedFramebufferfv((int)this.field_1476, (int)6144, (int)0, (float[])this.field_1479);
        } else {
            this.method_1235(true);
            GlStateManager._clearColor((float)this.field_1479[0], (float)this.field_1479[1], (float)this.field_1479[2], (float)this.field_1479[3]);
            GlStateManager._clear((int)16384, (boolean)clearError);
            this.method_1240();
        }
        if (clearError) {
            GL11C.glGetError();
        }
    }
}

