/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.resource;

import foundry.veil.api.client.imgui.VeilImGuiUtil;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.resource.VeilResource;
import foundry.veil.api.resource.VeilResourceAction;
import foundry.veil.api.resource.VeilResourceInfo;
import foundry.veil.impl.resource.action.OverrideAction;
import imgui.ImGui;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.nio.file.Path;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_5348;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class VeilResourceRenderer {
    private static final class_2561 COPY_PATH = class_2561.method_43471((String)"resource.veil.action.copy_path");
    private static final class_2561 OPEN_FOLDER = class_2561.method_43471((String)"resource.veil.action.open_folder");

    public static void renderFilename(VeilResource<?> resource, boolean fullName) {
        ImGui.pushID((int)resource.hashCode());
        ImGui.beginGroup();
        resource.render(false, fullName);
        if (ImGui.beginDragDropSource((int)8)) {
            ImGui.setDragDropPayload((String)"VEIL_RESOURCE", resource, (int)2);
            resource.render(true, fullName);
            ImGui.endDragDropSource();
        }
        ImGui.endGroup();
        ImGui.popID();
        VeilResourceInfo info = resource.resourceInfo();
        if (ImGui.beginPopupContextItem((String)String.valueOf(info.location()))) {
            ImGui.pushStyleVar((int)14, (float)2.0f, (float)2.0f);
            ObjectArrayList actions = new ObjectArrayList(resource.getActions());
            actions.addFirst(new OverrideAction());
            if (ImGui.selectable((String)"##copy_path")) {
                ImGui.setClipboardText((String)info.location().toString());
            }
            ImGui.pushStyleVar((int)14, (float)0.0f, (float)0.0f);
            ImGui.setItemAllowOverlap();
            ImGui.sameLine();
            VeilImGuiUtil.icon(60305);
            ImGui.sameLine();
            ImGui.popStyleVar();
            VeilImGuiUtil.component((class_5348)COPY_PATH);
            ImGui.beginDisabled((boolean)info.isStatic());
            if (ImGui.selectable((String)"##open_folder")) {
                Path file;
                Path path = file = info.modResourcePath() != null ? info.modResourcePath() : info.filePath();
                if (file.getParent() != null) {
                    class_156.method_668().method_672(file.getParent().toFile());
                }
            }
            ImGui.pushStyleVar((int)14, (float)0.0f, (float)0.0f);
            ImGui.setItemAllowOverlap();
            ImGui.sameLine();
            VeilImGuiUtil.icon(60591);
            ImGui.sameLine();
            ImGui.popStyleVar();
            VeilImGuiUtil.component((class_5348)OPEN_FOLDER);
            ImGui.endDisabled();
            for (int i = 0; i < actions.size(); ++i) {
                VeilResourceAction action = (VeilResourceAction)actions.get(i);
                if (ImGui.selectable((String)("##action" + i))) {
                    action.perform(VeilRenderSystem.renderer().getEditorManager(), resource);
                }
                ImGui.pushStyleVar((int)14, (float)0.0f, (float)0.0f);
                ImGui.setItemAllowOverlap();
                ImGui.sameLine();
                action.getIcon().ifPresent(icon -> {
                    VeilImGuiUtil.icon(icon);
                    ImGui.sameLine();
                });
                ImGui.popStyleVar();
                VeilImGuiUtil.component((class_5348)action.getName());
            }
            ImGui.popStyleVar();
            ImGui.endPopup();
        }
    }
}

