/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.resource;

import foundry.veil.Veil;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.VeilRenderer;
import foundry.veil.api.resource.VeilResource;
import foundry.veil.api.resource.VeilResourceInfo;
import foundry.veil.api.resource.VeilResourceLoader;
import foundry.veil.api.resource.VeilResourceManager;
import foundry.veil.api.resource.type.UnknownResource;
import foundry.veil.api.util.CompositeReloadListener;
import foundry.veil.ext.PackResourcesExtension;
import foundry.veil.impl.resource.VeilPackResources;
import foundry.veil.impl.resource.loader.BlockModelResourceLoader;
import foundry.veil.impl.resource.loader.FramebufferResourceLoader;
import foundry.veil.impl.resource.loader.LanguageResourceLoader;
import foundry.veil.impl.resource.loader.McMetaResourceLoader;
import foundry.veil.impl.resource.loader.PostPipelineResourceLoader;
import foundry.veil.impl.resource.loader.RenderTypeResourceLoader;
import foundry.veil.impl.resource.loader.ShaderIncludeLoader;
import foundry.veil.impl.resource.loader.ShaderResourceLoader;
import foundry.veil.impl.resource.loader.TextResourceLoader;
import foundry.veil.impl.resource.loader.TextureResourceLoader;
import foundry.veil.impl.resource.loader.VanillaShaderResourceLoader;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectSets;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import net.minecraft.class_1011;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3695;
import net.minecraft.class_5912;
import net.minecraft.class_6861;
import net.minecraft.class_7367;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.system.NativeResource;

@ApiStatus.Internal
public class VeilResourceManagerImpl
implements VeilResourceManager,
NativeResource {
    private static final AtomicInteger WATCHER_ID = new AtomicInteger(1);
    private final TextResourceLoader textResourceLoader;
    private final ObjectList<VeilResourceLoader> loaders;
    private final List<VeilPackResources> packResources;
    private final Object2ObjectMap<Path, PackResourceListener> watchers;
    private class_3300 serverResourceManager = class_3300.class_5353.field_25351;

    public VeilResourceManagerImpl() {
        this.textResourceLoader = new TextResourceLoader();
        this.loaders = new ObjectArrayList(10);
        this.packResources = new LinkedList<VeilPackResources>();
        this.watchers = new Object2ObjectArrayMap();
    }

    public void addVeilLoaders(VeilRenderer renderer) {
        this.addLoader(new ShaderResourceLoader(renderer.getShaderManager()));
        this.addLoader(new ShaderIncludeLoader());
        this.addLoader(new VanillaShaderResourceLoader());
        this.addLoader(new PostPipelineResourceLoader());
        this.addLoader(new FramebufferResourceLoader());
        this.addLoader(new RenderTypeResourceLoader());
        this.addLoader(new TextureResourceLoader());
        this.addLoader(new McMetaResourceLoader());
        this.addLoader(new LanguageResourceLoader());
        this.addLoader(new BlockModelResourceLoader());
    }

    public void addLoader(VeilResourceLoader loader) {
        this.loaders.add((Object)loader);
    }

    private void loadPack(class_3300 resourceManager, VeilPackResources resources, Map<Path, PackResourceListener> watchers, class_3264 type, class_3262 packResources) {
        if (packResources instanceof PackResourcesExtension) {
            PackResourcesExtension ext = (PackResourcesExtension)packResources;
            try {
                ext.veil$listResources((packType, loc, packPath, path, modResourcePath) -> {
                    if (packType != type) {
                        return;
                    }
                    try {
                        VeilResource<?> resource = this.visitResource(packType, (class_5912)resourceManager, loc, path, modResourcePath);
                        resources.add(packType, loc, resource);
                        if (!resource.resourceInfo().isStatic()) {
                            Path listenPath;
                            Path path2 = listenPath = modResourcePath != null ? modResourcePath : path;
                            if (listenPath != null) {
                                try {
                                    watchers.computeIfAbsent(packPath, p -> new PackResourceListener(this, (Path)p)).listen(resource, listenPath);
                                }
                                catch (Throwable t) {
                                    Veil.LOGGER.error("Failed to listen to resource: {}", (Object)resource.resourceInfo().location(), (Object)t);
                                }
                            }
                        }
                    }
                    catch (Throwable t) {
                        Veil.LOGGER.error("Error loading resource: {}", (Object)loc, (Object)t);
                    }
                });
                return;
            }
            catch (Throwable t) {
                Veil.LOGGER.error("Failed to load resources from {}", (Object)this.getClass().getSimpleName(), (Object)t);
            }
        }
        for (String namespace : packResources.method_14406(type)) {
            packResources.method_14408(type, namespace, "", (loc, inputStreamIoSupplier) -> {
                try {
                    resources.add(type, (class_2960)loc, this.visitResource(type, (class_5912)resourceManager, (class_2960)loc, null, null));
                }
                catch (Throwable t) {
                    Veil.LOGGER.error("Error loading resource: {}", loc, (Object)t);
                }
            });
        }
    }

    private VeilResource<?> visitResource(@Nullable class_3264 packType, class_5912 provider, class_2960 loc, @Nullable Path path, @Nullable Path modResourcePath) throws IOException {
        for (VeilResourceLoader loader : this.loaders) {
            if (!loader.canLoad(packType, loc, path, modResourcePath)) continue;
            return loader.load(this, provider, packType, loc, path, modResourcePath);
        }
        if (this.textResourceLoader.canLoad(packType, loc, path, modResourcePath)) {
            return this.textResourceLoader.load(this, provider, packType, loc, path, modResourcePath);
        }
        return new UnknownResource(new VeilResourceInfo(packType, loc, path, modResourcePath, false));
    }

    public class_3302 createReloadListener() {
        return CompositeReloadListener.of(new class_3302(){

            public CompletableFuture<Void> method_25931(class_3302.class_4045 preparationBarrier, class_3300 resourceManager, class_3695 prepareProfiler, class_3695 applyProfiler, Executor backgroundExecutor, Executor gameExecutor) {
                return VeilResourceManagerImpl.this.reloadClient(preparationBarrier, resourceManager, prepareProfiler, applyProfiler, backgroundExecutor, gameExecutor);
            }

            public String method_22322() {
                return VeilResourceManager.class.getSimpleName() + " Client";
            }
        }, new class_3302(){

            public CompletableFuture<Void> method_25931(class_3302.class_4045 preparationBarrier, class_3300 resourceManager, class_3695 prepareProfiler, class_3695 applyProfiler, Executor backgroundExecutor, Executor gameExecutor) {
                return VeilResourceManagerImpl.this.reloadServer(preparationBarrier, resourceManager, prepareProfiler, applyProfiler, backgroundExecutor, gameExecutor);
            }

            public String method_22322() {
                return VeilResourceManager.class.getSimpleName() + " Server";
            }
        });
    }

    private CompletableFuture<Void> reloadClient(class_3302.class_4045 preparationBarrier, class_3300 resourceManager, class_3695 preparationsProfiler, class_3695 reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            LinkedList<VeilPackResources> packs = new LinkedList<VeilPackResources>();
            Object2ObjectArrayMap watchers = new Object2ObjectArrayMap();
            resourceManager.method_29213().flatMap(pack -> {
                Stream<class_3262> stream;
                if (pack instanceof PackResourcesExtension) {
                    PackResourcesExtension extension = (PackResourcesExtension)pack;
                    stream = extension.veil$listPacks();
                } else {
                    stream = Stream.of(pack);
                }
                return stream;
            }).forEach(arg_0 -> this.lambda$reloadClient$5(resourceManager, (Object2ObjectMap)watchers, packs, gameExecutor, arg_0));
            return new Preparations(packs, (Object2ObjectMap<Path, PackResourceListener>)watchers);
        }, backgroundExecutor).thenCompose(arg_0 -> ((class_3302.class_4045)preparationBarrier).method_18352(arg_0))).thenAcceptAsync(preparations -> {
            this.free();
            this.packResources.addAll(preparations.packs());
            this.watchers.putAll(preparations.watchers());
        }, gameExecutor);
    }

    private CompletableFuture<Void> reloadServer(class_3302.class_4045 preparationBarrier, class_3300 resourceManager, class_3695 preparationsProfiler, class_3695 reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            this.serverResourceManager = new class_6861(class_3264.field_14190, resourceManager.method_29213().toList());
            return this.serverResourceManager;
        }, backgroundExecutor).thenCompose(arg_0 -> ((class_3302.class_4045)preparationBarrier).method_18352(arg_0))).thenAcceptAsync(serverResourceManager -> {
            this.serverResourceManager = serverResourceManager;
        }, gameExecutor);
    }

    @Override
    public class_3300 clientResources() {
        return class_310.method_1551().method_1478();
    }

    @Override
    public class_3300 serverResources() {
        return this.serverResourceManager;
    }

    @Override
    @Nullable
    public VeilResource<?> getVeilResource(String namespace, String path) {
        for (VeilPackResources pack : this.packResources) {
            VeilResource<?> resource = pack.getVeilResource(namespace, path);
            if (resource == null) continue;
            return resource;
        }
        return null;
    }

    public void free() {
        for (PackResourceListener listener : this.watchers.values()) {
            try {
                listener.close();
            }
            catch (IOException e) {
                Veil.LOGGER.error("Error closing watch service: {}", (Object)listener.getPath(), (Object)e);
            }
        }
        this.watchers.clear();
        for (VeilPackResources resources : this.packResources) {
            resources.free();
        }
        this.packResources.clear();
        WATCHER_ID.set(1);
    }

    public List<VeilPackResources> getAllPacks() {
        return this.packResources;
    }

    private /* synthetic */ void lambda$reloadClient$5(class_3300 resourceManager, Object2ObjectMap watchers, List packs, Executor gameExecutor, class_3262 pack) {
        VeilPackResources resources = new VeilPackResources(pack.method_14409());
        this.loadPack(resourceManager, resources, (Map<Path, PackResourceListener>)watchers, class_3264.field_14188, pack);
        packs.add(resources);
        if (pack instanceof PackResourcesExtension) {
            PackResourcesExtension extension = (PackResourcesExtension)pack;
            try {
                class_7367<InputStream> icon = extension.veil$getIcon();
                if (icon != null) {
                    class_1011 image = class_1011.method_4309((InputStream)((InputStream)icon.get()));
                    boolean blur = extension.veil$blurIcon();
                    gameExecutor.execute(() -> {
                        try (class_1011 class_10112 = image;){
                            resources.loadIcon(image, blur);
                        }
                    });
                }
            }
            catch (Throwable t) {
                Veil.LOGGER.error("Failed to load icon for pack: {}", (Object)pack.method_14409(), (Object)t);
            }
        }
    }

    private static class PackResourceListener
    implements Closeable {
        private final VeilResourceManager resourceManager;
        private final Path path;
        private final WatchService watchService;
        private final ObjectSet<Path> watchedDirectories;
        private final ObjectSet<Path> ignoredPaths;
        private final Object2ObjectMap<Path, VeilResource<?>> resources;
        private final Thread watchThread;

        public PackResourceListener(VeilResourceManager resourceManager, Path path) {
            WatchService watchService;
            try {
                watchService = path.getFileSystem().newWatchService();
            }
            catch (Exception ignored) {
                watchService = null;
            }
            this.resourceManager = resourceManager;
            this.path = path;
            this.watchService = watchService;
            this.watchedDirectories = ObjectSets.synchronize((ObjectSet)new ObjectArraySet());
            this.ignoredPaths = ObjectSets.synchronize((ObjectSet)new ObjectArraySet());
            this.resources = new Object2ObjectOpenHashMap();
            if (this.watchService != null) {
                this.watchThread = new Thread(this::run, "Veil File Watcher Thread " + WATCHER_ID.getAndIncrement());
                this.watchThread.start();
            } else {
                this.watchThread = null;
            }
        }

        private void run() {
            while (true) {
                WatchKey key;
                try {
                    key = this.watchService.take();
                }
                catch (ClosedWatchServiceException e) {
                    return;
                }
                catch (Throwable t) {
                    Veil.LOGGER.error("Error waiting for file", t);
                    return;
                }
                for (WatchEvent<Path> watchEvent : key.pollEvents()) {
                    VeilResource resource;
                    WatchEvent.Kind<?> kind = watchEvent.kind();
                    if (kind == StandardWatchEventKinds.OVERFLOW) continue;
                    WatchEvent<Path> pathWatchEvent = watchEvent;
                    Path path = ((Path)key.watchable()).resolve((Path)pathWatchEvent.context());
                    if (!this.ignoredPaths.add((Object)path) || (resource = (VeilResource)this.resources.get((Object)path)) == null) continue;
                    resource.onFileSystemChange(this.resourceManager, pathWatchEvent).thenRun(() -> {
                        this.ignoredPaths.remove((Object)path);
                        class_310.method_1551().execute(() -> VeilRenderSystem.renderer().getEditorManager().onFileChange(resource));
                    });
                }
                key.reset();
            }
        }

        public void listen(VeilResource<?> resource, Path listenPath) throws IOException {
            Path folder = listenPath.getParent();
            if (folder == null) {
                return;
            }
            this.resources.put((Object)listenPath, resource);
            if (this.watchService != null && this.watchedDirectories.add((Object)folder)) {
                folder.register(this.watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
            }
        }

        @Override
        public void close() throws IOException {
            if (this.watchService != null) {
                this.watchService.close();
            }
            try {
                if (this.watchThread != null) {
                    this.watchThread.join();
                }
            }
            catch (InterruptedException e) {
                throw new IOException("Failed to stop watcher thread", e);
            }
        }

        public Path getPath() {
            return this.path;
        }
    }

    private record Preparations(List<VeilPackResources> packs, Object2ObjectMap<Path, PackResourceListener> watchers) {
    }
}

