/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.render.shader.block;

import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.shader.block.ShaderBlock;
import foundry.veil.impl.client.render.shader.block.ShaderBlockImpl;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.function.BiConsumer;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.ApiStatus;
import org.lwjgl.opengl.GL30C;
import org.lwjgl.system.MemoryUtil;

@ApiStatus.Internal
public class SizedShaderBlockImpl<T>
extends ShaderBlockImpl<T> {
    private final int size;
    private final ByteBuffer upload;
    private final BiConsumer<T, ByteBuffer> serializer;

    public SizedShaderBlockImpl(ShaderBlock.BufferBinding binding, int size, BiConsumer<T, ByteBuffer> serializer) {
        super(binding);
        this.size = size;
        this.upload = MemoryUtil.memAlloc((int)this.size);
        this.serializer = serializer;
    }

    @Override
    public void bind(int index) {
        int binding = this.binding.getGlType();
        Validate.inclusiveBetween((long)0L, (long)VeilRenderSystem.maxTargetBindings(binding), (long)index);
        if (this.buffer == 0) {
            this.dirty = true;
            ShaderBlockImpl.StorageType storageType = SizedShaderBlockImpl.getStorageType();
            this.buffer = storageType.createBuffer(binding);
            storageType.resize(binding, this.buffer, this.size);
        }
        if (this.dirty) {
            this.dirty = false;
            if (this.value != null) {
                this.serializer.accept(this.value, this.upload);
                this.upload.rewind();
            } else {
                MemoryUtil.memSet((ByteBuffer)this.upload, (int)0);
            }
            SizedShaderBlockImpl.getStorageType().write(binding, this.buffer, this.upload);
        }
        GL30C.glBindBufferBase((int)binding, (int)index, (int)this.buffer);
    }

    @Override
    public void unbind(int index) {
        int binding = this.binding.getGlType();
        Validate.inclusiveBetween((long)0L, (long)VeilRenderSystem.maxTargetBindings(binding), (long)index);
        GL30C.glBindBufferBase((int)binding, (int)index, (int)0);
    }

    @Override
    public void free() {
        super.free();
        MemoryUtil.memFree((Buffer)this.upload);
    }
}

