/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.render.shader.block;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.shader.block.ShaderBlock;
import java.nio.ByteBuffer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.ARBDirectStateAccess;
import org.lwjgl.opengl.GL15C;

@ApiStatus.Internal
public abstract class ShaderBlockImpl<T>
implements ShaderBlock<T> {
    private static StorageType storageType;
    protected final ShaderBlock.BufferBinding binding;
    protected int buffer;
    protected T value;
    protected boolean dirty;
    private int index;

    protected ShaderBlockImpl(ShaderBlock.BufferBinding binding) {
        this.binding = binding;
        this.buffer = 0;
        this.value = null;
        this.dirty = false;
        this.index = -1;
    }

    protected static StorageType getStorageType() {
        if (storageType == null) {
            storageType = VeilRenderSystem.directStateAccessSupported() ? StorageType.DSA : StorageType.LEGACY;
        }
        return storageType;
    }

    @Override
    public void set(@Nullable T value) {
        this.value = value;
        this.dirty = true;
    }

    public abstract void bind(int var1);

    public abstract void unbind(int var1);

    public ShaderBlock.BufferBinding getBinding() {
        return this.binding;
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    @Nullable
    public T getValue() {
        return this.value;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public void free() {
        VeilRenderSystem.unbind(this);
        if (this.buffer != 0) {
            GlStateManager._glDeleteBuffers((int)this.buffer);
            this.buffer = 0;
        }
    }

    public static enum StorageType {
        LEGACY{

            @Override
            public int createBuffer(int binding) {
                return GL15C.glGenBuffers();
            }

            @Override
            public void resize(int binding, int buffer, long size) {
                RenderSystem.glBindBuffer((int)binding, (int)buffer);
                GL15C.glBufferData((int)binding, (long)size, (int)35048);
            }

            @Override
            public void write(int binding, int buffer, ByteBuffer upload) {
                RenderSystem.glBindBuffer((int)binding, (int)buffer);
                GL15C.glBufferSubData((int)binding, (long)0L, (ByteBuffer)upload);
            }
        }
        ,
        DSA{

            @Override
            public int createBuffer(int binding) {
                return ARBDirectStateAccess.glCreateBuffers();
            }

            @Override
            public void resize(int binding, int buffer, long size) {
                ARBDirectStateAccess.glNamedBufferData((int)buffer, (long)size, (int)35048);
            }

            @Override
            public void write(int binding, int buffer, ByteBuffer upload) {
                ARBDirectStateAccess.glNamedBufferSubData((int)buffer, (long)0L, (ByteBuffer)upload);
            }
        };


        public abstract int createBuffer(int var1);

        public abstract void resize(int var1, int var2, long var3);

        public abstract void write(int var1, int var2, ByteBuffer var3);
    }
}

