/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.render.profiler;

import foundry.veil.Veil;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.profiler.RenderProfilerCounter;
import foundry.veil.api.client.render.profiler.VeilRenderProfiler;
import foundry.veil.impl.client.editor.PipelineStatisticsViewer;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL15C;
import org.lwjgl.opengl.GL33C;

@ApiStatus.Internal
public final class VeilRenderProfilerImpl {
    private static final Map<String, PathEntry> ENTRIES = new Object2ObjectOpenHashMap();
    private static final List<String> paths = new LinkedList<String>();
    private static final BitSet ENABLED_STATISTICS = new BitSet(RenderProfilerCounter.ALL.length);
    private static final Set<String> ENABLED_PATHS = new HashSet<String>();
    private static String path = "";
    private static int[] queries;

    private VeilRenderProfilerImpl() {
    }

    public static VeilRenderProfiler get() {
        return VeilRenderProfilerImpl.isEnabled() ? ActiveProfiler.INSTANCE : InactiveProfiler.INSTANCE;
    }

    public static void setEnabled(Collection<String> enabledPaths, RenderProfilerCounter[] statistics) {
        ENABLED_PATHS.clear();
        ENABLED_PATHS.addAll(enabledPaths);
        ENABLED_STATISTICS.clear();
        for (RenderProfilerCounter statistic : statistics) {
            ENABLED_STATISTICS.set(statistic.ordinal());
        }
    }

    public static void endFrame() {
        if (!paths.isEmpty()) {
            Veil.LOGGER.error("Mismatched push() and pop()");
            paths.clear();
        }
        ENTRIES.clear();
        if (queries != null && !VeilRenderProfilerImpl.isEnabled()) {
            GL15C.glDeleteQueries((int[])queries);
            queries = null;
        }
    }

    private static boolean isEnabled() {
        return VeilRenderSystem.pipelineStatisticsQuerySupported() && VeilRenderSystem.renderer().getEditorManager().isVisible(inspector -> inspector instanceof PipelineStatisticsViewer);
    }

    public static List<ResultField> getCounters(String sectionPath, RenderProfilerCounter sortedStatistic) {
        String section;
        LinkedList<ResultField> list = new LinkedList<ResultField>();
        if (!((String)sectionPath).isEmpty()) {
            sectionPath = (String)sectionPath + "\u001e";
        }
        long[] globalCount = new long[RenderProfilerCounter.ALL.length];
        long[] localCount = new long[RenderProfilerCounter.ALL.length];
        for (Map.Entry<String, PathEntry> entry : ENTRIES.entrySet()) {
            boolean isRoot;
            section = entry.getKey();
            boolean directChild = VeilRenderProfilerImpl.isDirectChild((String)sectionPath, section);
            boolean bl = isRoot = section.indexOf(30) == -1;
            if (!directChild && !isRoot) continue;
            PathEntry value = entry.getValue();
            long[] counters = value.accumulatedCounters;
            for (RenderProfilerCounter statistic : value.statistics) {
                int index = statistic.ordinal();
                long counter = counters[index];
                if (directChild) {
                    int n = index;
                    localCount[n] = localCount[n] + counter;
                }
                if (!isRoot) continue;
                int n = index;
                globalCount[n] = globalCount[n] + counter;
            }
        }
        for (Map.Entry<String, PathEntry> entry : ENTRIES.entrySet()) {
            section = entry.getKey();
            if (!VeilRenderProfilerImpl.isDirectChild((String)sectionPath, section)) continue;
            PathEntry value = entry.getValue();
            list.add(new ResultField(section.substring(((String)sectionPath).length()), value.accumulatedCounters, localCount, globalCount, value.statistics, sortedStatistic));
        }
        return list;
    }

    private static boolean isDirectChild(String sectionPath, String entry) {
        return entry.length() > sectionPath.length() && entry.startsWith(sectionPath) && entry.indexOf(30, sectionPath.length() + 1) < 0;
    }

    private static enum ActiveProfiler implements VeilRenderProfiler
    {
        INSTANCE;


        @Override
        public void push(String name, RenderProfilerCounter ... statistics) {
            if (statistics.length == 0) {
                statistics = RenderProfilerCounter.ALL;
            }
            PathEntry old = ENTRIES.get(path);
            path = !path.isEmpty() ? path + "\u001e" + name : name;
            paths.add(path);
            PathEntry entry = ENTRIES.get(path);
            if (entry == null) {
                entry = new PathEntry(statistics);
                ENTRIES.put(path, entry);
            }
            if (ENABLED_PATHS.contains(path)) {
                if (old != null && old.tracking) {
                    old.stop();
                }
                entry.begin();
            }
        }

        @Override
        public void push(Supplier<String> name, RenderProfilerCounter ... statistics) {
            this.push(name.get(), statistics);
        }

        @Override
        public void pop() {
            if (paths.isEmpty()) {
                Veil.LOGGER.error("Tried to pop one too many times! Mismatched push() and pop()?");
                return;
            }
            PathEntry current = ENTRIES.get(path);
            paths.removeLast();
            path = paths.isEmpty() ? "" : paths.getLast();
            PathEntry previous = ENTRIES.get(path);
            if (current != null && current.tracking) {
                current.end(previous != null && previous.tracking ? previous : null);
            }
        }

        @Override
        public void popPush(String name, RenderProfilerCounter ... statistics) {
            this.pop();
            this.push(name, statistics);
        }

        @Override
        public void popPush(Supplier<String> name, RenderProfilerCounter ... statistics) {
            this.pop();
            this.push(name.get(), statistics);
        }
    }

    private static enum InactiveProfiler implements VeilRenderProfiler
    {
        INSTANCE;


        @Override
        public void push(String name, RenderProfilerCounter ... statistics) {
        }

        @Override
        public void push(Supplier<String> name, RenderProfilerCounter ... statistics) {
        }

        @Override
        public void pop() {
        }

        @Override
        public void popPush(String name, RenderProfilerCounter ... statistics) {
        }

        @Override
        public void popPush(Supplier<String> name, RenderProfilerCounter ... statistics) {
        }
    }

    public static class PathEntry {
        private final RenderProfilerCounter[] statistics;
        private final long[] accumulatedCounters;
        private boolean tracking;

        public PathEntry(RenderProfilerCounter[] statistics) {
            this.statistics = statistics;
            this.accumulatedCounters = new long[RenderProfilerCounter.ALL.length];
            this.tracking = false;
        }

        public void begin() {
            if (queries == null) {
                queries = new int[RenderProfilerCounter.ALL.length];
                GL15C.glGenQueries((int[])queries);
            }
            for (RenderProfilerCounter statistic : this.statistics) {
                if (!ENABLED_STATISTICS.get(statistic.ordinal())) continue;
                GL15C.glBeginQuery((int)statistic.getId(), (int)queries[statistic.ordinal()]);
            }
            this.tracking = true;
        }

        public void stop() {
            for (RenderProfilerCounter statistic : this.statistics) {
                if (!ENABLED_STATISTICS.get(statistic.ordinal())) continue;
                GL15C.glEndQuery((int)statistic.getId());
                int index = statistic.ordinal();
                long count = GL33C.glGetQueryObjecti64((int)queries[index], (int)34918);
                int n = index;
                this.accumulatedCounters[n] = this.accumulatedCounters[n] + count;
            }
        }

        public void end(@Nullable PathEntry previous) {
            for (RenderProfilerCounter statistic : this.statistics) {
                if (!ENABLED_STATISTICS.get(statistic.ordinal())) continue;
                GL15C.glEndQuery((int)statistic.getId());
                int index = statistic.ordinal();
                long count = GL33C.glGetQueryObjecti64((int)queries[index], (int)34918);
                if (previous != null) {
                    int n = index;
                    previous.accumulatedCounters[n] = previous.accumulatedCounters[n] + count;
                }
                int n = index;
                this.accumulatedCounters[n] = this.accumulatedCounters[n] + count;
            }
            this.tracking = false;
            if (previous != null) {
                previous.begin();
            }
        }

        public long[] getAccumulatedCounters() {
            return this.accumulatedCounters;
        }

        public RenderProfilerCounter[] getStatistics() {
            return this.statistics;
        }
    }

    public record ResultField(String name, long[] count, long[] localCount, long[] globalCount, RenderProfilerCounter[] statistics, RenderProfilerCounter sortedStatistic) implements Comparable<ResultField>
    {
        public double getPercentage(RenderProfilerCounter statistic) {
            long total = this.localCount[statistic.ordinal()];
            if (total == 0L) {
                return 0.0;
            }
            return 100.0 * (double)this.count[statistic.ordinal()] / (double)total;
        }

        public double getGlobalPercentage(RenderProfilerCounter statistic) {
            long total = this.globalCount[statistic.ordinal()];
            if (total == 0L) {
                return 0.0;
            }
            return 100.0 * (double)this.count[statistic.ordinal()] / (double)total;
        }

        @Override
        public int compareTo(ResultField other) {
            int index = this.sortedStatistic.ordinal();
            if (other.count[index] < this.count[index]) {
                return -1;
            }
            return other.count[index] > this.count[index] ? 1 : other.name.compareTo(this.name);
        }

        public int getColor() {
            return (this.name.hashCode() & 0xAAAAAA) + 0x444444;
        }
    }
}

