/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.render.perspective;

import foundry.veil.Veil;
import foundry.veil.api.compat.IrisCompat;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import net.minecraft.class_761;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class IrisPipelineAccess {
    private static final MethodHandle GETTER;
    private static final MethodHandle SETTER;

    @Nullable
    public static Object getPipeline(class_761 levelRenderer) {
        try {
            return GETTER != null ? GETTER.invokeWithArguments(levelRenderer) : null;
        }
        catch (Throwable e) {
            Veil.LOGGER.error("Error getting Iris pipeline", e);
            return null;
        }
    }

    public static void setPipeline(class_761 levelRenderer, Object pipeline) {
        if (SETTER != null) {
            try {
                SETTER.invokeWithArguments(levelRenderer, pipeline);
            }
            catch (Throwable e) {
                Veil.LOGGER.error("Error setting Iris pipeline", e);
            }
        }
    }

    static {
        MethodHandle setter;
        MethodHandle getter;
        block3: {
            getter = null;
            setter = null;
            try {
                Field[] fields;
                if (IrisCompat.INSTANCE == null) break block3;
                for (Field field : fields = class_761.class.getDeclaredFields()) {
                    if (!field.getType().equals(IrisCompat.INSTANCE.getPipelineClass())) continue;
                    MethodHandles.Lookup lookup = MethodHandles.privateLookupIn(class_761.class, MethodHandles.lookup());
                    getter = lookup.findGetter(class_761.class, field.getName(), field.getType());
                    setter = lookup.findSetter(class_761.class, field.getName(), field.getType());
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        GETTER = getter;
        SETTER = setter;
    }
}

