/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.render;

import foundry.veil.Veil;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.VeilShaderBufferLayout;
import foundry.veil.api.client.render.shader.block.ShaderBlock;
import foundry.veil.api.client.render.shader.program.ShaderProgram;
import foundry.veil.impl.client.render.shader.block.LayoutShaderBlockImpl;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.ApiStatus;
import org.lwjgl.opengl.ARBProgramInterfaceQuery;
import org.lwjgl.opengl.GL31C;
import org.lwjgl.system.MemoryStack;

@ApiStatus.Internal
public record LayoutSerializer<T>(Field<T>[] fields) implements BiConsumer<T, ByteBuffer>
{
    public static <T> LayoutShaderBlockImpl<T> create(VeilShaderBufferLayout<T> layout, ShaderProgram shader, String name, int blockIndex) {
        int program = shader.getProgram();
        ShaderBlock.BufferBinding binding = layout.binding();
        if (VeilRenderSystem.programInterfaceQuerySupported()) {
            int bufferInterface = binding == ShaderBlock.BufferBinding.UNIFORM ? 37602 : 37606;
            int fieldInterface = binding == ShaderBlock.BufferBinding.UNIFORM ? 37601 : 37605;
            try (MemoryStack stack = MemoryStack.stackPush();){
                IntBuffer fieldProperties = stack.ints(37628);
                IntBuffer values = stack.mallocInt(1);
                ARBProgramInterfaceQuery.glGetProgramResourceiv((int)program, (int)bufferInterface, (int)blockIndex, (IntBuffer)stack.ints(37635), null, (IntBuffer)values);
                int size = values.get(0);
                ArrayList<Field> layoutFields = new ArrayList<Field>();
                for (Map.Entry<String, VeilShaderBufferLayout.FieldSerializer<T>> entry : layout.fields().entrySet()) {
                    String fieldName = name + "." + entry.getKey();
                    int index = ARBProgramInterfaceQuery.glGetProgramResourceIndex((int)program, (int)fieldInterface, (CharSequence)fieldName);
                    if (index == -1) {
                        Veil.LOGGER.warn("Failed to find buffer field '{}' in shader: {}", (Object)fieldName, (Object)shader.getName());
                        continue;
                    }
                    ARBProgramInterfaceQuery.glGetProgramResourceiv((int)program, (int)fieldInterface, (int)index, (IntBuffer)fieldProperties, null, (IntBuffer)values);
                    layoutFields.add(new Field<T>(values.get(0), entry.getValue()));
                }
                layoutFields.sort(Comparator.comparingInt(Field::offset));
                LayoutSerializer<T> serializer = new LayoutSerializer<T>((Field[])layoutFields.toArray(Field[]::new));
                LayoutShaderBlockImpl layoutShaderBlockImpl = new LayoutShaderBlockImpl(binding, size, serializer);
                return layoutShaderBlockImpl;
            }
        }
        ArrayList<Field> layoutFields = new ArrayList<Field>();
        for (Map.Entry<String, VeilShaderBufferLayout.FieldSerializer<T>> entry : layout.fields().entrySet()) {
            String fieldName = name + "." + entry.getKey();
            int index = GL31C.glGetUniformIndices((int)program, (CharSequence)fieldName);
            if (index == -1) {
                Veil.LOGGER.warn("Failed to find buffer field '{}' in shader: {}", (Object)fieldName, (Object)shader.getName());
                continue;
            }
            int offset = GL31C.glGetActiveUniformsi((int)program, (int)index, (int)35387);
            if (offset == -1) {
                Veil.LOGGER.warn("Buffer field '{}' in shader '{}' it not in a uniform block", (Object)fieldName, (Object)shader.getName());
                continue;
            }
            layoutFields.add(new Field<T>(offset, entry.getValue()));
        }
        int size = GL31C.glGetActiveUniformBlocki((int)program, (int)blockIndex, (int)35392);
        layoutFields.sort(Comparator.comparingInt(Field::offset));
        LayoutSerializer<T> serializer = new LayoutSerializer<T>((Field[])layoutFields.toArray(Field[]::new));
        return new LayoutShaderBlockImpl(binding, size, serializer);
    }

    @Override
    public void accept(T value, ByteBuffer buffer) {
        for (Field<T> field : this.fields) {
            field.serializer.write(value, field.offset, buffer);
        }
    }

    private record Field<T>(int offset, VeilShaderBufferLayout.FieldSerializer<T> serializer) {
    }
}

