/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.necromancer.render;

import com.mojang.blaze3d.platform.GlStateManager;
import foundry.veil.api.client.necromancer.Skeleton;
import foundry.veil.api.client.necromancer.render.NecromancerRenderer;
import foundry.veil.api.client.necromancer.render.Skin;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.profiler.RenderProfilerCounter;
import foundry.veil.api.client.render.profiler.VeilRenderProfiler;
import foundry.veil.api.client.render.rendertype.VeilRenderType;
import foundry.veil.api.client.render.shader.block.DynamicShaderBlock;
import foundry.veil.api.client.render.shader.block.ShaderBlock;
import foundry.veil.api.client.render.vertex.VertexArray;
import it.unimi.dsi.fastutil.floats.FloatArrayList;
import it.unimi.dsi.fastutil.floats.FloatList;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import net.minecraft.class_1921;
import net.minecraft.class_287;
import net.minecraft.class_310;
import net.minecraft.class_4588;
import net.minecraft.class_4668;
import net.minecraft.class_9799;
import net.minecraft.class_9801;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Matrix4x3f;
import org.lwjgl.opengl.ARBDirectStateAccess;
import org.lwjgl.opengl.GL15C;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

@ApiStatus.Internal
public class NecromancerRenderDispatcher {
    private static final Batched BATCHED = new Batched();
    private static final Immediate IMMEDIATE = new Immediate();
    private static final int BASE_INSTANCES = 100;
    private static DynamicShaderBlock<?> boneBlock;
    private static int boneBuffer;
    private static int instancedBuffer;
    private static class_9799 boneBuilder;
    private static boolean drawing;

    public static void begin() {
        drawing = true;
        BATCHED.begin();
    }

    public static void end() {
        BATCHED.end();
        drawing = false;
    }

    public static void delete() {
        try (MemoryStack stack = MemoryStack.stackPush();){
            GL15C.glDeleteBuffers((IntBuffer)stack.ints(boneBuffer, instancedBuffer));
        }
        boneBlock = null;
        boneBuffer = 0;
        instancedBuffer = 0;
        if (boneBuilder != null) {
            boneBuilder.close();
            boneBuilder = null;
        }
    }

    public static NecromancerRenderer getRenderer() {
        return drawing ? BATCHED : IMMEDIATE;
    }

    private static void updateBlockSize(int skeletonCount, int dataSize) {
        if (boneBlock == null) {
            boneBuffer = GlStateManager._glGenBuffers();
            boneBlock = ShaderBlock.wrapper(ShaderBlock.BufferBinding.UNIFORM, boneBuffer);
        }
        if (boneBlock.getSize() < 112 * skeletonCount * dataSize) {
            int newSize = (int)((double)skeletonCount * 1.5 * (double)dataSize);
            boneBlock.setSize(112 * newSize);
            VeilRenderSystem.renderer().getShaderDefinitions().set("NECROMANCER_BONE_BUFFER_SIZE", Long.toString(newSize));
            if (VeilRenderSystem.directStateAccessSupported()) {
                ARBDirectStateAccess.glNamedBufferData((int)boneBuffer, (long)boneBlock.getSize(), (int)35048);
            } else {
                GL15C.glBindBuffer((int)35345, (int)boneBuffer);
                GL15C.glBufferData((int)35345, (long)boneBlock.getSize(), (int)35048);
                GL15C.glBindBuffer((int)35345, (int)0);
            }
        }
    }

    public static class Batched
    extends RendererImpl {
        private final List<class_9799> bufferBuilderList = new ObjectArrayList();
        private final Int2ObjectMap<SkeletonBatch> skeletonBatches = new Int2ObjectArrayMap();
        private final Map<class_1921, class_287> buffers = new Object2ObjectArrayMap();
        private int bufferIndex;

        @Override
        public void draw(class_1921 renderType, Skeleton skeleton, Skin skin, float partialTicks) {
            SkeletonBatch batch = (SkeletonBatch)this.skeletonBatches.computeIfAbsent(skin.hashCode() * 31 + renderType.hashCode(), unused -> new SkeletonBatch(renderType, skin));
            batch.add((Matrix4fc)this.transform, skeleton, this.overlay, this.light, this.r, this.g, this.b, this.a, partialTicks);
        }

        @NotNull
        public class_4588 getBuffer(@NotNull class_1921 renderType) {
            class_287 buffer = this.buffers.get(renderType);
            if (buffer != null) {
                return buffer;
            }
            if (this.bufferIndex >= this.bufferBuilderList.size()) {
                class_9799 builder = new class_9799(renderType.method_22722());
                this.bufferBuilderList.add(builder);
                buffer = new class_287(builder, renderType.method_23033(), renderType.method_23031());
            } else {
                buffer = new class_287(this.bufferBuilderList.get(this.bufferIndex), renderType.method_23033(), renderType.method_23031());
            }
            ++this.bufferIndex;
            this.buffers.put(renderType, buffer);
            return buffer;
        }

        public void begin() {
            this.bufferIndex = 0;
            this.reset();
        }

        public void end() {
            VeilRenderProfiler profiler = VeilRenderProfiler.get();
            for (SkeletonBatch skeletonBatch : this.skeletonBatches.values()) {
                profiler.push("necromancer_draw_batched_" + VeilRenderType.getName((class_4668)skeletonBatch.renderType), new RenderProfilerCounter[0]);
                skeletonBatch.render();
                profiler.pop();
            }
            this.skeletonBatches.clear();
            for (Map.Entry entry : this.buffers.entrySet()) {
                class_9801 data = ((class_287)entry.getValue()).method_60794();
                try {
                    if (data == null) continue;
                    ((class_1921)entry.getKey()).method_60895(data);
                }
                finally {
                    if (data == null) continue;
                    data.close();
                }
            }
            this.buffers.clear();
            ListIterator<class_9799> iterator = this.bufferBuilderList.listIterator(this.bufferIndex);
            while (iterator.hasNext()) {
                iterator.next().close();
                iterator.remove();
            }
        }
    }

    public static class Immediate
    extends RendererImpl {
        private final Matrix4x3f affineTransform = new Matrix4x3f();

        private Immediate() {
        }

        @Override
        public void draw(class_1921 renderType, Skeleton skeleton, Skin skin, float partialTicks) {
            VeilRenderProfiler profiler = VeilRenderProfiler.get();
            profiler.push("necromancer_draw_immediate_" + VeilRenderType.getName((class_4668)renderType), new RenderProfilerCounter[0]);
            try (MemoryStack stack = MemoryStack.stackPush();){
                ByteBuffer instancedData = stack.malloc(8);
                instancedData.put(0, (byte)this.overlay);
                instancedData.put(1, (byte)this.light);
                instancedData.put(2, (byte)this.r);
                instancedData.put(3, (byte)this.g);
                instancedData.put(4, (byte)this.b);
                instancedData.put(5, (byte)this.a);
                instancedData.put(6, (byte)0);
                instancedData.put(7, (byte)0);
                this.affineTransform.set((Matrix4fc)this.transform);
                if (instancedBuffer == 0) {
                    instancedBuffer = GlStateManager._glGenBuffers();
                }
                if (boneBuilder == null) {
                    boneBuilder = new class_9799(11200);
                }
                VertexArray.upload(instancedBuffer, instancedData, VertexArray.DrawUsage.DYNAMIC);
                NecromancerRenderDispatcher.updateBlockSize(1, skin.getSkeletonDataSize());
                skin.render(renderType, List.of(this.affineTransform), List.of(skeleton), instancedBuffer, boneBuilder, boneBuffer, boneBlock, FloatList.of((float)partialTicks));
            }
            profiler.pop();
        }

        @NotNull
        public class_4588 getBuffer(@NotNull class_1921 renderType) {
            return class_310.method_1551().method_22940().method_23000().getBuffer(renderType);
        }
    }

    private static class SkeletonBatch {
        private final class_1921 renderType;
        private final Skin skin;
        private final List<Matrix4x3f> transforms;
        private final List<Skeleton> skeletons;
        private final FloatList partialTicks;
        private ByteBuffer instancedData;

        private SkeletonBatch(class_1921 renderType, Skin skin) {
            this.renderType = renderType;
            this.skin = skin;
            this.transforms = new ObjectArrayList();
            this.skeletons = new ObjectArrayList();
            this.partialTicks = new FloatArrayList();
            this.instancedData = MemoryUtil.memAlloc((int)800);
        }

        public void add(Matrix4fc transform, Skeleton skeleton, int overlay, int light, int r, int g, int b, int a, float partialTicks) {
            if (this.instancedData.capacity() - this.instancedData.position() < 8) {
                this.instancedData = MemoryUtil.memRealloc((ByteBuffer)this.instancedData, (int)((int)((double)this.instancedData.capacity() * 1.5)));
            }
            this.instancedData.put((byte)overlay);
            this.instancedData.put((byte)light);
            this.instancedData.put((byte)r);
            this.instancedData.put((byte)g);
            this.instancedData.put((byte)b);
            this.instancedData.put((byte)a);
            this.instancedData.put((byte)0);
            this.instancedData.put((byte)0);
            this.transforms.add(new Matrix4x3f().set(transform));
            this.skeletons.add(skeleton);
            this.partialTicks.add(partialTicks);
        }

        public void render() {
            try {
                if (instancedBuffer == 0) {
                    instancedBuffer = GlStateManager._glGenBuffers();
                }
                if (boneBuilder == null) {
                    boneBuilder = new class_9799(11200);
                }
                this.instancedData.flip();
                VertexArray.upload(instancedBuffer, this.instancedData, VertexArray.DrawUsage.DYNAMIC);
                NecromancerRenderDispatcher.updateBlockSize(this.skeletons.size(), this.skin.getSkeletonDataSize());
                this.skin.render(this.renderType, this.transforms, this.skeletons, instancedBuffer, boneBuilder, boneBuffer, boneBlock, this.partialTicks);
            }
            finally {
                MemoryUtil.memFree((Buffer)this.instancedData);
            }
        }
    }

    private static abstract class RendererImpl
    implements NecromancerRenderer {
        protected int overlay;
        protected int light;
        protected int r;
        protected int g;
        protected int b;
        protected int a;
        protected final Matrix4f transform = new Matrix4f();

        private RendererImpl() {
        }

        @Override
        public void setUv1(int u, int v) {
            this.overlay = (v & 0xF) << 4 | u & 0xF;
        }

        @Override
        public void setUv2(int u, int v) {
            this.light = (v & 0xF) << 4 | u & 0xF;
        }

        @Override
        public void setColor(float r, float g, float b, float a) {
            this.r = (int)((double)r * 255.0) & 0xFF;
            this.g = (int)((double)g * 255.0) & 0xFF;
            this.b = (int)((double)b * 255.0) & 0xFF;
            this.a = (int)((double)a * 255.0) & 0xFF;
        }

        @Override
        public void setColor(int color) {
            this.r = color >> 16 & 0xFF;
            this.g = color >> 8 & 0xFF;
            this.b = color & 0xFF;
            this.a = color >> 24 & 0xFF;
        }

        @Override
        public void reset() {
            this.overlay = 160;
            this.light = 255;
            this.r = 255;
            this.g = 255;
            this.b = 255;
            this.a = 255;
            this.transform.identity();
        }

        @Override
        public void setTransform(Matrix4fc transform) {
            this.transform.set(transform);
        }
    }
}

