/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.ext;

import foundry.veil.Veil;
import java.io.InputStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_2960;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_7367;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public interface PackResourcesExtension {
    public static final String BUILD_RESOURCES_NAME = "resources";

    public void veil$listResources(PackResourceConsumer var1);

    @Nullable
    public class_7367<InputStream> veil$getIcon();

    public boolean veil$blurIcon();

    public boolean veil$isStatic();

    public List<Path> veil$getRawResourceRoots();

    default public Stream<class_3262> veil$listPacks() {
        return Stream.of((class_3262)this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static Path findDevPath(Path root, Path file) {
        if (file.getFileSystem() != FileSystems.getDefault()) {
            return null;
        }
        if (file.getNameCount() <= 3) return null;
        try {
            Path buildRoot = root;
            String sourceRoot = null;
            Path localPath = null;
            while (buildRoot != null && buildRoot.getFileName() != null && !"build".equals(buildRoot.getFileName().toString())) {
                Path parent = buildRoot.getParent();
                if (parent != null && parent.getFileName() != null && parent.getFileName().toString().equals(BUILD_RESOURCES_NAME)) {
                    sourceRoot = buildRoot.getFileName().toString();
                    localPath = buildRoot.relativize(file);
                }
                buildRoot = parent;
            }
            if (buildRoot == null) return null;
            if (sourceRoot == null) {
                return null;
            }
            Path defaultRoot = buildRoot.getParent();
            if (defaultRoot == null) {
                return null;
            }
            Path buildPath = defaultRoot.resolve("src").resolve(sourceRoot).resolve(BUILD_RESOURCES_NAME).resolve(localPath);
            if (Files.exists(buildPath, new LinkOption[0])) {
                return buildPath;
            }
            Path projectRoot = defaultRoot.getParent();
            if (projectRoot == null) {
                return null;
            }
            try (Stream<Path> walk = Files.list(projectRoot).filter(path -> Files.isDirectory(path, new LinkOption[0]) && !path.startsWith(defaultRoot));){
                Path possibleRoot;
                Path resourcesPath;
                Iterator<Path> iterator = walk.toList().iterator();
                do {
                    if (!iterator.hasNext()) return null;
                } while (!Files.exists(resourcesPath = (possibleRoot = iterator.next()).resolve("src").resolve(sourceRoot).resolve(BUILD_RESOURCES_NAME).resolve(localPath), new LinkOption[0]));
                Path path2 = resourcesPath;
                return path2;
            }
        }
        catch (Exception e) {
            Veil.LOGGER.error("Failed to find IDE source root", (Throwable)e);
        }
        return null;
    }

    public static List<Path> findDevPaths(Path root, Path file) {
        ArrayList<Path> paths = new ArrayList<Path>();
        if (file.getFileSystem() != FileSystems.getDefault()) {
            return paths;
        }
        if (file.getNameCount() > 3) {
            try {
                Path projectRoot;
                Path buildRoot = root;
                String sourceRoot = null;
                Path localPath = null;
                while (buildRoot != null && buildRoot.getFileName() != null && !"build".equals(buildRoot.getFileName().toString())) {
                    Path parent = buildRoot.getParent();
                    if (parent != null && parent.getFileName() != null && parent.getFileName().toString().equals(BUILD_RESOURCES_NAME)) {
                        sourceRoot = buildRoot.getFileName().toString();
                        localPath = buildRoot.relativize(file);
                    }
                    buildRoot = parent;
                }
                if (buildRoot == null || sourceRoot == null) {
                    return paths;
                }
                Path defaultRoot = buildRoot.getParent();
                if (defaultRoot == null) {
                    return paths;
                }
                Path buildPath = defaultRoot.resolve("src").resolve(sourceRoot).resolve(BUILD_RESOURCES_NAME).resolve(localPath);
                if (Files.exists(buildPath, new LinkOption[0])) {
                    paths.add(buildPath);
                }
                if ((projectRoot = defaultRoot.getParent()) == null) {
                    return paths;
                }
                try (Stream<Path> walk = Files.list(projectRoot).filter(path -> Files.isDirectory(path, new LinkOption[0]) && !path.startsWith(defaultRoot));){
                    for (Path possibleRoot : walk.toList()) {
                        Path resourcesPath = possibleRoot.resolve("src").resolve(sourceRoot).resolve(BUILD_RESOURCES_NAME).resolve(localPath);
                        if (!Files.exists(resourcesPath, new LinkOption[0])) continue;
                        paths.add(resourcesPath);
                    }
                }
            }
            catch (Exception e) {
                Veil.LOGGER.error("Failed to find IDE source root", (Throwable)e);
            }
        }
        return paths;
    }

    @FunctionalInterface
    public static interface PackResourceConsumer {
        public void accept(@Nullable class_3264 var1, class_2960 var2, Path var3, Path var4, @Nullable Path var5);
    }
}

