/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.util;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5699;
import org.joml.Vector2f;
import org.joml.Vector2fc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;

public class CodecUtil {
    public static final Codec<Vector2fc> VECTOR2F_CODEC = Codec.FLOAT.listOf().flatXmap(list -> CodecUtil.check(3, list), list -> CodecUtil.check(2, list)).xmap(list -> new Vector2f(((Float)list.get(0)).floatValue(), ((Float)list.get(1)).floatValue()), vector -> List.of(Float.valueOf(vector.x()), Float.valueOf(vector.y())));
    public static final Codec<Vector3fc> VECTOR3F_CODEC = Codec.FLOAT.listOf().flatXmap(list -> CodecUtil.check(3, list), list -> CodecUtil.check(3, list)).xmap(list -> new Vector3f(((Float)list.get(0)).floatValue(), ((Float)list.get(1)).floatValue(), ((Float)list.get(2)).floatValue()), vector -> List.of(Float.valueOf(vector.x()), Float.valueOf(vector.y()), Float.valueOf(vector.z())));
    public static final Codec<Vector4fc> VECTOR4F_CODEC = Codec.FLOAT.listOf().flatXmap(list -> CodecUtil.check(4, list), list -> CodecUtil.check(4, list)).xmap(list -> new Vector4f(((Float)list.get(0)).floatValue(), ((Float)list.get(1)).floatValue(), ((Float)list.get(2)).floatValue(), ((Float)list.get(3)).floatValue()), vector -> List.of(Float.valueOf(vector.x()), Float.valueOf(vector.y()), Float.valueOf(vector.z()), Float.valueOf(vector.w())));
    public static final Codec<Vector3dc> VECTOR3D_CODEC = Codec.DOUBLE.listOf().flatXmap(list -> CodecUtil.check(3, list), list -> CodecUtil.check(3, list)).xmap(list -> new Vector3d(((Double)list.get(0)).doubleValue(), ((Double)list.get(1)).doubleValue(), ((Double)list.get(2)).doubleValue()), vector -> List.of(Double.valueOf(vector.x()), Double.valueOf(vector.y()), Double.valueOf(vector.z())));

    private static <T> DataResult<List<T>> check(int size, List<T> list) {
        if (list.size() != size) {
            return DataResult.error(() -> "Vector" + size + "f must have " + size + " elements!");
        }
        return DataResult.success(list);
    }

    public static <T> Codec<List<T>> singleOrList(Codec<T> codec) {
        return Codec.either((Codec)codec.flatComapMap(List::of, l -> l.size() == 1 ? DataResult.success(l.get(0)) : DataResult.error(() -> "List must have exactly one element.")), (Codec)class_5699.method_36973((Codec)codec.listOf())).xmap(e -> (List)e.map(Function.identity(), Function.identity()), l -> l.size() == 1 ? Either.left((Object)l) : Either.right((Object)l));
    }

    public static <T> Codec<T> registryOrLegacyCodec(class_2378<T> registry) {
        Codec legacyCodec = Codec.STRING.comapFlatMap(name -> class_2960.method_29186((String)("veil:" + name.toLowerCase(Locale.ROOT))), class_2960::toString).flatXmap(loc -> Optional.ofNullable(registry.method_10223(loc)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown registry key in " + String.valueOf(registry.method_30517()) + ": " + String.valueOf(loc))), object -> registry.method_29113(object).map(class_5321::method_29177).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown registry element in " + String.valueOf(registry.method_30517()) + ":" + String.valueOf(object))));
        return Codec.either((Codec)registry.method_39673(), (Codec)legacyCodec).xmap(e -> e.map(Function.identity(), Function.identity()), Either::left);
    }
}

