/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.util;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import net.minecraft.class_2374;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public final class CatmulRomSpline {
    private final Iter iter = new Iter();

    public Iterable<Vector3dc> generateJomlSpline(Collection<? extends Vector3dc> controlPoints, int numSegments) {
        if (controlPoints.size() < 4) {
            return Collections.emptyList();
        }
        this.iter.setJoml(controlPoints.iterator(), numSegments);
        return () -> this.iter;
    }

    public Iterable<Vector3dc> generateSpline(Collection<? extends class_2374> controlPoints, int numSegments) {
        if (controlPoints.size() < 4) {
            return Collections.emptyList();
        }
        this.iter.set(controlPoints.iterator(), numSegments);
        return () -> this.iter;
    }

    private static class Iter
    implements Iterator<Vector3dc> {
        private final Vector3d value = new Vector3d();
        private Iterator points = null;
        private Object point0;
        private Object point1;
        private Object point2;
        private Object point3;
        private boolean joml = false;
        private int segments;
        private int currentSegment;

        private Iter() {
        }

        public void setJoml(Iterator points, int segments) {
            this.points = points;
            this.point0 = points.next();
            this.point1 = points.next();
            this.point2 = points.next();
            this.point3 = points.next();
            this.joml = true;
            this.segments = segments;
            this.currentSegment = 0;
        }

        public void set(Iterator points, int segments) {
            this.points = points;
            this.point0 = points.next();
            this.point1 = points.next();
            this.point2 = points.next();
            this.point3 = points.next();
            this.joml = false;
            this.segments = segments;
            this.currentSegment = 0;
        }

        @Override
        public boolean hasNext() {
            return this.currentSegment < this.segments && this.points.hasNext();
        }

        @Override
        public Vector3dc next() {
            if (this.currentSegment >= this.segments) {
                this.currentSegment = 0;
                this.point0 = this.point1;
                this.point1 = this.point2;
                this.point2 = this.point3;
                this.point3 = this.points.next();
            }
            double t = (double)this.currentSegment / (double)this.segments;
            double t2 = t * t;
            double t3 = t2 * t;
            double a = -0.5 * t3 + t2 - 0.5 * t;
            double b = 1.5 * t3 - 2.5 * t2 + 1.0;
            double c = -1.5 * t3 + 2.0 * t2 + 0.5 * t;
            double d = 0.5 * t3 - 0.5 * t2;
            if (this.joml) {
                Vector3dc p0 = (Vector3dc)this.point0;
                Vector3dc p1 = (Vector3dc)this.point1;
                Vector3dc p2 = (Vector3dc)this.point2;
                Vector3dc p3 = (Vector3dc)this.point3;
                this.value.set(p0.x() * a + p1.x() * b + p2.x() * c + p3.x() * d, p0.y() * a + p1.y() * b + p2.y() * c + p3.y() * d, p0.z() * a + p1.z() * b + p2.z() * c + p3.z() * d);
            } else {
                class_2374 p0 = (class_2374)this.point0;
                class_2374 p1 = (class_2374)this.point1;
                class_2374 p2 = (class_2374)this.point2;
                class_2374 p3 = (class_2374)this.point3;
                this.value.set(p0.method_10216() * a + p1.method_10216() * b + p2.method_10216() * c + p3.method_10216() * d, p0.method_10214() * a + p1.method_10214() * b + p2.method_10214() * c + p3.method_10214() * d, p0.method_10215() * a + p1.method_10215() * b + p2.method_10215() * c + p3.method_10215() * d);
            }
            ++this.currentSegment;
            return this.value;
        }
    }
}

