/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.resource.type;

import foundry.veil.api.client.render.shader.ShaderManager;
import foundry.veil.api.client.render.shader.ShaderSourceSet;
import foundry.veil.api.client.render.shader.program.ProgramDefinition;
import foundry.veil.api.client.render.shader.program.ShaderProgram;
import foundry.veil.api.resource.VeilResourceAction;
import foundry.veil.api.resource.VeilResourceInfo;
import foundry.veil.api.resource.VeilResourceManager;
import foundry.veil.api.resource.type.VeilShaderResource;
import foundry.veil.impl.resource.action.TextEditAction;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2960;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public record VeilShaderFileResource(VeilResourceInfo resourceInfo, ShaderManager shaderManager) implements VeilShaderResource<VeilShaderFileResource>
{
    @Override
    public List<VeilResourceAction<VeilShaderFileResource>> getActions() {
        return List.of(new TextEditAction());
    }

    @Override
    public boolean canHotReload() {
        return true;
    }

    @Override
    public void hotReload(VeilResourceManager resourceManager) {
        int type = ShaderSourceSet.getShaderType(this.resourceInfo().location());
        if (type == -1) {
            return;
        }
        ShaderSourceSet sourceSet = this.shaderManager.getSourceSet();
        class_2960 id = sourceSet.getTypeConverter(type).method_45115(this.resourceInfo.location());
        HashSet<class_2960> programs = new HashSet<class_2960>();
        block0: for (Map.Entry<class_2960, ShaderProgram> entry : this.shaderManager.getShaders().entrySet()) {
            ProgramDefinition definition = entry.getValue().getDefinition();
            if (definition == null) continue;
            for (Int2ObjectMap.Entry shaderEntry : definition.shaders().int2ObjectEntrySet()) {
                class_2960 sourceName = (class_2960)shaderEntry.getValue();
                if (sourceName == null || !id.equals((Object)sourceName)) continue;
                programs.add(entry.getKey());
                continue block0;
            }
        }
        for (class_2960 program : programs) {
            this.shaderManager.scheduleRecompile(program);
        }
    }
}

