/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.resource;

import foundry.veil.api.resource.VeilResourceManager;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.Optional;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3298;
import org.jetbrains.annotations.Nullable;

public record VeilResourceInfo(class_3264 packType, class_2960 location, Path filePath, @Nullable Path modResourcePath, boolean hidden) {
    public Optional<class_3298> getResource(VeilResourceManager resourceManager) {
        return resourceManager.resources(this).method_14486(this.location);
    }

    public class_3298 getResourceOrThrow(VeilResourceManager resourceManager) throws FileNotFoundException {
        return this.getResource(resourceManager).orElseThrow(() -> new FileNotFoundException(this.location.toString()));
    }

    public InputStream open(VeilResourceManager resourceManager) throws IOException {
        return this.getResourceOrThrow(resourceManager).method_14482();
    }

    public BufferedReader openAsReader(VeilResourceManager resourceManager) throws IOException {
        return this.getResourceOrThrow(resourceManager).method_43039();
    }

    public String fileName() {
        String path = this.location().method_12832();
        String[] split = path.split("/");
        return split[split.length - 1];
    }

    public boolean isStatic() {
        Path filePath = this.modResourcePath != null ? this.modResourcePath : this.filePath;
        return filePath == null || filePath.getFileSystem() != FileSystems.getDefault();
    }
}

