/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.quasar.particle;

import foundry.veil.api.quasar.emitters.module.CollisionParticleModule;
import foundry.veil.api.quasar.emitters.module.ForceParticleModule;
import foundry.veil.api.quasar.emitters.module.InitParticleModule;
import foundry.veil.api.quasar.emitters.module.ParticleModule;
import foundry.veil.api.quasar.emitters.module.RenderParticleModule;
import foundry.veil.api.quasar.emitters.module.UpdateParticleModule;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public final class ParticleModuleSet {
    private final ParticleModule[] modules;
    private final InitParticleModule[] initModules;
    private final UpdateParticleModule[] updateModules;
    private final ForceParticleModule[] forceModules;
    private final CollisionParticleModule[] collisionModules;
    private final RenderParticleModule[] renderModules;
    private final RenderParticleModule[] enabledRenderModules;
    private int enabledRenderModulesSize;

    private ParticleModuleSet(ParticleModule[] modules, InitParticleModule[] initModules, UpdateParticleModule[] updateModules, ForceParticleModule[] forceModules, CollisionParticleModule[] collisionModules, RenderParticleModule[] renderModules) {
        this.modules = modules;
        this.initModules = initModules;
        this.updateModules = updateModules;
        this.forceModules = forceModules;
        this.collisionModules = collisionModules;
        this.renderModules = renderModules;
        this.enabledRenderModules = new RenderParticleModule[this.renderModules.length];
        this.enabledRenderModulesSize = 0;
    }

    public ParticleModuleSet copy() {
        return new ParticleModuleSet(this.modules, this.initModules, this.updateModules, this.forceModules, this.collisionModules, this.renderModules);
    }

    public void updateEnabled() {
        this.enabledRenderModulesSize = 0;
        for (RenderParticleModule renderModule : this.renderModules) {
            if (!renderModule.isEnabled()) continue;
            this.enabledRenderModules[this.enabledRenderModulesSize++] = renderModule;
        }
    }

    public ParticleModule[] getAllModules() {
        return this.modules;
    }

    public InitParticleModule[] getInitModules() {
        return this.initModules;
    }

    public UpdateParticleModule[] getUpdateModules() {
        return this.updateModules;
    }

    public ForceParticleModule[] getForceModules() {
        return this.forceModules;
    }

    public CollisionParticleModule[] getCollisionModules() {
        return this.collisionModules;
    }

    public RenderParticleModule[] getRenderModules() {
        return this.renderModules;
    }

    public Iterator<RenderParticleModule> getEnabledRenderModules() {
        return new Iterator<RenderParticleModule>(){
            private int cursor;

            @Override
            public boolean hasNext() {
                return this.cursor < ParticleModuleSet.this.enabledRenderModulesSize;
            }

            @Override
            public RenderParticleModule next() {
                return ParticleModuleSet.this.enabledRenderModules[this.cursor++];
            }
        };
    }

    public int getEnabledRenderModuleCount() {
        return this.enabledRenderModulesSize;
    }

    public RenderParticleModule[] getEnabledRenderModulesArray() {
        return this.enabledRenderModules;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final Set<ParticleModule> modules = new HashSet<ParticleModule>();
        private final Set<InitParticleModule> initModules = new HashSet<InitParticleModule>();
        private final Set<UpdateParticleModule> updateModules = new HashSet<UpdateParticleModule>();
        private final Set<ForceParticleModule> forceModules = new HashSet<ForceParticleModule>();
        private final Set<CollisionParticleModule> collisionModules = new HashSet<CollisionParticleModule>();
        private final Set<RenderParticleModule> renderModules = new HashSet<RenderParticleModule>();

        public void addModule(ParticleModule module) {
            if (!this.modules.add(module)) {
                throw new IllegalArgumentException("Duplicate module: " + String.valueOf(module.getClass()));
            }
            if (module instanceof InitParticleModule) {
                InitParticleModule initModule = (InitParticleModule)module;
                this.initModules.add(initModule);
            }
            if (module instanceof UpdateParticleModule) {
                UpdateParticleModule updateModule = (UpdateParticleModule)module;
                this.updateModules.add(updateModule);
            }
            if (module instanceof ForceParticleModule) {
                ForceParticleModule forceModule = (ForceParticleModule)module;
                this.forceModules.add(forceModule);
            }
            if (module instanceof CollisionParticleModule) {
                CollisionParticleModule collisionModule = (CollisionParticleModule)module;
                this.collisionModules.add(collisionModule);
            }
            if (module instanceof RenderParticleModule) {
                RenderParticleModule renderModule = (RenderParticleModule)module;
                this.renderModules.add(renderModule);
            }
        }

        public ParticleModuleSet build() {
            ParticleModule[] modules = (ParticleModule[])this.modules.toArray(ParticleModule[]::new);
            InitParticleModule[] initModules = (InitParticleModule[])this.initModules.toArray(InitParticleModule[]::new);
            UpdateParticleModule[] updateModules = (UpdateParticleModule[])this.updateModules.toArray(UpdateParticleModule[]::new);
            ForceParticleModule[] forceModules = (ForceParticleModule[])this.forceModules.toArray(ForceParticleModule[]::new);
            CollisionParticleModule[] collisionModules = (CollisionParticleModule[])this.collisionModules.toArray(CollisionParticleModule[]::new);
            RenderParticleModule[] renderModules = (RenderParticleModule[])this.renderModules.toArray(RenderParticleModule[]::new);
            return new ParticleModuleSet(modules, initModules, updateModules, forceModules, collisionModules, renderModules);
        }
    }
}

