/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.util;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayDeque;
import java.util.Deque;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_8030;
import org.jetbrains.annotations.Nullable;

public final class ScissorStack {
    private final Deque<class_8030> regions = new ArrayDeque<class_8030>();

    private void apply(class_8030 rectangle) {
        RenderSystem.enableScissor((int)rectangle.method_49620(), (int)(class_310.method_1551().method_22683().method_4506() - rectangle.method_49619()), (int)rectangle.comp_1196(), (int)rectangle.comp_1197());
    }

    public void push(int x, int y, int width, int height) {
        this.push((float)x, (float)y, (float)width, (float)height);
    }

    public void push(float x, float y, float width, float height) {
        if (!this.regions.isEmpty()) {
            float scale = (float)class_310.method_1551().method_22683().method_4495();
            float x2 = x + width;
            float y2 = y + height;
            class_8030 parent = this.regions.peek();
            x = class_3532.method_15363((float)(x * scale), (float)parent.method_49620(), (float)parent.method_49621());
            width = class_3532.method_15363((float)(x2 * scale), (float)parent.method_49620(), (float)parent.method_49621()) - x;
            y = class_3532.method_15363((float)(y * scale), (float)parent.method_49618(), (float)parent.method_49619());
            height = class_3532.method_15363((float)(y2 * scale), (float)parent.method_49618(), (float)parent.method_49619()) - y;
        }
        class_8030 region = new class_8030((int)x, (int)y, (int)width, (int)height);
        this.regions.push(region);
        this.apply(region);
    }

    public void pop() {
        this.regions.pop();
        if (this.regions.isEmpty()) {
            RenderSystem.disableScissor();
        } else {
            this.apply(this.regions.peek());
        }
    }

    @Nullable
    public class_8030 getTop() {
        return this.regions.isEmpty() ? null : this.regions.peek();
    }

    public boolean containsPoint(float x, float y) {
        if (this.regions.isEmpty()) {
            return true;
        }
        float scale = (float)class_310.method_1551().method_22683().method_4495();
        return this.regions.peek().method_58137((int)(x * scale), (int)(y * scale));
    }

    public int size() {
        return this.regions.size();
    }

    public boolean isEmpty() {
        return this.regions.isEmpty();
    }

    public void clear() {
        this.regions.clear();
        RenderSystem.disableScissor();
    }
}

