/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.shader.uniform;

import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.shader.program.ShaderUniformCache;
import foundry.veil.api.client.render.shader.uniform.ShaderUniformAccess;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import net.minecraft.class_5944;
import org.joml.Matrix2f;
import org.joml.Matrix3f;
import org.joml.Matrix3x2f;
import org.joml.Matrix4f;
import org.joml.Matrix4x3f;
import org.joml.Vector2f;
import org.joml.Vector2i;
import org.joml.Vector3f;
import org.joml.Vector3i;
import org.joml.Vector4f;
import org.joml.Vector4i;
import org.lwjgl.opengl.ARBGPUShaderFP64;
import org.lwjgl.opengl.ARBGPUShaderInt64;
import org.lwjgl.opengl.ARBSeparateShaderObjects;
import org.lwjgl.opengl.GL30C;

public interface ShaderUniform
extends ShaderUniformAccess {
    public void invalidateCache();

    @Override
    default public boolean isValid() {
        return this.getLocation() != -1;
    }

    public String getName();

    public int getLocation();

    public Type getType();

    public int getArrayLength();

    public float getFloat();

    default public float[] getFloats() {
        float[] values = new float[this.getArrayLength()];
        this.getFloats(values, 0, values.length);
        return values;
    }

    default public void getFloats(float[] fill) {
        this.getFloats(fill, 0, fill.length);
    }

    public void getFloats(float[] var1, int var2, int var3);

    public int getInt();

    default public int[] getInts() {
        int[] values = new int[this.getArrayLength()];
        this.getInts(values, 0, values.length);
        return values;
    }

    default public void getInts(int[] fill) {
        this.getInts(fill, 0, fill.length);
    }

    public void getInts(int[] var1, int var2, int var3);

    public double getDouble();

    default public double[] getDoubles() {
        double[] values = new double[this.getArrayLength()];
        this.getDoubles(values, 0, values.length);
        return values;
    }

    default public void getDoubles(double[] fill) {
        this.getDoubles(fill, 0, fill.length);
    }

    public void getDoubles(double[] var1, int var2, int var3);

    public long getLong();

    default public long[] getLongs() {
        long[] values = new long[this.getArrayLength()];
        this.getLongs(values, 0, values.length);
        return values;
    }

    default public void getLongs(long[] fill) {
        this.getLongs(fill, 0, fill.length);
    }

    public void getLongs(long[] var1, int var2, int var3);

    public void getVector(CharSequence var1, Vector2f ... var2);

    public void getVector(CharSequence var1, Vector3f ... var2);

    public void getVector(CharSequence var1, Vector4f ... var2);

    public void getVectori(CharSequence var1, Vector2i ... var2);

    public void getVectori(CharSequence var1, Vector3i ... var2);

    public void getVectori(CharSequence var1, Vector4i ... var2);

    public void getMatrix(CharSequence var1, Matrix2f var2);

    public void getMatrix(CharSequence var1, Matrix3f var2);

    public void getMatrix(CharSequence var1, Matrix4f var2);

    public void getMatrix(CharSequence var1, Matrix3x2f var2);

    public void getMatrix(CharSequence var1, Matrix4x3f var2);

    public static enum Type {
        SAMPLER(0){

            @Override
            public void upload(int program, int location, ByteBuffer buffer) {
                if (VeilRenderSystem.separateShaderObjectsSupported()) {
                    ARBSeparateShaderObjects.glProgramUniform1iv((int)program, (int)location, (IntBuffer)buffer.asIntBuffer());
                } else {
                    if (program != class_5944.field_29486) {
                        GL30C.glUseProgram((int)program);
                    }
                    GL30C.glUniform1iv((int)location, (IntBuffer)buffer.asIntBuffer());
                    if (program != class_5944.field_29486) {
                        GL30C.glUseProgram((int)class_5944.field_29486);
                    }
                }
            }
        }
        ,
        FLOAT(4){

            @Override
            public void upload(int program, int location, ByteBuffer buffer) {
                if (VeilRenderSystem.separateShaderObjectsSupported()) {
                    ARBSeparateShaderObjects.glProgramUniform1fv((int)program, (int)location, (FloatBuffer)buffer.asFloatBuffer());
                } else {
                    if (program != class_5944.field_29486) {
                        GL30C.glUseProgram((int)program);
                    }
                    GL30C.glUniform1fv((int)location, (FloatBuffer)buffer.asFloatBuffer());
                    if (program != class_5944.field_29486) {
                        GL30C.glUseProgram((int)class_5944.field_29486);
                    }
                }
            }
        }
        ,
        FLOAT_VEC2(8){

            @Override
            public void upload(int program, int location, ByteBuffer buffer) {
                if (VeilRenderSystem.separateShaderObjectsSupported()) {
                    ARBSeparateShaderObjects.glProgramUniform2fv((int)program, (int)location, (FloatBuffer)buffer.asFloatBuffer());
                } else {
                    if (program != class_5944.field_29486) {
                        GL30C.glUseProgram((int)program);
                    }
                    GL30C.glUniform2fv((int)location, (FloatBuffer)buffer.asFloatBuffer());
                    if (program != class_5944.field_29486) {
                        GL30C.glUseProgram((int)class_5944.field_29486);
                    }
                }
            }
        }
        ,
        FLOAT_VEC3(12){

            @Override
            public void upload(int program, int location, ByteBuffer buffer) {
                if (VeilRenderSystem.separateShaderObjectsSupported()) {
                    ARBSeparateShaderObjects.glProgramUniform3fv((int)program, (int)location, (FloatBuffer)buffer.asFloatBuffer());
                } else {
                    if (program != class_5944.field_29486) {
                        GL30C.glUseProgram((int)program);
                    }
                    GL30C.glUniform3fv((int)location, (FloatBuffer)buffer.asFloatBuffer());
                    if (program != class_5944.field_29486) {
                        GL30C.glUseProgram((int)class_5944.field_29486);
                    }
                }
            }
        }
        ,
        FLOAT_VEC4(16){

            @Override
            public void upload(int program, int location, ByteBuffer buffer) {
                if (VeilRenderSystem.separateShaderObjectsSupported()) {
                    ARBSeparateShaderObjects.glProgramUniform4fv((int)program, (int)location, (FloatBuffer)buffer.asFloatBuffer());
                } else {
                    if (program != class_5944.field_29486) {
                        GL30C.glUseProgram((int)program);
                    }
                    GL30C.glUniform4fv((int)location, (FloatBuffer)buffer.asFloatBuffer());
                    if (program != class_5944.field_29486) {
                        GL30C.glUseProgram((int)class_5944.field_29486);
                    }
                }
            }
        }
        ,
        INT(4){

            @Override
            public void upload(int program, int location, ByteBuffer buffer) {
                if (VeilRenderSystem.separateShaderObjectsSupported()) {
                    ARBSeparateShaderObjects.glProgramUniform1iv((int)program, (int)location, (IntBuffer)buffer.asIntBuffer());
                } else {
                    if (program != class_5944.field_29486) {
                        GL30C.glUseProgram((int)program);
                    }
                    GL30C.glUniform1iv((int)location, (IntBuffer)buffer.asIntBuffer());
                    if (program != class_5944.field_29486) {
                        GL30C.glUseProgram((int)class_5944.field_29486);
                    }
                }
            }
        }
        ,
        INT_VEC2(8){

            @Override
            public void upload(int program, int location, ByteBuffer buffer) {
                if (VeilRenderSystem.separateShaderObjectsSupported()) {
                    ARBSeparateShaderObjects.glProgramUniform2iv((int)program, (int)location, (IntBuffer)buffer.asIntBuffer());
                } else {
                    if (program != class_5944.field_29486) {
                        GL30C.glUseProgram((int)program);
                    }
                    GL30C.glUniform2iv((int)location, (IntBuffer)buffer.asIntBuffer());
                    if (program != class_5944.field_29486) {
                        GL30C.glUseProgram((int)class_5944.field_29486);
                    }
                }
            }
        }
        ,
        INT_VEC3(12){

            @Override
            public void upload(int program, int location, ByteBuffer buffer) {
                if (VeilRenderSystem.separateShaderObjectsSupported()) {
                    ARBSeparateShaderObjects.glProgramUniform3iv((int)program, (int)location, (IntBuffer)buffer.asIntBuffer());
                } else {
                    if (program != class_5944.field_29486) {
                        GL30C.glUseProgram((int)program);
                    }
                    GL30C.glUniform3iv((int)location, (IntBuffer)buffer.asIntBuffer());
                    if (program != class_5944.field_29486) {
                        GL30C.glUseProgram((int)class_5944.field_29486);
                    }
                }
            }
        }
        ,
        INT_VEC4(16){

            @Override
            public void upload(int program, int location, ByteBuffer buffer) {
                if (VeilRenderSystem.separateShaderObjectsSupported()) {
                    ARBSeparateShaderObjects.glProgramUniform4iv((int)program, (int)location, (IntBuffer)buffer.asIntBuffer());
                } else {
                    if (program != class_5944.field_29486) {
                        GL30C.glUseProgram((int)program);
                    }
                    GL30C.glUniform4iv((int)location, (IntBuffer)buffer.asIntBuffer());
                    if (program != class_5944.field_29486) {
                        GL30C.glUseProgram((int)class_5944.field_29486);
                    }
                }
            }
        }
        ,
        UNSIGNED_INT(4){

            @Override
            public void upload(int program, int location, ByteBuffer buffer) {
                if (VeilRenderSystem.separateShaderObjectsSupported()) {
                    ARBSeparateShaderObjects.glProgramUniform1uiv((int)program, (int)location, (IntBuffer)buffer.asIntBuffer());
                } else {
                    if (program != class_5944.field_29486) {
                        GL30C.glUseProgram((int)program);
                    }
                    GL30C.glUniform1uiv((int)location, (IntBuffer)buffer.asIntBuffer());
                    if (program != class_5944.field_29486) {
                        GL30C.glUseProgram((int)class_5944.field_29486);
                    }
                }
            }
        }
        ,
        UNSIGNED_INT_VEC2(8){

            @Override
            public void upload(int program, int location, ByteBuffer buffer) {
                if (VeilRenderSystem.separateShaderObjectsSupported()) {
                    ARBSeparateShaderObjects.glProgramUniform2uiv((int)program, (int)location, (IntBuffer)buffer.asIntBuffer());
                } else {
                    if (program != class_5944.field_29486) {
                        GL30C.glUseProgram((int)program);
                    }
                    GL30C.glUniform2uiv((int)location, (IntBuffer)buffer.asIntBuffer());
                    if (program != class_5944.field_29486) {
                        GL30C.glUseProgram((int)class_5944.field_29486);
                    }
                }
            }
        }
        ,
        UNSIGNED_INT_VEC3(12){

            @Override
            public void upload(int program, int location, ByteBuffer buffer) {
                if (VeilRenderSystem.separateShaderObjectsSupported()) {
                    ARBSeparateShaderObjects.glProgramUniform3uiv((int)program, (int)location, (IntBuffer)buffer.asIntBuffer());
                } else {
                    if (program != class_5944.field_29486) {
                        GL30C.glUseProgram((int)program);
                    }
                    GL30C.glUniform3uiv((int)location, (IntBuffer)buffer.asIntBuffer());
                    if (program != class_5944.field_29486) {
                        GL30C.glUseProgram((int)class_5944.field_29486);
                    }
                }
            }
        }
        ,
        UNSIGNED_INT_VEC4(16){

            @Override
            public void upload(int program, int location, ByteBuffer buffer) {
                if (VeilRenderSystem.separateShaderObjectsSupported()) {
                    ARBSeparateShaderObjects.glProgramUniform4uiv((int)program, (int)location, (IntBuffer)buffer.asIntBuffer());
                } else {
                    if (program != class_5944.field_29486) {
                        GL30C.glUseProgram((int)program);
                    }
                    GL30C.glUniform4uiv((int)location, (IntBuffer)buffer.asIntBuffer());
                    if (program != class_5944.field_29486) {
                        GL30C.glUseProgram((int)class_5944.field_29486);
                    }
                }
            }
        }
        ,
        MATRIX2x2(16){

            @Override
            public void uploadAsMatrix(int program, int location, boolean transpose, ByteBuffer buffer) {
                if (VeilRenderSystem.separateShaderObjectsSupported()) {
                    ARBSeparateShaderObjects.glProgramUniformMatrix2fv((int)program, (int)location, (boolean)transpose, (FloatBuffer)buffer.asFloatBuffer());
                } else {
                    if (program != class_5944.field_29486) {
                        GL30C.glUseProgram((int)program);
                    }
                    GL30C.glUniformMatrix2fv((int)location, (boolean)transpose, (FloatBuffer)buffer.asFloatBuffer());
                    if (program != class_5944.field_29486) {
                        GL30C.glUseProgram((int)class_5944.field_29486);
                    }
                }
            }
        }
        ,
        MATRIX3x3(36){

            @Override
            public void uploadAsMatrix(int program, int location, boolean transpose, ByteBuffer buffer) {
                if (VeilRenderSystem.separateShaderObjectsSupported()) {
                    ARBSeparateShaderObjects.glProgramUniformMatrix3fv((int)program, (int)location, (boolean)transpose, (FloatBuffer)buffer.asFloatBuffer());
                } else {
                    if (program != class_5944.field_29486) {
                        GL30C.glUseProgram((int)program);
                    }
                    GL30C.glUniformMatrix3fv((int)location, (boolean)transpose, (FloatBuffer)buffer.asFloatBuffer());
                    if (program != class_5944.field_29486) {
                        GL30C.glUseProgram((int)class_5944.field_29486);
                    }
                }
            }
        }
        ,
        MATRIX4x4(64){

            @Override
            public void uploadAsMatrix(int program, int location, boolean transpose, ByteBuffer buffer) {
                if (VeilRenderSystem.separateShaderObjectsSupported()) {
                    ARBSeparateShaderObjects.glProgramUniformMatrix4fv((int)program, (int)location, (boolean)transpose, (FloatBuffer)buffer.asFloatBuffer());
                } else {
                    if (program != class_5944.field_29486) {
                        GL30C.glUseProgram((int)program);
                    }
                    GL30C.glUniformMatrix4fv((int)location, (boolean)transpose, (FloatBuffer)buffer.asFloatBuffer());
                    if (program != class_5944.field_29486) {
                        GL30C.glUseProgram((int)class_5944.field_29486);
                    }
                }
            }
        }
        ,
        MATRIX2x3(24){

            @Override
            public void uploadAsMatrix(int program, int location, boolean transpose, ByteBuffer buffer) {
                if (VeilRenderSystem.separateShaderObjectsSupported()) {
                    ARBSeparateShaderObjects.glProgramUniformMatrix2x3fv((int)program, (int)location, (boolean)transpose, (FloatBuffer)buffer.asFloatBuffer());
                } else {
                    if (program != class_5944.field_29486) {
                        GL30C.glUseProgram((int)program);
                    }
                    GL30C.glUniformMatrix2x3fv((int)location, (boolean)transpose, (FloatBuffer)buffer.asFloatBuffer());
                    if (program != class_5944.field_29486) {
                        GL30C.glUseProgram((int)class_5944.field_29486);
                    }
                }
            }
        }
        ,
        MATRIX3x2(24){

            @Override
            public void uploadAsMatrix(int program, int location, boolean transpose, ByteBuffer buffer) {
                if (VeilRenderSystem.separateShaderObjectsSupported()) {
                    ARBSeparateShaderObjects.glProgramUniformMatrix3x2fv((int)program, (int)location, (boolean)transpose, (FloatBuffer)buffer.asFloatBuffer());
                } else {
                    if (program != class_5944.field_29486) {
                        GL30C.glUseProgram((int)program);
                    }
                    GL30C.glUniformMatrix3x2fv((int)location, (boolean)transpose, (FloatBuffer)buffer.asFloatBuffer());
                    if (program != class_5944.field_29486) {
                        GL30C.glUseProgram((int)class_5944.field_29486);
                    }
                }
            }
        }
        ,
        MATRIX2x4(32){

            @Override
            public void uploadAsMatrix(int program, int location, boolean transpose, ByteBuffer buffer) {
                if (VeilRenderSystem.separateShaderObjectsSupported()) {
                    ARBSeparateShaderObjects.glProgramUniformMatrix2x4fv((int)program, (int)location, (boolean)transpose, (FloatBuffer)buffer.asFloatBuffer());
                } else {
                    if (program != class_5944.field_29486) {
                        GL30C.glUseProgram((int)program);
                    }
                    GL30C.glUniformMatrix2x4fv((int)location, (boolean)transpose, (FloatBuffer)buffer.asFloatBuffer());
                    if (program != class_5944.field_29486) {
                        GL30C.glUseProgram((int)class_5944.field_29486);
                    }
                }
            }
        }
        ,
        MATRIX4x2(32){

            @Override
            public void uploadAsMatrix(int program, int location, boolean transpose, ByteBuffer buffer) {
                if (VeilRenderSystem.separateShaderObjectsSupported()) {
                    ARBSeparateShaderObjects.glProgramUniformMatrix4x2fv((int)program, (int)location, (boolean)transpose, (FloatBuffer)buffer.asFloatBuffer());
                } else {
                    if (program != class_5944.field_29486) {
                        GL30C.glUseProgram((int)program);
                    }
                    GL30C.glUniformMatrix4x2fv((int)location, (boolean)transpose, (FloatBuffer)buffer.asFloatBuffer());
                    if (program != class_5944.field_29486) {
                        GL30C.glUseProgram((int)class_5944.field_29486);
                    }
                }
            }
        }
        ,
        MATRIX3x4(48){

            @Override
            public void uploadAsMatrix(int program, int location, boolean transpose, ByteBuffer buffer) {
                if (VeilRenderSystem.separateShaderObjectsSupported()) {
                    ARBSeparateShaderObjects.glProgramUniformMatrix3x4fv((int)program, (int)location, (boolean)transpose, (FloatBuffer)buffer.asFloatBuffer());
                } else {
                    if (program != class_5944.field_29486) {
                        GL30C.glUseProgram((int)program);
                    }
                    GL30C.glUniformMatrix3x4fv((int)location, (boolean)transpose, (FloatBuffer)buffer.asFloatBuffer());
                    if (program != class_5944.field_29486) {
                        GL30C.glUseProgram((int)class_5944.field_29486);
                    }
                }
            }
        }
        ,
        MATRIX4x3(48){

            @Override
            public void uploadAsMatrix(int program, int location, boolean transpose, ByteBuffer buffer) {
                if (VeilRenderSystem.separateShaderObjectsSupported()) {
                    ARBSeparateShaderObjects.glProgramUniformMatrix4x3fv((int)program, (int)location, (boolean)transpose, (FloatBuffer)buffer.asFloatBuffer());
                } else {
                    if (program != class_5944.field_29486) {
                        GL30C.glUseProgram((int)program);
                    }
                    GL30C.glUniformMatrix4x3fv((int)location, (boolean)transpose, (FloatBuffer)buffer.asFloatBuffer());
                    if (program != class_5944.field_29486) {
                        GL30C.glUseProgram((int)class_5944.field_29486);
                    }
                }
            }
        }
        ,
        DOUBLE(8){

            @Override
            public void upload(int program, int location, ByteBuffer buffer) {
                if (!VeilRenderSystem.gpuShaderFloat64BitSupported()) {
                    throw new UnsupportedOperationException("64-Bit Floats are not supported");
                }
                if (VeilRenderSystem.separateShaderObjectsSupported()) {
                    ARBSeparateShaderObjects.glProgramUniform1dv((int)program, (int)location, (DoubleBuffer)buffer.asDoubleBuffer());
                } else {
                    if (program != class_5944.field_29486) {
                        GL30C.glUseProgram((int)program);
                    }
                    ARBGPUShaderFP64.glUniform1dv((int)location, (DoubleBuffer)buffer.asDoubleBuffer());
                    if (program != class_5944.field_29486) {
                        GL30C.glUseProgram((int)class_5944.field_29486);
                    }
                }
            }
        }
        ,
        DOUBLE_VEC2(16){

            @Override
            public void upload(int program, int location, ByteBuffer buffer) {
                if (!VeilRenderSystem.gpuShaderFloat64BitSupported()) {
                    throw new UnsupportedOperationException("64-Bit Floats are not supported");
                }
                if (VeilRenderSystem.separateShaderObjectsSupported()) {
                    ARBSeparateShaderObjects.glProgramUniform2dv((int)program, (int)location, (DoubleBuffer)buffer.asDoubleBuffer());
                } else {
                    if (program != class_5944.field_29486) {
                        GL30C.glUseProgram((int)program);
                    }
                    ARBGPUShaderFP64.glUniform2dv((int)location, (DoubleBuffer)buffer.asDoubleBuffer());
                    if (program != class_5944.field_29486) {
                        GL30C.glUseProgram((int)class_5944.field_29486);
                    }
                }
            }
        }
        ,
        DOUBLE_VEC3(24){

            @Override
            public void upload(int program, int location, ByteBuffer buffer) {
                if (!VeilRenderSystem.gpuShaderFloat64BitSupported()) {
                    throw new UnsupportedOperationException("64-Bit Floats are not supported");
                }
                if (VeilRenderSystem.separateShaderObjectsSupported()) {
                    ARBSeparateShaderObjects.glProgramUniform3dv((int)program, (int)location, (DoubleBuffer)buffer.asDoubleBuffer());
                } else {
                    if (program != class_5944.field_29486) {
                        GL30C.glUseProgram((int)program);
                    }
                    ARBGPUShaderFP64.glUniform3dv((int)location, (DoubleBuffer)buffer.asDoubleBuffer());
                    if (program != class_5944.field_29486) {
                        GL30C.glUseProgram((int)class_5944.field_29486);
                    }
                }
            }
        }
        ,
        DOUBLE_VEC4(32){

            @Override
            public void upload(int program, int location, ByteBuffer buffer) {
                if (!VeilRenderSystem.gpuShaderFloat64BitSupported()) {
                    throw new UnsupportedOperationException("64-Bit Floats are not supported");
                }
                if (VeilRenderSystem.separateShaderObjectsSupported()) {
                    ARBSeparateShaderObjects.glProgramUniform4dv((int)program, (int)location, (DoubleBuffer)buffer.asDoubleBuffer());
                } else {
                    if (program != class_5944.field_29486) {
                        GL30C.glUseProgram((int)program);
                    }
                    ARBGPUShaderFP64.glUniform4dv((int)location, (DoubleBuffer)buffer.asDoubleBuffer());
                    if (program != class_5944.field_29486) {
                        GL30C.glUseProgram((int)class_5944.field_29486);
                    }
                }
            }
        }
        ,
        LONG(8){

            @Override
            public void upload(int program, int location, ByteBuffer buffer) {
                if (!VeilRenderSystem.gpuShaderInt64BitSupported()) {
                    throw new UnsupportedOperationException("64-Bit Integers are not supported");
                }
                if (VeilRenderSystem.separateShaderObjectsSupported()) {
                    ARBGPUShaderInt64.glProgramUniform1i64vARB((int)program, (int)location, (LongBuffer)buffer.asLongBuffer());
                } else {
                    if (program != class_5944.field_29486) {
                        GL30C.glUseProgram((int)program);
                    }
                    ARBGPUShaderInt64.glUniform1i64vARB((int)location, (LongBuffer)buffer.asLongBuffer());
                    if (program != class_5944.field_29486) {
                        GL30C.glUseProgram((int)class_5944.field_29486);
                    }
                }
            }
        }
        ,
        LONG_VEC2(16){

            @Override
            public void upload(int program, int location, ByteBuffer buffer) {
                if (!VeilRenderSystem.gpuShaderInt64BitSupported()) {
                    throw new UnsupportedOperationException("64-Bit Integers are not supported");
                }
                if (VeilRenderSystem.separateShaderObjectsSupported()) {
                    ARBGPUShaderInt64.glProgramUniform2i64vARB((int)program, (int)location, (LongBuffer)buffer.asLongBuffer());
                } else {
                    if (program != class_5944.field_29486) {
                        GL30C.glUseProgram((int)program);
                    }
                    ARBGPUShaderInt64.glUniform2i64vARB((int)location, (LongBuffer)buffer.asLongBuffer());
                    if (program != class_5944.field_29486) {
                        GL30C.glUseProgram((int)class_5944.field_29486);
                    }
                }
            }
        }
        ,
        LONG_VEC3(24){

            @Override
            public void upload(int program, int location, ByteBuffer buffer) {
                if (!VeilRenderSystem.gpuShaderInt64BitSupported()) {
                    throw new UnsupportedOperationException("64-Bit Integers are not supported");
                }
                if (VeilRenderSystem.separateShaderObjectsSupported()) {
                    ARBGPUShaderInt64.glProgramUniform3i64vARB((int)program, (int)location, (LongBuffer)buffer.asLongBuffer());
                } else {
                    if (program != class_5944.field_29486) {
                        GL30C.glUseProgram((int)program);
                    }
                    ARBGPUShaderInt64.glUniform3i64vARB((int)location, (LongBuffer)buffer.asLongBuffer());
                    if (program != class_5944.field_29486) {
                        GL30C.glUseProgram((int)class_5944.field_29486);
                    }
                }
            }
        }
        ,
        LONG_VEC4(32){

            @Override
            public void upload(int program, int location, ByteBuffer buffer) {
                if (!VeilRenderSystem.gpuShaderInt64BitSupported()) {
                    throw new UnsupportedOperationException("64-Bit Integers are not supported");
                }
                if (VeilRenderSystem.separateShaderObjectsSupported()) {
                    ARBGPUShaderInt64.glProgramUniform4i64vARB((int)program, (int)location, (LongBuffer)buffer.asLongBuffer());
                } else {
                    if (program != class_5944.field_29486) {
                        GL30C.glUseProgram((int)program);
                    }
                    ARBGPUShaderInt64.glUniform4i64vARB((int)location, (LongBuffer)buffer.asLongBuffer());
                    if (program != class_5944.field_29486) {
                        GL30C.glUseProgram((int)class_5944.field_29486);
                    }
                }
            }
        }
        ,
        UNSIGNED_LONG(8){

            @Override
            public void upload(int program, int location, ByteBuffer buffer) {
                if (!VeilRenderSystem.gpuShaderInt64BitSupported()) {
                    throw new UnsupportedOperationException("64-Bit Integers are not supported");
                }
                if (VeilRenderSystem.separateShaderObjectsSupported()) {
                    ARBGPUShaderInt64.glProgramUniform1ui64vARB((int)program, (int)location, (LongBuffer)buffer.asLongBuffer());
                } else {
                    if (program != class_5944.field_29486) {
                        GL30C.glUseProgram((int)program);
                    }
                    ARBGPUShaderInt64.glUniform1ui64vARB((int)location, (LongBuffer)buffer.asLongBuffer());
                    if (program != class_5944.field_29486) {
                        GL30C.glUseProgram((int)class_5944.field_29486);
                    }
                }
            }
        }
        ,
        UNSIGNED_LONG_VEC2(16){

            @Override
            public void upload(int program, int location, ByteBuffer buffer) {
                if (!VeilRenderSystem.gpuShaderInt64BitSupported()) {
                    throw new UnsupportedOperationException("64-Bit Integers are not supported");
                }
                if (VeilRenderSystem.separateShaderObjectsSupported()) {
                    ARBGPUShaderInt64.glProgramUniform2ui64vARB((int)program, (int)location, (LongBuffer)buffer.asLongBuffer());
                } else {
                    if (program != class_5944.field_29486) {
                        GL30C.glUseProgram((int)program);
                    }
                    ARBGPUShaderInt64.glUniform2ui64vARB((int)location, (LongBuffer)buffer.asLongBuffer());
                    if (program != class_5944.field_29486) {
                        GL30C.glUseProgram((int)class_5944.field_29486);
                    }
                }
            }
        }
        ,
        UNSIGNED_LONG_VEC3(24){

            @Override
            public void upload(int program, int location, ByteBuffer buffer) {
                if (!VeilRenderSystem.gpuShaderInt64BitSupported()) {
                    throw new UnsupportedOperationException("64-Bit Integers are not supported");
                }
                if (VeilRenderSystem.separateShaderObjectsSupported()) {
                    ARBGPUShaderInt64.glProgramUniform3ui64vARB((int)program, (int)location, (LongBuffer)buffer.asLongBuffer());
                } else {
                    if (program != class_5944.field_29486) {
                        GL30C.glUseProgram((int)program);
                    }
                    ARBGPUShaderInt64.glUniform3ui64vARB((int)location, (LongBuffer)buffer.asLongBuffer());
                    if (program != class_5944.field_29486) {
                        GL30C.glUseProgram((int)class_5944.field_29486);
                    }
                }
            }
        }
        ,
        UNSIGNED_LONG_VEC4(32){

            @Override
            public void upload(int program, int location, ByteBuffer buffer) {
                if (!VeilRenderSystem.gpuShaderInt64BitSupported()) {
                    throw new UnsupportedOperationException("64-Bit Integers are not supported");
                }
                if (VeilRenderSystem.separateShaderObjectsSupported()) {
                    ARBGPUShaderInt64.glProgramUniform4ui64vARB((int)program, (int)location, (LongBuffer)buffer.asLongBuffer());
                } else {
                    if (program != class_5944.field_29486) {
                        GL30C.glUseProgram((int)program);
                    }
                    ARBGPUShaderInt64.glUniform4ui64vARB((int)location, (LongBuffer)buffer.asLongBuffer());
                    if (program != class_5944.field_29486) {
                        GL30C.glUseProgram((int)class_5944.field_29486);
                    }
                }
            }
        }
        ,
        DOUBLE_MATRIX2x2(32){

            @Override
            public void uploadAsMatrix(int program, int location, boolean transpose, ByteBuffer buffer) {
                if (!VeilRenderSystem.gpuShaderFloat64BitSupported()) {
                    throw new UnsupportedOperationException("64-Bit Floats are not supported");
                }
                if (VeilRenderSystem.separateShaderObjectsSupported()) {
                    ARBSeparateShaderObjects.glProgramUniformMatrix2dv((int)program, (int)location, (boolean)transpose, (DoubleBuffer)buffer.asDoubleBuffer());
                } else {
                    if (program != class_5944.field_29486) {
                        GL30C.glUseProgram((int)program);
                    }
                    ARBGPUShaderFP64.glUniformMatrix2dv((int)location, (boolean)transpose, (DoubleBuffer)buffer.asDoubleBuffer());
                    if (program != class_5944.field_29486) {
                        GL30C.glUseProgram((int)class_5944.field_29486);
                    }
                }
            }
        }
        ,
        DOUBLE_MATRIX3x3(72){

            @Override
            public void uploadAsMatrix(int program, int location, boolean transpose, ByteBuffer buffer) {
                if (!VeilRenderSystem.gpuShaderFloat64BitSupported()) {
                    throw new UnsupportedOperationException("64-Bit Floats are not supported");
                }
                if (VeilRenderSystem.separateShaderObjectsSupported()) {
                    ARBSeparateShaderObjects.glProgramUniformMatrix3dv((int)program, (int)location, (boolean)transpose, (DoubleBuffer)buffer.asDoubleBuffer());
                } else {
                    if (program != class_5944.field_29486) {
                        GL30C.glUseProgram((int)program);
                    }
                    ARBGPUShaderFP64.glUniformMatrix3dv((int)location, (boolean)transpose, (DoubleBuffer)buffer.asDoubleBuffer());
                    if (program != class_5944.field_29486) {
                        GL30C.glUseProgram((int)class_5944.field_29486);
                    }
                }
            }
        }
        ,
        DOUBLE_MATRIX4x4(128){

            @Override
            public void uploadAsMatrix(int program, int location, boolean transpose, ByteBuffer buffer) {
                if (!VeilRenderSystem.gpuShaderFloat64BitSupported()) {
                    throw new UnsupportedOperationException("64-Bit Floats are not supported");
                }
                if (VeilRenderSystem.separateShaderObjectsSupported()) {
                    ARBSeparateShaderObjects.glProgramUniformMatrix4dv((int)program, (int)location, (boolean)transpose, (DoubleBuffer)buffer.asDoubleBuffer());
                } else {
                    if (program != class_5944.field_29486) {
                        GL30C.glUseProgram((int)program);
                    }
                    ARBGPUShaderFP64.glUniformMatrix4dv((int)location, (boolean)transpose, (DoubleBuffer)buffer.asDoubleBuffer());
                    if (program != class_5944.field_29486) {
                        GL30C.glUseProgram((int)class_5944.field_29486);
                    }
                }
            }
        }
        ,
        DOUBLE_MATRIX2x3(48){

            @Override
            public void uploadAsMatrix(int program, int location, boolean transpose, ByteBuffer buffer) {
                if (!VeilRenderSystem.gpuShaderFloat64BitSupported()) {
                    throw new UnsupportedOperationException("64-Bit Floats are not supported");
                }
                if (VeilRenderSystem.separateShaderObjectsSupported()) {
                    ARBSeparateShaderObjects.glProgramUniformMatrix2x3dv((int)program, (int)location, (boolean)transpose, (DoubleBuffer)buffer.asDoubleBuffer());
                } else {
                    if (program != class_5944.field_29486) {
                        GL30C.glUseProgram((int)program);
                    }
                    ARBGPUShaderFP64.glUniformMatrix2x3dv((int)location, (boolean)transpose, (DoubleBuffer)buffer.asDoubleBuffer());
                    if (program != class_5944.field_29486) {
                        GL30C.glUseProgram((int)class_5944.field_29486);
                    }
                }
            }
        }
        ,
        DOUBLE_MATRIX3x2(48){

            @Override
            public void uploadAsMatrix(int program, int location, boolean transpose, ByteBuffer buffer) {
                if (!VeilRenderSystem.gpuShaderFloat64BitSupported()) {
                    throw new UnsupportedOperationException("64-Bit Floats are not supported");
                }
                if (VeilRenderSystem.separateShaderObjectsSupported()) {
                    ARBSeparateShaderObjects.glProgramUniformMatrix3x2dv((int)program, (int)location, (boolean)transpose, (DoubleBuffer)buffer.asDoubleBuffer());
                } else {
                    if (program != class_5944.field_29486) {
                        GL30C.glUseProgram((int)program);
                    }
                    ARBGPUShaderFP64.glUniformMatrix3x2dv((int)location, (boolean)transpose, (DoubleBuffer)buffer.asDoubleBuffer());
                    if (program != class_5944.field_29486) {
                        GL30C.glUseProgram((int)class_5944.field_29486);
                    }
                }
            }
        }
        ,
        DOUBLE_MATRIX2x4(64){

            @Override
            public void uploadAsMatrix(int program, int location, boolean transpose, ByteBuffer buffer) {
                if (!VeilRenderSystem.gpuShaderFloat64BitSupported()) {
                    throw new UnsupportedOperationException("64-Bit Floats are not supported");
                }
                if (VeilRenderSystem.separateShaderObjectsSupported()) {
                    ARBSeparateShaderObjects.glProgramUniformMatrix2x4dv((int)program, (int)location, (boolean)transpose, (DoubleBuffer)buffer.asDoubleBuffer());
                } else {
                    if (program != class_5944.field_29486) {
                        GL30C.glUseProgram((int)program);
                    }
                    ARBGPUShaderFP64.glUniformMatrix2x4dv((int)location, (boolean)transpose, (DoubleBuffer)buffer.asDoubleBuffer());
                    if (program != class_5944.field_29486) {
                        GL30C.glUseProgram((int)class_5944.field_29486);
                    }
                }
            }
        }
        ,
        DOUBLE_MATRIX4x2(64){

            @Override
            public void uploadAsMatrix(int program, int location, boolean transpose, ByteBuffer buffer) {
                if (!VeilRenderSystem.gpuShaderFloat64BitSupported()) {
                    throw new UnsupportedOperationException("64-Bit Floats are not supported");
                }
                if (VeilRenderSystem.separateShaderObjectsSupported()) {
                    ARBSeparateShaderObjects.glProgramUniformMatrix4x2dv((int)program, (int)location, (boolean)transpose, (DoubleBuffer)buffer.asDoubleBuffer());
                } else {
                    if (program != class_5944.field_29486) {
                        GL30C.glUseProgram((int)program);
                    }
                    ARBGPUShaderFP64.glUniformMatrix4x2dv((int)location, (boolean)transpose, (DoubleBuffer)buffer.asDoubleBuffer());
                    if (program != class_5944.field_29486) {
                        GL30C.glUseProgram((int)class_5944.field_29486);
                    }
                }
            }
        }
        ,
        DOUBLE_MATRIX3x4(96){

            @Override
            public void uploadAsMatrix(int program, int location, boolean transpose, ByteBuffer buffer) {
                if (!VeilRenderSystem.gpuShaderFloat64BitSupported()) {
                    throw new UnsupportedOperationException("64-Bit Floats are not supported");
                }
                if (VeilRenderSystem.separateShaderObjectsSupported()) {
                    ARBSeparateShaderObjects.glProgramUniformMatrix3x4dv((int)program, (int)location, (boolean)transpose, (DoubleBuffer)buffer.asDoubleBuffer());
                } else {
                    if (program != class_5944.field_29486) {
                        GL30C.glUseProgram((int)program);
                    }
                    ARBGPUShaderFP64.glUniformMatrix3x4dv((int)location, (boolean)transpose, (DoubleBuffer)buffer.asDoubleBuffer());
                    if (program != class_5944.field_29486) {
                        GL30C.glUseProgram((int)class_5944.field_29486);
                    }
                }
            }
        }
        ,
        DOUBLE_MATRIX4x3(96){

            @Override
            public void uploadAsMatrix(int program, int location, boolean transpose, ByteBuffer buffer) {
                if (!VeilRenderSystem.gpuShaderFloat64BitSupported()) {
                    throw new UnsupportedOperationException("64-Bit Floats are not supported");
                }
                if (VeilRenderSystem.separateShaderObjectsSupported()) {
                    ARBSeparateShaderObjects.glProgramUniformMatrix4x3dv((int)program, (int)location, (boolean)transpose, (DoubleBuffer)buffer.asDoubleBuffer());
                } else {
                    if (program != class_5944.field_29486) {
                        GL30C.glUseProgram((int)program);
                    }
                    ARBGPUShaderFP64.glUniformMatrix4x3dv((int)location, (boolean)transpose, (DoubleBuffer)buffer.asDoubleBuffer());
                    if (program != class_5944.field_29486) {
                        GL30C.glUseProgram((int)class_5944.field_29486);
                    }
                }
            }
        };

        private final int bytes;

        private Type(int bytes) {
            this.bytes = bytes;
        }

        public static Type byId(int type) {
            if (ShaderUniformCache.isSampler(type)) {
                return SAMPLER;
            }
            return switch (type) {
                case 5126 -> FLOAT;
                case 35664 -> FLOAT_VEC2;
                case 35665 -> FLOAT_VEC3;
                case 35666 -> FLOAT_VEC4;
                case 5124 -> INT;
                case 35667 -> INT_VEC2;
                case 35668 -> INT_VEC3;
                case 35669 -> INT_VEC4;
                case 5125 -> UNSIGNED_INT;
                case 36294 -> UNSIGNED_INT_VEC2;
                case 36295 -> UNSIGNED_INT_VEC3;
                case 36296 -> UNSIGNED_INT_VEC4;
                case 35674 -> MATRIX2x2;
                case 35675 -> MATRIX3x3;
                case 35676 -> MATRIX4x4;
                case 35685 -> MATRIX2x3;
                case 35688 -> MATRIX3x4;
                case 5130 -> DOUBLE;
                case 36860 -> DOUBLE_VEC2;
                case 36861 -> DOUBLE_VEC3;
                case 36862 -> DOUBLE_VEC4;
                case 5134 -> LONG;
                case 36841 -> LONG_VEC2;
                case 36842 -> LONG_VEC3;
                case 36843 -> LONG_VEC4;
                case 5135 -> UNSIGNED_LONG;
                case 36853 -> UNSIGNED_LONG_VEC2;
                case 36854 -> UNSIGNED_LONG_VEC3;
                case 36855 -> UNSIGNED_LONG_VEC4;
                case 36678 -> DOUBLE_MATRIX2x2;
                case 36679 -> DOUBLE_MATRIX3x3;
                case 36680 -> DOUBLE_MATRIX4x4;
                case 36681 -> DOUBLE_MATRIX2x3;
                case 36684 -> DOUBLE_MATRIX3x4;
                default -> throw new AssertionError((Object)("Invalid Uniform Type: " + ShaderUniformCache.getName(type)));
            };
        }

        public void upload(int program, int location, ByteBuffer buffer) {
            throw new UnsupportedOperationException();
        }

        public void uploadAsMatrix(int program, int location, boolean transpose, ByteBuffer buffer) {
            throw new UnsupportedOperationException();
        }

        public int getBytes() {
            if (this == SAMPLER) {
                return VeilRenderSystem.bindlessTextureSupported() ? 8 : 4;
            }
            return this.bytes;
        }
    }
}

