/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.shader.program;

import foundry.veil.api.client.render.VeilRenderSystem;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.lang.invoke.LambdaMetafactory;
import java.nio.Buffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.IntFunction;
import java.util.function.IntSupplier;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.ARBProgramInterfaceQuery;
import org.lwjgl.opengl.GL42C;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class ShaderUniformCache {
    private static final IntSet SAMPLERS = IntSet.of((int[])new int[]{35677, 35678, 35679, 35680, 35681, 35682, 36288, 36289, 36291, 36292, 37128, 37131, 36293, 36290, 35683, 35684, 36297, 36298, 36299, 36300, 36302, 36303, 37129, 37132, 36304, 36301, 36305, 36306, 36307, 36308, 36310, 36311, 37130, 37133, 36312, 36309, 36940, 36941, 36942, 36943, 36944, 36945, 36946, 36947, 36949, 36950, 36951, 36952, 36953, 36954, 36955, 36956, 36957, 36958, 36960, 36961, 36962, 36963, 36964, 36965, 36966, 36967, 36968, 36969, 36971, 36972});
    private static final Int2ObjectMap<String> NAMES;
    private final IntSupplier shader;
    private final Object2ObjectMap<String, Uniform> samplers;
    private final Object2ObjectMap<String, Uniform> uniforms;
    private final Object2ObjectMap<String, UniformBlock> uniformBlocks;
    private final Object2ObjectMap<String, StorageBlock> storageBlocks;
    private final Object2ObjectMap<String, Uniform> samplersView;
    private final Object2ObjectMap<String, Uniform> uniformsView;
    private final Object2ObjectMap<String, UniformBlock> uniformBlocksView;
    private final Object2ObjectMap<String, StorageBlock> storageBlocksView;
    private boolean requested;

    public ShaderUniformCache(IntSupplier shader) {
        this.shader = shader;
        this.samplers = new Object2ObjectOpenHashMap();
        this.uniforms = new Object2ObjectOpenHashMap();
        this.uniformBlocks = new Object2ObjectOpenHashMap();
        this.storageBlocks = new Object2ObjectOpenHashMap();
        this.samplersView = Object2ObjectMaps.unmodifiable(this.samplers);
        this.uniformsView = Object2ObjectMaps.unmodifiable(this.uniforms);
        this.uniformBlocksView = Object2ObjectMaps.unmodifiable(this.uniformBlocks);
        this.storageBlocksView = Object2ObjectMaps.unmodifiable(this.storageBlocks);
        this.requested = false;
    }

    public void clear() {
        this.samplers.clear();
        this.uniforms.clear();
        this.uniformBlocks.clear();
        this.storageBlocks.clear();
        this.requested = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void updateUniforms() {
        block37: {
            this.requested = true;
            program = this.shader.getAsInt();
            if (!VeilRenderSystem.programInterfaceQuerySupported()) break block37;
            uniformCount = ARBProgramInterfaceQuery.glGetProgramInterfacei((int)program, (int)37601, (int)37621);
            uniformBlockCount = ARBProgramInterfaceQuery.glGetProgramInterfacei((int)program, (int)37602, (int)37621);
            storageBlockCount = ARBProgramInterfaceQuery.glGetProgramInterfacei((int)program, (int)37606, (int)37621);
            stack = MemoryStack.stackPush();
            try {
                uniformProperties = stack.ints(new int[]{37629, 37627, 37625, 37646, 37626});
                uniformBlockProperties = stack.ints(37625, 37635, 37636);
                uniformBlockFieldProperties = stack.ints(new int[]{37625, 37627, 37630, 37628, 37626, 37633});
                uniformBufferFieldProperties = stack.ints(new int[]{37625, 37627, 37630, 37628, 37626});
                activeVariables = stack.ints(37637);
                values = stack.mallocInt(6);
                for (i = 0; i < uniformCount; ++i) {
                    ARBProgramInterfaceQuery.glGetProgramResourceiv((int)program, (int)37601, (int)i, (IntBuffer)uniformProperties, null, (IntBuffer)values);
                    blockIndex = values.get(0);
                    if (blockIndex != -1) continue;
                    length = values.get(1);
                    type = values.get(4);
                    resourceName = ARBProgramInterfaceQuery.glGetProgramResourceName((int)program, (int)37601, (int)i, (int)values.get(2));
                    baseName = resourceName.contains("[") != false ? resourceName.substring(0, resourceName.indexOf(91)) : resourceName;
                    for (j = 0; j < length; ++j) {
                        name = length > 1 ? baseName + "[" + j + "]" : baseName;
                        location = values.get(3) + j;
                        uniform = new Uniform(name, location, 0, type, 1);
                        this.uniforms.put((Object)name, (Object)uniform);
                        if (!ShaderUniformCache.isSampler(type)) continue;
                        this.samplers.put((Object)name, (Object)uniform);
                    }
                    if (length <= 1) continue;
                    uniform = new Uniform(baseName, values.get(3), 0, type, length);
                    this.uniforms.put((Object)baseName, (Object)uniform);
                    if (!ShaderUniformCache.isSampler(type)) continue;
                    this.samplers.put((Object)baseName, (Object)uniform);
                }
                for (i = 0; i < uniformBlockCount; ++i) {
                    ARBProgramInterfaceQuery.glGetProgramResourceiv((int)program, (int)37602, (int)i, (IntBuffer)uniformBlockProperties, null, (IntBuffer)values);
                    blockName = ARBProgramInterfaceQuery.glGetProgramResourceName((int)program, (int)37602, (int)i, (int)values.get(0));
                    size = values.get(1);
                    fieldCount = values.get(2);
                    fields = new ArrayList<Uniform>(fieldCount);
                    fieldIndices = MemoryUtil.memAllocInt((int)fieldCount);
                    ARBProgramInterfaceQuery.glGetProgramResourceiv((int)program, (int)37602, (int)i, (IntBuffer)activeVariables, null, (IntBuffer)fieldIndices);
lbl49:
                    // 2 sources

                    try {
                        for (j = 0; j < fieldCount; ++j) {
                            block38: {
                                ARBProgramInterfaceQuery.glGetProgramResourceiv((int)program, (int)37601, (int)fieldIndices.get(j), (IntBuffer)uniformBlockFieldProperties, null, (IntBuffer)values);
                                if (values.get(5) != -1) continue;
                                name = ARBProgramInterfaceQuery.glGetProgramResourceName((int)program, (int)37601, (int)fieldIndices.get(j), (int)values.get(0));
                                arrayLength = values.get(1);
                                offset = values.get(3);
                                type = values.get(4);
                                if (arrayLength <= 0) break block38;
                                stride = values.get(2);
                                nameBase = name.endsWith("]") != false ? name.substring(0, name.length() - 3) : name;
                                for (k = 0; k < arrayLength; ++k) {
                                    fields.add(new Uniform(nameBase + "[" + k + "]", -1, offset + stride * k, type, 1));
                                }
                                ** GOTO lbl49
                            }
                            fields.add(new Uniform(name, -1, offset, type, 1));
                        }
                        this.uniformBlocks.put((Object)blockName, (Object)new UniformBlock(blockName, i, size, (Uniform[])fields.toArray((IntFunction<Uniform[]>)LambdaMetafactory.metafactory(null, null, null, (I)Ljava/lang/Object;, lambda$updateUniforms$0(int ), (I)[Lfoundry/veil/api/client/render/shader/program/ShaderUniformCache$Uniform;)())));
                        continue;
                    }
                    finally {
                        MemoryUtil.memFree((Buffer)fieldIndices);
                    }
                }
                for (i = 0; i < storageBlockCount; ++i) {
                    ARBProgramInterfaceQuery.glGetProgramResourceiv((int)program, (int)37606, (int)i, (IntBuffer)uniformBlockProperties, null, (IntBuffer)values);
                    blockName = ARBProgramInterfaceQuery.glGetProgramResourceName((int)program, (int)37606, (int)i, (int)values.get(0));
                    size = values.get(1);
                    fieldCount = values.get(2);
                    fields = new ArrayList<E>(fieldCount);
                    fieldIndices = MemoryUtil.memAllocInt((int)fieldCount);
                    ARBProgramInterfaceQuery.glGetProgramResourceiv((int)program, (int)37606, (int)i, (IntBuffer)activeVariables, null, (IntBuffer)fieldIndices);
lbl83:
                    // 2 sources

                    try {
                        for (j = 0; j < fieldCount; ++j) {
                            block39: {
                                ARBProgramInterfaceQuery.glGetProgramResourceiv((int)program, (int)37605, (int)fieldIndices.get(j), (IntBuffer)uniformBufferFieldProperties, null, (IntBuffer)values);
                                name = ARBProgramInterfaceQuery.glGetProgramResourceName((int)program, (int)37605, (int)fieldIndices.get(j), (int)values.get(0));
                                arrayLength = values.get(1);
                                offset = values.get(3);
                                type = values.get(4);
                                if (arrayLength <= 1) break block39;
                                stride = values.get(2);
                                nameBase = name.substring(0, name.length() - 3);
                                for (k = 0; k < arrayLength; ++k) {
                                    fields.add(new Uniform(nameBase + "[" + k + "]", -1, offset + stride * k, type, 1));
                                }
                                ** GOTO lbl83
                            }
                            fields.add(new Uniform(name, -1, offset, type, 1));
                        }
                    }
                    finally {
                        MemoryUtil.memFree((Buffer)fieldIndices);
                    }
                    last = (Uniform)fields.getLast();
                    array = last.name.endsWith("[0]");
                    if (array) {
                        fields.set(fields.size() - 1, new Uniform(last.name.substring(0, last.name.length() - 3), last.location, last.offset, last.type, 1));
                    }
                    this.storageBlocks.put((Object)blockName, (Object)new StorageBlock(blockName, i, size, values.get(2), (Uniform[])fields.toArray((IntFunction<Uniform[]>)LambdaMetafactory.metafactory(null, null, null, (I)Ljava/lang/Object;, lambda$updateUniforms$1(int ), (I)[Lfoundry/veil/api/client/render/shader/program/ShaderUniformCache$Uniform;)())));
                }
            }
            finally {
                if (stack != null) {
                    stack.close();
                }
            }
        }
        uniformCount = GL42C.glGetProgrami((int)program, (int)35718);
        maxUniformLength = GL42C.glGetProgrami((int)program, (int)35719);
        uniformBlockCount = GL42C.glGetProgrami((int)program, (int)35382);
        maxUniformBlockLength = GL42C.glGetProgrami((int)program, (int)35381);
        stack = MemoryStack.stackPush();
        try {
            size = stack.mallocInt(1);
            type = stack.mallocInt(1);
            for (i = 0; i < uniformCount; ++i) {
                baseName = GL42C.glGetActiveUniform((int)program, (int)i, (int)maxUniformLength, (IntBuffer)size, (IntBuffer)type);
                if (baseName.contains(".")) continue;
                length = size.get(0);
                if (baseName.contains("[")) {
                    baseName = baseName.substring(0, baseName.indexOf(91));
                }
                for (j = 0; j < length; ++j) {
                    name = length > 1 ? baseName + "[" + j + "]" : baseName;
                    uniform = new Uniform(name, GL42C.glGetUniformLocation((int)program, (CharSequence)name), 0, type.get(0), 1);
                    this.uniforms.put((Object)name, (Object)uniform);
                    if (!ShaderUniformCache.isSampler(type.get(0))) continue;
                    this.samplers.put((Object)name, (Object)uniform);
                }
                if (length <= 1) continue;
                uniform = new Uniform(baseName, GL42C.glGetUniformLocation((int)program, (CharSequence)baseName), 0, type.get(0), length);
                this.uniforms.put((Object)baseName, (Object)uniform);
                if (!ShaderUniformCache.isSampler(type.get(0))) continue;
                this.samplers.put((Object)baseName, (Object)uniform);
            }
            for (i = 0; i < uniformBlockCount; ++i) {
                blockName = GL42C.glGetActiveUniformBlockName((int)program, (int)i, (int)maxUniformBlockLength);
                bufferSize = GL42C.glGetActiveUniformBlocki((int)program, (int)i, (int)35392);
                fields = new Uniform[GL42C.glGetActiveUniformBlocki((int)program, (int)i, (int)35394)];
                fieldIndices = MemoryUtil.memAllocInt((int)fields.length);
                GL42C.glGetActiveUniformBlockiv((int)program, (int)i, (int)35395, (IntBuffer)fieldIndices);
                try {
                    for (j = 0; j < fields.length; ++j) {
                        index = fieldIndices.get(j);
                        name = GL42C.glGetActiveUniform((int)program, (int)index, (int)maxUniformLength, (IntBuffer)size, (IntBuffer)type);
                        offset = GL42C.glGetActiveUniformsi((int)program, (int)index, (int)35387);
                        fields[j] = new Uniform(name, GL42C.glGetUniformLocation((int)program, (CharSequence)name), offset, type.get(0), 1);
                    }
                    this.uniformBlocks.put((Object)blockName, (Object)new UniformBlock(blockName, i, bufferSize, fields));
                    continue;
                }
                finally {
                    MemoryUtil.memFree((Buffer)fieldIndices);
                }
            }
        }
        finally {
            if (stack != null) {
                stack.close();
            }
        }
    }

    @Nullable
    public Uniform getUniform(CharSequence name) {
        if (!this.requested) {
            this.updateUniforms();
        }
        return (Uniform)this.uniforms.get((Object)name);
    }

    public boolean hasUniform(String name) {
        if (!this.requested) {
            this.updateUniforms();
        }
        return this.uniforms.containsKey((Object)name);
    }

    @Nullable
    public UniformBlock getUniformBlock(String name) {
        if (!this.requested) {
            this.updateUniforms();
        }
        return (UniformBlock)this.uniformBlocks.get((Object)name);
    }

    public boolean hasUniformBlock(String name) {
        if (!this.requested) {
            this.updateUniforms();
        }
        return this.uniformBlocks.containsKey((Object)name);
    }

    @Nullable
    public StorageBlock getStorageBlock(String name) {
        if (!this.requested) {
            this.updateUniforms();
        }
        return (StorageBlock)this.storageBlocks.get((Object)name);
    }

    public boolean hasStorageBlock(String name) {
        if (!this.requested) {
            this.updateUniforms();
        }
        return this.storageBlocks.containsKey((Object)name);
    }

    public boolean hasSampler(String name) {
        if (!this.requested) {
            this.updateUniforms();
        }
        return this.samplers.containsKey((Object)name);
    }

    public Map<String, Uniform> getSamplers() {
        if (!this.requested) {
            this.updateUniforms();
        }
        return this.samplersView;
    }

    public Map<String, Uniform> getUniforms() {
        if (!this.requested) {
            this.updateUniforms();
        }
        return this.uniformsView;
    }

    public Map<String, UniformBlock> getUniformBlocks() {
        if (!this.requested) {
            this.updateUniforms();
        }
        return this.uniformBlocksView;
    }

    public Map<String, StorageBlock> getStorageBlocks() {
        if (!this.requested) {
            this.updateUniforms();
        }
        return this.storageBlocksView;
    }

    public static boolean isSampler(int type) {
        return SAMPLERS.contains(type);
    }

    public static String getName(int type) {
        return (String)NAMES.getOrDefault(type, (Object)"0x%04X".formatted(type));
    }

    private static /* synthetic */ Uniform[] lambda$updateUniforms$1(int x$0) {
        return new Uniform[x$0];
    }

    private static /* synthetic */ Uniform[] lambda$updateUniforms$0(int x$0) {
        return new Uniform[x$0];
    }

    static {
        Int2ObjectArrayMap names = new Int2ObjectArrayMap(105);
        names.put(5126, (Object)"float");
        names.put(35664, (Object)"vec2");
        names.put(35665, (Object)"vec3");
        names.put(35666, (Object)"vec4");
        names.put(5130, (Object)"double");
        names.put(36860, (Object)"dvec2");
        names.put(36861, (Object)"dvec3");
        names.put(36862, (Object)"dvec4");
        names.put(5124, (Object)"int");
        names.put(35667, (Object)"ivec2");
        names.put(35668, (Object)"ivec3");
        names.put(35669, (Object)"ivec4");
        names.put(5125, (Object)"unsigned int");
        names.put(36294, (Object)"uvec2");
        names.put(36295, (Object)"uvec3");
        names.put(36296, (Object)"uvec4");
        names.put(35670, (Object)"bool");
        names.put(35671, (Object)"bvec2");
        names.put(35672, (Object)"bvec3");
        names.put(35673, (Object)"bvec4");
        names.put(35674, (Object)"mat2");
        names.put(35675, (Object)"mat3");
        names.put(35676, (Object)"mat4");
        names.put(35685, (Object)"mat2x3");
        names.put(35686, (Object)"mat2x4");
        names.put(35687, (Object)"mat3x2");
        names.put(35688, (Object)"mat3x4");
        names.put(35689, (Object)"mat4x2");
        names.put(35690, (Object)"mat4x3");
        names.put(36678, (Object)"dmat2");
        names.put(36679, (Object)"dmat3");
        names.put(36680, (Object)"dmat4");
        names.put(36681, (Object)"dmat2x3");
        names.put(36682, (Object)"dmat2x4");
        names.put(36683, (Object)"dmat3x2");
        names.put(36684, (Object)"dmat3x4");
        names.put(36685, (Object)"dmat4x2");
        names.put(36686, (Object)"dmat4x3");
        names.put(35677, (Object)"sampler1D");
        names.put(35678, (Object)"sampler2D");
        names.put(35679, (Object)"sampler3D");
        names.put(35680, (Object)"samplerCube");
        names.put(35681, (Object)"sampler1DShadow");
        names.put(35682, (Object)"sampler2DShadow");
        names.put(36288, (Object)"sampler1DArray");
        names.put(36289, (Object)"sampler2DArray");
        names.put(36291, (Object)"sampler1DArrayShadow");
        names.put(36292, (Object)"sampler2DArrayShadow");
        names.put(37128, (Object)"sampler2DMS");
        names.put(37131, (Object)"sampler2DMSArray");
        names.put(36293, (Object)"samplerCubeShadow");
        names.put(36290, (Object)"samplerBuffer");
        names.put(35683, (Object)"sampler2DRect");
        names.put(35684, (Object)"sampler2DRectShadow");
        names.put(36297, (Object)"isampler1D");
        names.put(36298, (Object)"isampler2D");
        names.put(36299, (Object)"isampler3D");
        names.put(36300, (Object)"isamplerCube");
        names.put(36302, (Object)"isampler1DArray");
        names.put(36303, (Object)"isampler2DArray");
        names.put(37129, (Object)"isampler2DMS");
        names.put(37132, (Object)"isampler2DMSArray");
        names.put(36304, (Object)"isamplerBuffer");
        names.put(36301, (Object)"isampler2DRect");
        names.put(36305, (Object)"usampler1D");
        names.put(36306, (Object)"usampler2D");
        names.put(36307, (Object)"usampler3D");
        names.put(36308, (Object)"usamplerCube");
        names.put(36310, (Object)"usampler2DArray");
        names.put(36311, (Object)"usampler2DArray");
        names.put(37130, (Object)"usampler2DMS");
        names.put(37133, (Object)"usampler2DMSArray");
        names.put(36312, (Object)"usamplerBuffer");
        names.put(36309, (Object)"usampler2DRect");
        names.put(36940, (Object)"image1D");
        names.put(36941, (Object)"image2D");
        names.put(36942, (Object)"image3D");
        names.put(36943, (Object)"image2DRect");
        names.put(36944, (Object)"imageCube");
        names.put(36945, (Object)"imageBuffer");
        names.put(36946, (Object)"image1DArray");
        names.put(36947, (Object)"image2DArray");
        names.put(36949, (Object)"image2DMS");
        names.put(36950, (Object)"image2DMSArray");
        names.put(36951, (Object)"iimage1D");
        names.put(36952, (Object)"iimage2D");
        names.put(36953, (Object)"iimage3D");
        names.put(36954, (Object)"iimage2DRect");
        names.put(36955, (Object)"iimageCube");
        names.put(36956, (Object)"iimageBuffer");
        names.put(36957, (Object)"iimage1DArray");
        names.put(36958, (Object)"iimage2DArray");
        names.put(36960, (Object)"iimage2DMS");
        names.put(36961, (Object)"iimage2DMSArray");
        names.put(36962, (Object)"uimage1D");
        names.put(36963, (Object)"uimage2D");
        names.put(36964, (Object)"uimage3D");
        names.put(36965, (Object)"uimage2DRect");
        names.put(36966, (Object)"uimageCube");
        names.put(36967, (Object)"uimageBuffer");
        names.put(36968, (Object)"uimage1DArray");
        names.put(36969, (Object)"uimage2DArray");
        names.put(36971, (Object)"uimage2DMS");
        names.put(36972, (Object)"uimage2DMSArray");
        names.put(37595, (Object)"atomic_uint");
        NAMES = Int2ObjectMaps.unmodifiable((Int2ObjectMap)names);
    }

    public record Uniform(String name, int location, int offset, int type, int arrayLength) {
    }

    public record UniformBlock(String name, int index, int size, Uniform[] fields) {
    }

    public record StorageBlock(String name, int index, int size, int arrayStride, Uniform[] fields) {
        public boolean array() {
            return this.arrayStride > 0;
        }
    }
}

