/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.shader;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;

public class ShaderPreDefinitions {
    private final Set<Consumer<String>> definitionCallbacks = new HashSet<Consumer<String>>();
    private final Map<String, String> definitions = new HashMap<String, String>();
    private final Map<String, String> definitionsView = Collections.unmodifiableMap(this.definitions);
    private final Map<String, String> staticDefinitions = new HashMap<String, String>();
    private final Map<String, String> staticDefinitionsView = Collections.unmodifiableMap(this.staticDefinitions);

    public void addListener(Consumer<String> definitionCallback) {
        this.definitionCallbacks.add(definitionCallback);
    }

    public void set(String name) {
        this.set(name, null);
    }

    public void set(String name, String value) {
        String previous = this.definitions.put(name, value != null ? value : "");
        if (!Objects.equals(previous, value)) {
            this.definitionCallbacks.forEach(callback -> callback.accept(name));
        }
    }

    public void setStatic(String name) {
        this.setStatic(name, null);
    }

    public void setStatic(String name, @Nullable String value) {
        this.staticDefinitions.put(name, value != null ? value : "");
    }

    public void remove(String name) {
        if (this.definitions.remove(name) != null) {
            this.definitionCallbacks.forEach(callback -> callback.accept(name));
        }
    }

    @Nullable
    public String getDefinition(String name) {
        return this.definitions.get(name);
    }

    public Map<String, String> getDefinitions() {
        return this.definitionsView;
    }

    public Map<String, String> getStaticDefinitions() {
        return this.staticDefinitionsView;
    }
}

