/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.rendertype;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import foundry.veil.Veil;
import foundry.veil.api.client.render.VeilRenderBridge;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.rendertype.VeilRenderTypeAccessor;
import foundry.veil.api.client.render.vertex.VeilVertexFormat;
import foundry.veil.impl.client.render.pipeline.CullFaceShard;
import foundry.veil.mixin.rendertype.accessor.RenderStateShardAccessor;
import foundry.veil.mixin.rendertype.accessor.RenderTypeAccessor;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_156;
import net.minecraft.class_1921;
import net.minecraft.class_286;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_4668;
import net.minecraft.class_5944;
import net.minecraft.class_9801;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public final class VeilRenderType
extends class_1921 {
    public static final class_4668.class_4672 NEVER_DEPTH_TEST = new class_4668.class_4672("never", 512);
    public static final class_4668.class_4672 LESS_DEPTH_TEST = new class_4668.class_4672("<", 513);
    public static final class_4668.class_4672 NOTEQUAL_DEPTH_TEST = new class_4668.class_4672("<", 517);
    public static final class_4668.class_4672 GEQUAL_DEPTH_TEST = new class_4668.class_4672(">=", 518);
    public static final class_4668 CULL_FRONT = new CullFaceShard(1028);
    public static final class_4668 CULL_BACK = new CullFaceShard(1029);
    public static final class_4668 CULL_FRONT_AND_BACK = new CullFaceShard(1032);
    public static final class_4668.class_4686 NO_WRITE = new class_4668.class_4686(false, false);
    private static final EnumMap<GlStateManager.class_1030, class_4668.class_8559> COLOR_LOGIC_SHARDS = new EnumMap(GlStateManager.class_1030.class);
    private static final class_4668.class_5942 PARTICLE;
    private static final class_4668.class_5942 PARTICLE_ADDITIVE;
    private static final BiFunction<class_2960, Boolean, class_1921> QUASAR_PARTICLE;
    private static final Function<class_2960, class_1921> QUASAR_TRAIL;

    public static class_1921 quasarParticle(class_2960 texture, boolean additive) {
        return QUASAR_PARTICLE.apply(texture, additive);
    }

    public static class_1921 quasarTrail(class_2960 texture) {
        return QUASAR_TRAIL.apply(texture);
    }

    public static class_4668.class_4685 noTransparencyShard() {
        return class_4668.field_21364;
    }

    public static class_4668.class_4685 additiveTransparencyShard() {
        return class_4668.field_21366;
    }

    public static class_4668.class_4685 lightningTransparencyShard() {
        return class_4668.field_21367;
    }

    public static class_4668.class_4685 glintTransparencyShard() {
        return class_4668.field_21368;
    }

    public static class_4668.class_4685 crumblingTransparencyShard() {
        return class_4668.field_21369;
    }

    public static class_4668.class_4685 translucentTransparencyShard() {
        return class_4668.field_21370;
    }

    public static class_4668.class_4672 noDepthTestShard() {
        return class_4668.field_21346;
    }

    public static class_4668.class_4672 equalDepthTestShard() {
        return class_4668.field_21347;
    }

    public static class_4668.class_4672 lequalDepthTestShard() {
        return class_4668.field_21348;
    }

    public static class_4668.class_4672 greaterDepthTestShard() {
        return class_4668.field_44814;
    }

    public static class_4668.class_4671 cullShard() {
        return class_4668.field_21344;
    }

    public static class_4668.class_4671 noCullShard() {
        return class_4668.field_21345;
    }

    public static class_4668.class_4676 lightmap() {
        return class_4668.field_21383;
    }

    public static class_4668.class_4676 noLightmap() {
        return class_4668.field_21384;
    }

    public static class_4668.class_4679 overlay() {
        return class_4668.field_21385;
    }

    public static class_4668.class_4679 noOverlay() {
        return class_4668.field_21386;
    }

    public static class_4668.class_4675 noLayering() {
        return class_4668.field_21352;
    }

    public static class_4668.class_4675 polygonOffsetLayering() {
        return class_4668.field_21353;
    }

    public static class_4668.class_4675 viewOffsetLayering() {
        return class_4668.field_22241;
    }

    public static class_4668.class_4686 colorDepthWriteShard() {
        return class_4668.field_21349;
    }

    public static class_4668.class_4686 colorWriteShard() {
        return class_4668.field_21350;
    }

    public static class_4668.class_4686 depthWriteShard() {
        return class_4668.field_21351;
    }

    public static class_4668.class_8559 colorLogicStateShard(GlStateManager.class_1030 op) {
        return COLOR_LOGIC_SHARDS.get(op);
    }

    @Nullable
    public static class_1921 get(class_2960 id, Object ... params) {
        return VeilRenderSystem.renderer().getDynamicRenderTypeManager().get(id, params);
    }

    @Contract(value="_->new", pure=true)
    public static RenderTypeWrapper getWrapper(class_2960 id) {
        return new RenderTypeWrapper(id);
    }

    public static String getName(class_4668 shard) {
        return ((RenderStateShardAccessor)shard).getName();
    }

    public static VeilRenderTypeAccessor getShards(class_1921 renderType) {
        if (!(renderType instanceof class_1921.class_4687)) {
            throw new IllegalArgumentException("Expected composite render type to be an instance of " + class_1921.class_4687.class.getName() + ", but was " + String.valueOf(renderType.getClass()));
        }
        class_1921.class_4687 compositeRenderType = (class_1921.class_4687)renderType;
        return (VeilRenderTypeAccessor)compositeRenderType.method_35784();
    }

    public static class_1921 layered(class_1921 ... layers) {
        if (layers.length == 0) {
            throw new IllegalArgumentException("At least 1 render type must be specified");
        }
        if (layers.length == 1) {
            return layers[0];
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        class_293 format = layers[0].method_23031();
        class_293.class_5596 mode = layers[0].method_23033();
        int bufferSize = layers[0].method_22722();
        boolean sortOnUpload = ((RenderTypeAccessor)layers[0]).isSortOnUpload();
        for (int i = 1; i < layers.length; ++i) {
            class_1921 layer = layers[i];
            if (!layer.method_23031().equals((Object)format)) {
                throw new IllegalArgumentException("Expected " + String.valueOf(layer) + " to use " + String.valueOf(format) + ", but was " + String.valueOf(layer.method_23031()));
            }
            if (!layer.method_23033().equals((Object)mode)) {
                throw new IllegalArgumentException("Expected " + String.valueOf(layer) + " to use " + String.valueOf(mode) + ", but was " + String.valueOf(layer.method_23033()));
            }
            bufferSize = Math.max(bufferSize, layer.method_22722());
            if (((RenderTypeAccessor)layer).isSortOnUpload()) {
                sortOnUpload = true;
            }
            builder.add((Object)layer);
        }
        return new LayeredRenderType(layers[0], (List<class_1921>)builder.build(), "LayeredRenderType[" + Arrays.stream(layers).map(VeilRenderType::getName).collect(Collectors.joining(", ")) + "]", bufferSize, sortOnUpload);
    }

    private VeilRenderType(String $$0, class_293 $$1, class_293.class_5596 $$2, int $$3, boolean $$4, boolean $$5, Runnable $$6, Runnable $$7) {
        super($$0, $$1, $$2, $$3, $$4, $$5, $$6, $$7);
    }

    static {
        for (GlStateManager.class_1030 logicOp : GlStateManager.class_1030.values()) {
            COLOR_LOGIC_SHARDS.put(logicOp, new class_4668.class_8559(logicOp.name().toLowerCase(Locale.ROOT), () -> {
                RenderSystem.enableColorLogicOp();
                RenderSystem.logicOp((GlStateManager.class_1030)logicOp);
            }, RenderSystem::disableColorLogicOp));
        }
        PARTICLE = VeilRenderBridge.shaderState(Veil.veilPath("quasar/particle"));
        PARTICLE_ADDITIVE = VeilRenderBridge.shaderState(Veil.veilPath("quasar/particle_additive"));
        QUASAR_PARTICLE = class_156.method_34865((texture, additive) -> {
            class_1921.class_4688 state = class_1921.class_4688.method_23598().method_34578(additive != false ? PARTICLE_ADDITIVE : PARTICLE).method_34577((class_4668.class_5939)new class_4668.class_4683(texture, false, false)).method_23615(additive != false ? field_21366 : field_21370).method_23608(field_21383).method_23616(field_21350).method_23617(false);
            return VeilRenderType.method_24049((String)"veil:quasar_particle", (class_293)VeilVertexFormat.QUASAR_PARTICLE, (class_293.class_5596)class_293.class_5596.field_27382, (int)786432, (boolean)false, (additive == false ? 1 : 0) != 0, (class_1921.class_4688)state);
        });
        QUASAR_TRAIL = class_156.method_34866(texture -> {
            class_1921.class_4688 state = class_1921.class_4688.method_23598().method_34578(field_38344).method_34577((class_4668.class_5939)new class_4668.class_4683(texture, false, false)).method_23615(field_21366).method_23616(field_21350).method_23603(field_21345).method_23617(false);
            return class_1921.method_24049((String)"veil:quasar_trail", (class_293)class_290.field_1580, (class_293.class_5596)class_293.class_5596.field_27380, (int)1536, (boolean)false, (boolean)false, (class_1921.class_4688)state);
        });
    }

    public static class RenderTypeWrapper
    extends class_1921 {
        private static final Object[] NO_PARAMS = new Object[0];
        private final class_2960 id;
        private Object[] params;

        private RenderTypeWrapper(class_2960 id) {
            super(id.toString(), class_290.field_1592, class_293.class_5596.field_27382, 0, false, false, () -> {}, () -> {});
            this.id = id;
            this.params = NO_PARAMS;
        }

        public void method_23516() {
            class_1921 renderType = this.get();
            if (renderType != null) {
                renderType.method_23516();
            }
        }

        public void method_23518() {
            class_1921 renderType = this.get();
            if (renderType != null) {
                renderType.method_23518();
            }
        }

        public void method_60895(@NotNull class_9801 meshData) {
            class_1921 renderType = this.get();
            if (renderType != null) {
                renderType.method_60895(meshData);
            }
        }

        public int method_22722() {
            class_1921 renderType = this.get();
            return renderType != null ? renderType.method_22722() : 1536;
        }

        @NotNull
        public class_293 method_23031() {
            class_1921 renderType = this.get();
            return renderType != null ? renderType.method_23031() : class_290.field_1592;
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
        @NotNull class_293.class_5596 method_23033() {
            class_1921 renderType = this.get();
            return renderType != null ? renderType.method_23033() : class_293.class_5596.field_27382;
        }

        @NotNull
        public Optional<class_1921> method_23289() {
            class_1921 renderType = this.get();
            return renderType != null ? renderType.method_23289() : Optional.empty();
        }

        public boolean method_24295() {
            class_1921 renderType = this.get();
            return renderType != null && renderType.method_24295();
        }

        public boolean method_23037() {
            class_1921 renderType = this.get();
            return renderType != null && renderType.method_23037();
        }

        public boolean method_43332() {
            class_1921 renderType = this.get();
            return renderType != null && renderType.method_43332();
        }

        public boolean method_60894() {
            class_1921 renderType = this.get();
            return renderType != null && renderType.method_60894();
        }

        public void setParams(Object ... params) {
            if (params.length == 0) {
                this.params = NO_PARAMS;
            } else if (this.params.length == params.length) {
                System.arraycopy(params, 0, this.params, 0, params.length);
            } else {
                this.params = Arrays.copyOf(params, params.length);
            }
        }

        @Nullable
        public class_1921 get() {
            return VeilRenderSystem.renderer().getDynamicRenderTypeManager().get(this.id, this.params);
        }
    }

    public static class LayeredRenderType
    extends class_1921 {
        private final List<class_1921> layers;

        private LayeredRenderType(class_1921 defaultValue, List<class_1921> layers, String name, int bufferSize, boolean sortOnUpload) {
            super(name, defaultValue.method_23031(), defaultValue.method_23033(), bufferSize, defaultValue.method_23037(), sortOnUpload, () -> ((class_1921)defaultValue).method_23516(), () -> ((class_1921)defaultValue).method_23518());
            this.layers = layers;
        }

        public void method_60895(@NotNull class_9801 meshData) {
            super.method_60895(meshData);
            if (class_286.field_38982 != null) {
                class_5944 shader = RenderSystem.getShader();
                if (shader == null) {
                    return;
                }
                Matrix4f modelViewMatrix = RenderSystem.getModelViewMatrix();
                Matrix4f projectionMatrix = RenderSystem.getProjectionMatrix();
                for (class_1921 layer : this.layers) {
                    layer.method_23516();
                    class_286.field_38982.method_34427(modelViewMatrix, projectionMatrix, shader);
                    layer.method_23518();
                }
            }
        }

        public List<class_1921> getLayers() {
            return this.layers;
        }
    }
}

