/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.light.data;

import foundry.veil.api.client.color.Colorc;
import foundry.veil.api.client.editor.EditorAttributeProvider;
import foundry.veil.api.client.registry.LightTypeRegistry;
import foundry.veil.api.client.render.CullFrustum;
import foundry.veil.api.client.render.light.IndirectLightData;
import foundry.veil.api.client.render.light.data.LightData;
import imgui.ImGui;
import java.nio.ByteBuffer;
import net.minecraft.class_243;
import net.minecraft.class_4184;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3fc;

public class PointLightData
extends LightData
implements IndirectLightData,
EditorAttributeProvider {
    protected final Vector3d position = new Vector3d();
    protected float radius = 1.0f;

    @Override
    public float getRadius() {
        return this.radius;
    }

    @Override
    public Vector3dc getPosition() {
        return this.position;
    }

    public PointLightData setPosition(Vector3dc pos) {
        this.position.set(pos);
        return this;
    }

    public PointLightData setPosition(double x, double y, double z) {
        this.position.set(x, y, z);
        return this;
    }

    public PointLightData setRadius(float radius) {
        this.radius = radius;
        return this;
    }

    @Override
    public PointLightData setColor(Vector3fc color) {
        super.setColor(color);
        return this;
    }

    @Override
    public PointLightData setColor(Colorc color) {
        this.setColor(color.red(), color.green(), color.blue());
        return this;
    }

    @Override
    public PointLightData setColor(float red, float green, float blue) {
        super.setColor(red, green, blue);
        return this;
    }

    @Override
    public PointLightData setColor(int color) {
        super.setColor(color);
        return this;
    }

    @Override
    public PointLightData setBrightness(float brightness) {
        super.setBrightness(brightness);
        return this;
    }

    @Override
    public boolean isVisible(CullFrustum frustum) {
        return frustum.testSphere((Vector3dc)this.position, this.radius * 1.4f);
    }

    @Override
    public void store(ByteBuffer buffer) {
        this.position.getf(buffer.position(), buffer);
        buffer.position(buffer.position() + 12);
        buffer.putFloat(this.color.red() * this.brightness);
        buffer.putFloat(this.color.green() * this.brightness);
        buffer.putFloat(this.color.blue() * this.brightness);
        buffer.putFloat(this.radius);
    }

    @Override
    public PointLightData setTo(class_4184 camera) {
        class_243 pos = camera.method_19326();
        this.position.set(pos.field_1352, pos.field_1351, pos.field_1350);
        return this;
    }

    @Override
    public LightTypeRegistry.LightType<?> getType() {
        return LightTypeRegistry.POINT.get();
    }

    @Override
    public void renderImGuiAttributes() {
        double[] editX = new double[]{this.position.x()};
        double[] editY = new double[]{this.position.y()};
        double[] editZ = new double[]{this.position.z()};
        float[] editRadius = new float[]{this.radius};
        float totalWidth = ImGui.calcItemWidth();
        ImGui.pushItemWidth((float)(totalWidth / 3.0f - ImGui.getStyle().getItemInnerSpacingX() * 0.58f));
        if (ImGui.dragScalar((String)"##x", (double[])editX, (float)0.02f)) {
            this.position.x = editX[0];
        }
        ImGui.sameLine((float)0.0f, (float)ImGui.getStyle().getItemInnerSpacingX());
        if (ImGui.dragScalar((String)"##y", (double[])editY, (float)0.02f)) {
            this.position.y = editY[0];
        }
        ImGui.sameLine((float)0.0f, (float)ImGui.getStyle().getItemInnerSpacingX());
        if (ImGui.dragScalar((String)"##z", (double[])editZ, (float)0.02f)) {
            this.position.z = editZ[0];
        }
        ImGui.popItemWidth();
        ImGui.sameLine((float)0.0f, (float)ImGui.getStyle().getItemInnerSpacingX());
        ImGui.text((String)"position");
        if (ImGui.dragScalar((String)"radius", (float[])editRadius, (float)0.02f, (float)0.0f)) {
            this.setRadius(editRadius[0]);
        }
    }
}

