/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.light.data;

import foundry.veil.api.client.color.Colorc;
import foundry.veil.api.client.editor.EditorAttributeProvider;
import foundry.veil.api.client.registry.LightTypeRegistry;
import foundry.veil.api.client.render.CullFrustum;
import foundry.veil.api.client.render.light.InstancedLightData;
import foundry.veil.api.client.render.light.data.LightData;
import imgui.ImGui;
import java.nio.ByteBuffer;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import org.joml.Matrix4d;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector2f;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class AreaLightData
extends LightData
implements InstancedLightData,
EditorAttributeProvider {
    private static final float MAX_ANGLE_SIZE = 10430.219f;
    protected final Vector3d position;
    protected final Quaternionf orientation;
    private final Matrix4d matrix = new Matrix4d();
    protected final Vector2f size;
    protected float angle;
    protected float distance = 1.0f;

    public AreaLightData() {
        this.position = new Vector3d();
        this.orientation = new Quaternionf();
        this.size = new Vector2f(1.0f, 1.0f);
        this.angle = (float)Math.toRadians(45.0);
    }

    protected void updateMatrix() {
        Quaternionf orientation = this.getOrientation();
        this.matrix.rotation((Quaternionfc)orientation).translate((Vector3dc)this.position);
    }

    @Override
    public LightTypeRegistry.LightType<?> getType() {
        return LightTypeRegistry.AREA.get();
    }

    public Vector3d getPosition() {
        return this.position;
    }

    public Quaternionf getOrientation() {
        return this.orientation;
    }

    public Vector2f getSize() {
        return this.size;
    }

    public float getAngle() {
        return this.angle;
    }

    public float getDistance() {
        return this.distance;
    }

    public AreaLightData setSize(double x, double y) {
        this.size.set(x, y);
        return this;
    }

    public AreaLightData setAngle(float angle) {
        this.angle = angle;
        return this;
    }

    public AreaLightData setDistance(float distance) {
        this.distance = distance;
        return this;
    }

    @Override
    public AreaLightData setColor(Vector3fc color) {
        super.setColor(color);
        return this;
    }

    @Override
    public AreaLightData setColor(Colorc color) {
        this.setColor(color.red(), color.green(), color.blue());
        return this;
    }

    @Override
    public AreaLightData setColor(float red, float green, float blue) {
        super.setColor(red, green, blue);
        return this;
    }

    @Override
    public AreaLightData setColor(int color) {
        super.setColor(color);
        return this;
    }

    @Override
    public AreaLightData setBrightness(float brightness) {
        super.setBrightness(brightness);
        return this;
    }

    @Override
    public void store(ByteBuffer buffer) {
        this.matrix.identity().rotation((Quaternionfc)this.orientation).translate((Vector3dc)this.position).getFloats(buffer.position(), buffer);
        buffer.position(buffer.position() + 64);
        buffer.putFloat(this.color.red() * this.brightness);
        buffer.putFloat(this.color.green() * this.brightness);
        buffer.putFloat(this.color.blue() * this.brightness);
        this.size.get(buffer.position(), buffer);
        buffer.position(buffer.position() + 8);
        buffer.putShort((short)class_3532.method_15340((int)((int)(this.angle * 10430.219f)), (int)0, (int)65535));
        buffer.putFloat(this.distance);
    }

    @Override
    public boolean isVisible(CullFrustum frustum) {
        float radius = Math.max(this.size.x, this.size.y) + this.distance;
        return frustum.testAab(this.position.x - (double)radius, this.position.y - (double)radius, this.position.z - (double)radius, this.position.x + (double)radius, this.position.y + (double)radius, this.position.z + (double)radius);
    }

    @Override
    public LightData setTo(class_4184 camera) {
        class_243 pos = camera.method_19326();
        this.position.set(pos.field_1352, pos.field_1351, pos.field_1350);
        this.orientation.identity().lookAlong((Vector3fc)camera.method_19335().mul(-1.0f), (Vector3fc)camera.method_19336());
        return this;
    }

    @Override
    public void renderImGuiAttributes() {
        Vector3f orientationAngles = this.orientation.normalize().getEulerAnglesXYZ(new Vector3f());
        float[] editSize = new float[]{this.size.x(), this.size.y()};
        double[] editX = new double[]{this.position.x()};
        double[] editY = new double[]{this.position.y()};
        double[] editZ = new double[]{this.position.z()};
        float[] editXRot = new float[]{orientationAngles.x()};
        float[] editYRot = new float[]{orientationAngles.y()};
        float[] editZRot = new float[]{orientationAngles.z()};
        float[] editAngle = new float[]{this.angle};
        float[] editDistance = new float[]{this.distance};
        if (ImGui.dragFloat2((String)"size", (float[])editSize, (float)0.02f, (float)1.0E-4f)) {
            this.setSize(editSize[0], editSize[1]);
        }
        float totalWidth = ImGui.calcItemWidth();
        ImGui.pushItemWidth((float)(totalWidth / 3.0f - ImGui.getStyle().getItemInnerSpacingX() * 0.58f));
        if (ImGui.dragScalar((String)"##x", (double[])editX, (float)0.02f)) {
            this.position.x = editX[0];
        }
        ImGui.sameLine((float)0.0f, (float)ImGui.getStyle().getItemInnerSpacingX());
        if (ImGui.dragScalar((String)"##y", (double[])editY, (float)0.02f)) {
            this.position.y = editY[0];
        }
        ImGui.sameLine((float)0.0f, (float)ImGui.getStyle().getItemInnerSpacingX());
        if (ImGui.dragScalar((String)"##z", (double[])editZ, (float)0.02f)) {
            this.position.z = editZ[0];
        }
        ImGui.popItemWidth();
        ImGui.sameLine((float)0.0f, (float)ImGui.getStyle().getItemInnerSpacingX());
        ImGui.text((String)"position");
        ImGui.pushItemWidth((float)(totalWidth / 3.0f - ImGui.getStyle().getItemInnerSpacingX() * 0.58f));
        if (ImGui.sliderAngle((String)"##xrot", (float[])editXRot)) {
            this.orientation.identity().rotationXYZ(editXRot[0], orientationAngles.y(), orientationAngles.z());
        }
        ImGui.sameLine((float)0.0f, (float)ImGui.getStyle().getItemInnerSpacingX());
        if (ImGui.sliderAngle((String)"##yrot", (float[])editYRot)) {
            this.orientation.identity().rotationXYZ(orientationAngles.x(), editYRot[0], orientationAngles.z());
        }
        ImGui.sameLine((float)0.0f, (float)ImGui.getStyle().getItemInnerSpacingX());
        if (ImGui.sliderAngle((String)"##zrot", (float[])editZRot)) {
            this.orientation.identity().rotationXYZ(orientationAngles.x(), orientationAngles.y(), editZRot[0]);
        }
        ImGui.popItemWidth();
        ImGui.sameLine((float)0.0f, (float)ImGui.getStyle().getItemInnerSpacingX());
        ImGui.text((String)"orientation");
        if (ImGui.sliderAngle((String)"##angle", (float[])editAngle, (float)0.1f, (float)180.0f, (String)"%.1f")) {
            this.setAngle(editAngle[0]);
        }
        ImGui.sameLine((float)0.0f, (float)ImGui.getStyle().getItemInnerSpacingX());
        ImGui.text((String)"angle");
        if (ImGui.dragScalar((String)"distance", (float[])editDistance, (float)0.02f, (float)0.0f)) {
            this.setDistance(editDistance[0]);
        }
    }
}

