/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.ext;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import foundry.veil.Veil;
import java.nio.IntBuffer;
import org.lwjgl.opengl.ARBMultiBind;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL32C;
import org.lwjgl.opengl.GL33C;
import org.lwjgl.opengl.GL45C;
import org.lwjgl.opengl.GLCapabilities;

public enum VeilMultiBind {
    LEGACY{

        @Override
        public void bindTextures(int first, IntBuffer textures) {
            int activeTexture = GlStateManager._getActiveTexture();
            for (int i = 0; i < textures.limit(); ++i) {
                RenderSystem.activeTexture((int)(33984 + first + i));
                int texture = textures.get(i);
                int target = VeilMultiBind.getTarget(texture);
                if (target == 3553 && first + i < 12) {
                    RenderSystem.bindTexture((int)texture);
                    continue;
                }
                GL32C.glBindTexture((int)target, (int)texture);
            }
            RenderSystem.activeTexture((int)activeTexture);
        }

        @Override
        public void bindTextures(int first, int ... textures) {
            int activeTexture = GlStateManager._getActiveTexture();
            for (int i = 0; i < textures.length; ++i) {
                RenderSystem.activeTexture((int)(33984 + first + i));
                int texture = textures[i];
                int target = VeilMultiBind.getTarget(texture);
                if (target == 3553 && first + i < 12) {
                    RenderSystem.bindTexture((int)texture);
                    continue;
                }
                GL32C.glBindTexture((int)target, (int)texture);
            }
            RenderSystem.activeTexture((int)activeTexture);
        }

        @Override
        public void bindSamplers(int first, IntBuffer samplers) {
            for (int i = 0; i < samplers.limit(); ++i) {
                GL33C.glBindSampler((int)(first + i), (int)samplers.get(i));
            }
        }

        @Override
        public void bindSamplers(int first, int ... samplers) {
            for (int i = 0; i < samplers.length; ++i) {
                GL33C.glBindSampler((int)(first + i), (int)samplers[i]);
            }
        }
    }
    ,
    SUPPORTED{

        @Override
        public void bindTextures(int first, IntBuffer textures) {
            int invalidCount = Math.min(12 - first, textures.limit());
            for (int i = first; i < invalidCount; ++i) {
                int texture = textures.get(i - first);
                int target = VeilMultiBind.getTarget(texture);
                if (target != 3553) continue;
                GlStateManager.TEXTURES[i].field_5167 = texture;
            }
            ARBMultiBind.glBindTextures((int)first, (IntBuffer)textures);
        }

        @Override
        public void bindTextures(int first, int ... textures) {
            int invalidCount = Math.min(12 - first, textures.length);
            for (int i = first; i < invalidCount; ++i) {
                int texture = textures[i - first];
                int target = VeilMultiBind.getTarget(texture);
                if (target != 3553) continue;
                GlStateManager.TEXTURES[i].field_5167 = texture;
            }
            ARBMultiBind.glBindTextures((int)first, (int[])textures);
        }

        @Override
        public void bindSamplers(int first, IntBuffer samplers) {
            ARBMultiBind.glBindSamplers((int)first, (IntBuffer)samplers);
        }

        @Override
        public void bindSamplers(int first, int ... samplers) {
            ARBMultiBind.glBindSamplers((int)first, (int[])samplers);
        }
    };

    private static final int[] CHECK_BINDINGS;
    private static final int[] CHECK_TARGETS;
    private static VeilMultiBind multiBind;

    private static int getTarget(int texture) {
        GLCapabilities caps = GL.getCapabilities();
        if (caps.glGetTextureParameteriv != 0L) {
            return GL45C.glGetTextureParameteri((int)texture, (int)4102);
        }
        while (GL32C.glGetError() != 0) {
        }
        for (int i = 0; i < CHECK_TARGETS.length; ++i) {
            int target = CHECK_TARGETS[i];
            int old = GL32C.glGetInteger((int)CHECK_BINDINGS[i]);
            GL32C.glBindTexture((int)target, (int)texture);
            if (GL32C.glGetError() == 0) {
                GL32C.glBindTexture((int)target, (int)old);
                return target;
            }
            GL32C.glBindTexture((int)target, (int)old);
        }
        return 3553;
    }

    public abstract void bindTextures(int var1, IntBuffer var2);

    public abstract void bindTextures(int var1, int ... var2);

    public abstract void bindSamplers(int var1, IntBuffer var2);

    public abstract void bindSamplers(int var1, int ... var2);

    public static VeilMultiBind get() {
        if (multiBind == null) {
            GLCapabilities caps = GL.getCapabilities();
            if (caps.OpenGL44 || caps.GL_ARB_multi_bind) {
                multiBind = SUPPORTED;
                Veil.LOGGER.info("Multi-Bind supported, using core");
            } else {
                multiBind = LEGACY;
                Veil.LOGGER.info("Multi-Bind unsupported, using legacy");
            }
        }
        return multiBind;
    }

    static {
        CHECK_BINDINGS = new int[]{32873, 35869, 34068, 32872, 32874, 34038, 35884, 35868, 37124, 37125};
        CHECK_TARGETS = new int[]{3553, 35866, 34067, 3552, 32879, 34037, 35882, 35864, 37120, 37122};
    }
}

