/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.dynamicbuffer;

import foundry.veil.api.client.render.dynamicbuffer.DynamicBufferType;
import org.jetbrains.annotations.ApiStatus;

public class DynamicBuffersChange {
    private final int previousBuffers;
    private final int newBuffers;

    @ApiStatus.Internal
    public DynamicBuffersChange(int previousBuffers, int newBuffers) {
        this.previousBuffers = previousBuffers;
        this.newBuffers = newBuffers;
    }

    public DynamicBufferType[] getPreviouslyEnabledBuffers() {
        return DynamicBufferType.decode(this.previousBuffers);
    }

    public DynamicBufferType[] getEnabledBuffers() {
        return DynamicBufferType.decode(this.newBuffers);
    }

    public int getPreviouslyEnabledBuffersMask() {
        return this.previousBuffers;
    }

    public int getEnabledBuffersMask() {
        return this.newBuffers;
    }

    public boolean hasChanged(DynamicBufferType buffer) {
        int mask = buffer.getMask();
        return (this.newBuffers & mask ^ this.previousBuffers & mask) != 0;
    }

    public boolean isEnabled(DynamicBufferType buffer) {
        return (this.newBuffers & buffer.getMask()) != 0;
    }

    public boolean wasPreviouslyEnabled(DynamicBufferType buffer) {
        return (this.previousBuffers & buffer.getMask()) != 0;
    }
}

