/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.registry;

import foundry.veil.api.client.render.rendertype.VeilRenderType;
import foundry.veil.ext.CompositeStateExtension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.Predicate;
import net.minecraft.class_1921;
import net.minecraft.class_4668;
import org.jetbrains.annotations.ApiStatus;

public final class RenderTypeShardRegistry {
    private static final Map<String, List<class_4668>> SHARDS = new HashMap<String, List<class_4668>>();
    private static final Set<GenericShard> GENERIC_SHARDS = new HashSet<GenericShard>();
    private static final Map<String, class_1921.class_4687> CREATED_RENDER_TYPES = new WeakHashMap<String, class_1921.class_4687>();

    private RenderTypeShardRegistry() {
    }

    public static synchronized void addShard(class_1921 renderType, class_4668 ... shards) {
        if (shards.length == 0) {
            return;
        }
        if (!(renderType instanceof class_1921.class_4687)) {
            throw new IllegalArgumentException("RenderType must be CompositeRenderType");
        }
        class_1921.class_4687 compositeRenderType = (class_1921.class_4687)renderType;
        ((CompositeStateExtension)compositeRenderType.method_35784()).veil$addShards(Arrays.asList(shards));
    }

    public static synchronized void addShard(String name, class_4668 ... shards) {
        if (shards.length == 0) {
            throw new IllegalArgumentException("No shards provided");
        }
        List<class_4668> newShards = Arrays.asList(shards);
        SHARDS.computeIfAbsent(name, unused -> new ArrayList()).addAll(newShards);
        for (class_1921.class_4687 renderType : CREATED_RENDER_TYPES.values()) {
            if (!name.equals(VeilRenderType.getName((class_4668)renderType))) continue;
            ((CompositeStateExtension)renderType.method_35784()).veil$addShards(newShards);
        }
    }

    public static synchronized void addGenericShard(Predicate<class_1921.class_4687> filter, class_4668 ... shards) {
        if (shards.length == 0) {
            throw new IllegalArgumentException("No shards provided");
        }
        GENERIC_SHARDS.add(new GenericShard(filter, shards));
        for (class_1921.class_4687 renderType : CREATED_RENDER_TYPES.values()) {
            if (!filter.test(renderType)) continue;
            ((CompositeStateExtension)renderType.method_35784()).veil$addShards(Arrays.asList(shards));
        }
    }

    @ApiStatus.Internal
    public static void inject(class_1921.class_4687 renderType) {
        List<class_4668> shards = SHARDS.get(VeilRenderType.getName((class_4668)renderType));
        if (shards != null) {
            shards = new ArrayList<class_4668>(shards);
        }
        for (GenericShard stage : GENERIC_SHARDS) {
            if (!stage.filter.test(renderType)) continue;
            if (shards == null) {
                shards = new ArrayList<class_4668>(Arrays.asList(stage.shards));
                continue;
            }
            shards.addAll(Arrays.asList(stage.shards));
        }
        if (shards != null) {
            ((CompositeStateExtension)renderType.method_35784()).veil$addShards(shards);
        }
        CREATED_RENDER_TYPES.put(class_1921.class_4687.class.getName() + "@" + Integer.toHexString(renderType.hashCode()), renderType);
    }

    private record GenericShard(Predicate<class_1921.class_4687> filter, class_4668[] shards) {
    }
}

