/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.necromancer.render;

import foundry.veil.api.client.necromancer.Skeleton;
import foundry.veil.api.client.necromancer.SkeletonParent;
import foundry.veil.api.client.necromancer.animation.Animator;
import foundry.veil.api.client.necromancer.render.NecromancerEntityRenderLayer;
import foundry.veil.api.client.necromancer.render.NecromancerRenderer;
import foundry.veil.api.client.render.MatrixStack;
import foundry.veil.api.client.render.VeilRenderBridge;
import foundry.veil.impl.client.necromancer.render.NecromancerRenderDispatcher;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5617;
import net.minecraft.class_897;

public abstract class NecromancerEntityRenderer<P extends class_1297, S extends Skeleton>
extends class_897<P> {
    private final List<NecromancerEntityRenderLayer<P, S>> layers;

    protected NecromancerEntityRenderer(class_5617.class_5618 context, float shadowRadius) {
        super(context);
        this.field_4673 = shadowRadius;
        this.layers = new ObjectArrayList();
    }

    public void addLayer(NecromancerEntityRenderLayer<P, S> layer) {
        this.layers.add(layer);
    }

    public final void setupEntity(P parent) {
        S skeleton = this.createSkeleton(parent);
        ((SkeletonParent)parent).setSkeleton(skeleton);
        ((SkeletonParent)parent).setAnimator(this.createAnimator(parent, skeleton));
    }

    public abstract S createSkeleton(P var1);

    public abstract Animator<P, S> createAnimator(P var1, S var2);

    public void method_3936(P parent, float entityYaw, float partialTick, class_4587 poseStack, class_4597 bufferSource, int packedLight) {
        NecromancerRenderer renderer = NecromancerRenderDispatcher.getRenderer();
        this.render(parent, renderer, VeilRenderBridge.create(poseStack), packedLight, partialTick);
        super.method_3936(parent, entityYaw, partialTick, poseStack, (class_4597)renderer, packedLight);
    }

    public void render(P parent, NecromancerRenderer renderer, MatrixStack matrixStack, int packedLight, float partialTicks) {
        Object skeleton = ((SkeletonParent)parent).getSkeleton();
        if (skeleton == null) {
            return;
        }
        matrixStack.matrixPush();
        matrixStack.applyScale(0.0625f);
        for (NecromancerEntityRenderLayer<P, S> layer : this.layers) {
            layer.render(parent, skeleton, renderer, matrixStack, packedLight, partialTicks);
        }
        matrixStack.matrixPop();
    }

    public class_2960 method_3931(P entity) {
        throw new UnsupportedOperationException();
    }
}

