/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.imgui;

import imgui.extension.texteditor.TextEditorLanguageDefinition;
import java.util.HashMap;

public final class VeilLanguageDefinitions {
    private static final TextEditorLanguageDefinition GLSL = VeilLanguageDefinitions.createGlsl();

    private VeilLanguageDefinitions() {
    }

    public static TextEditorLanguageDefinition glsl() {
        return GLSL;
    }

    private static TextEditorLanguageDefinition createGlsl() {
        TextEditorLanguageDefinition definition = new TextEditorLanguageDefinition();
        String[] keywords = new String[]{"const", "uniform", "buffer", "shared", "attribute", "varying", "coherent", "volatile", "restrict", "readonly", "writeonly", "atomic_uint", "layout", "centroid", "flat", "smooth", "noperspective", "patch", "sample", "invariant", "precise", "break", "continue", "do", "for", "while", "switch", "case", "default", "if", "else", "subroutine", "in", "out", "inout", "int", "void", "bool", "true", "false", "float", "double", "discard", "return", "vec2", "vec3", "vec4", "ivec2", "ivec3", "ivec4", "bvec2", "bvec3", "bvec4", "uint", "uvec2", "uvec3", "uvec4", "dvec2", "dvec3", "dvec4", "mat2", "mat3", "mat4", "mat2x2", "mat2x3", "mat2x4", "mat3x2", "mat3x3", "mat3x4", "mat4x2", "mat4x3", "mat4x4", "dmat2", "dmat3", "dmat4", "dmat2x2", "dmat2x3", "dmat2x4", "dmat3x2", "dmat3x3", "dmat3x4", "dmat4x2", "dmat4x3", "dmat4x4", "lowp", "mediump", "highp", "precision", "sampler1D", "sampler1DShadow", "sampler1DArray", "sampler1DArrayShadow", "isampler1D", "isampler1DArray", "usampler1D", "usampler1DArray", "sampler2D", "sampler2DShadow", "sampler2DArray", "sampler2DArrayShadow", "isampler2D", "isampler2DArray", "usampler2D", "usampler2DArray", "sampler2DRect", "sampler2DRectShadow", "isampler2DRect", "usampler2DRect", "sampler2DMS", "isampler2DMS", "usampler2DMS", "sampler2DMSArray", "isampler2DMSArray", "usampler2DMSArray", "sampler3D", "isampler3D", "usampler3D", "samplerCube", "samplerCubeShadow", "isamplerCube", "usamplerCube", "samplerCubeArray", "samplerCubeArrayShadow", "isamplerCubeArray", "usamplerCubeArray", "samplerBuffer", "isamplerBuffer", "usamplerBuffer", "image1D", "iimage1D", "uimage1D", "image1DArray", "iimage1DArray", "uimage1DArray", "image2D", "iimage2D", "uimage2D", "image2DArray", "iimage2DArray", "uimage2DArray", "image2DRect", "iimage2DRect", "uimage2DRect", "image2DMS", "iimage2DMS", "uimage2DMS", "image2DMSArray", "iimage2DMSArray", "uimage2DMSArray", "image3D", "iimage3D", "uimage3D", "imageCube", "iimageCube", "uimageCube", "imageCubeArray", "iimageCubeArray", "uimageCubeArray", "imageBuffer", "iimageBuffer", "uimageBuffer", "struct", "texture1D", "texture1DArray", "itexture1D", "itexture1DArray", "utexture1D", "utexture1DArray", "texture2D", "texture2DArray", "itexture2D", "itexture2DArray", "utexture2D", "utexture2DArray", "texture2DRect", "itexture2DRect", "utexture2DRect", "texture2DMS", "itexture2DMS", "utexture2DMS", "texture2DMSArray", "itexture2DMSArray", "utexture2DMSArray", "texture3D", "itexture3D", "utexture3D", "textureCube", "itextureCube", "utextureCube", "textureCubeArray", "itextureCubeArray", "utextureCubeArray", "textureBuffer", "itextureBuffer", "utextureBuffer", "sampler", "samplerShadow", "subpassInput", "isubpassInput", "usubpassInput", "subpassInputMS", "isubpassInputMS", "usubpassInputMS", "common", "partition", "active", "asm", "class", "union", "enum", "typedef", "template", "this", "resource", "goto", "inline", "noinline", "public", "static", "extern", "external", "interface", "long", "short", "half", "fixed", "unsigned", "superp", "input", "output", "hvec2", "hvec3", "hvec4", "fvec2", "fvec3", "fvec4", "filter", "sizeof", "cast", "namespace", "using", "sampler3DRect"};
        definition.setKeywords(keywords);
        String[] identifiers = new String[]{"radians", "Converts degrees to radians, i.e., (\u03c0 / 180) \u00b7 degrees", "degrees", "Converts radians to degrees, i.e., (180 / \u03c0) \u00b7 radians", "sin", "The standard trigonometric sine function", "cos", "The standard trigonometric cosine function", "tan", "The standard trigonometric tangent", "asin", "Arc sine. Returns an angle whose sine is x.\nThe range of values returned by this function is [-\u03c0 / 2, \u03c0 / 2].\nResults are undefined if |x| > 1.", "acos", "Arc cosine. Returns an angle whose cosine is x.\nThe range of values returned by this function is [0,\u03c0].\nResults are undefined if |x| > 1", "atan", "Arc tangent. Returns an angle whose tangent is y / x.\nThe signs of x and y are used to determine\nwhat quadrant the angle is in. The range of\nvalues returned by this function is [-\u03c0, \u03c0.\nResults are undefined if x and y are both 0", "sinh", "Returns the hyperbolic sine function (e\u02e3 - 1 / e\u02e3) / 2", "cosh", "Returns the hyperbolic sine function (e\u02e3 + 1 / e\u02e3) / 2", "tanh", "Returns the hyperbolic tangent function sinh(x) / cosh(x)", "asinh", "Arc hyperbolic sine; returns the inverse of sinh", "acosh", "Arc hyperbolic cosine; returns the non-negative\ninverse of cosh. Results are undefined if x < 1", "atanh", "Arc hyperbolic tangent; returns the inverse of\ntanh. Results are undefined if x >= 1", "pow", "Returns x raised to the y power, i.e., x\u02b8.\nResults are undefined if x < 0. Results are undefined if x\n= 0 and y <= 0", "exp", "Returns the natural exponentiation of x, i.e., e\u02e3", "log", "Returns the natural logarithm of x, i.e., returns\nthe value y which satisfies the equation x = e\u02b8.\nResults are undefined if x <= 0.", "exp2", "Returns 2 raised to the x power, i.e., 2\u02e3", "log2", "Returns the base 2 logarithm of x, i.e., returns\nthe value y which satisfies the equation x = 2\u02b8.\nResults are undefined if x <= 0", "sqrt", "Returns sqrt(x). Results are undefined if x < 0", "inversesqrt", "Returns 1 / sqrt(x). Results are undefined if x <= 0", "abs", "Returns x if x >= 0; otherwise it returns -x", "sign", "Returns 1.0 if x > 0, 0.0 if x = 0, or -1.0 if x < 0", "floor", "Returns a value equal to the nearest integer that\nis less than or equal to x", "trunc", "Returns a value equal to the nearest integer to x\nwhose absolute value is not larger than the\nabsolute value of x", "round", "Returns a value equal to the nearest integer to x.\nThe fraction 0.5 will round in a direction chosen\nby the implementation, presumably the\ndirection that is fastest. This includes the\npossibility that round(x) returns the same value\nas roundEven(x) for all values of x", "roundEven", "Returns a value equal to the nearest integer to x.\nA fractional part of 0.5 will round toward the\nnearest even integer. (Both 3.5 and 4.5 for x will\nreturn 4.0)", "ceil", "Returns a value equal to the nearest integer that\nis greater than or equal to x", "fract", "Returns x - floor(x)", "mod", "Modulus. Returns x - y \u00b7 floor(x / y).\nNote that implementations may use a cheap\napproximation to the remainder, and the error\ncan be large due to the discontinuity in floor.\nThis can produce mathematically unexpected\nresults in some cases, such as mod(x,x)\ncomputing x rather than 0, and can also cause\nthe result to have a different sign than the\ninfinitely precise result", "modf", "Returns the fractional part of x and sets i to the\ninteger part (as a whole number floating-point\nvalue). Both the return value and the output\nparameter will have the same sign as x", "min", "Returns y if y < x; otherwise it returns x", "max", "Returns y if x < y; otherwise it returns x", "clamp", "Returns min(max(x, minVal), maxVal). Results\nare undefined if minVal > maxVal", "mix", "Returns the linear blend of x and y, i.e., x \u00b7 (1 - a) + y \u00b7 a", "step", "Returns 0.0 if x < edge; otherwise it returns 1.0", "smoothstep", "Returns 0.0 if x <= edge0 and 1.0 if x >= edge1, and\nperforms smooth Hermite interpolation\nbetween 0 and 1 when edge0 < x < edge1. This is\nuseful in cases where you would want a\nthreshold function with a smooth transition", "isnan", "Returns true if x holds a NaN. Returns false otherwise.\nAlways returns false if NaNs are not implemented", "isinf", "Returns true if x holds a positive infinity or\nnegative infinity. Returns false otherwise.", "floatBitsToInt", "Returns a signed or unsigned integer value\nrepresenting the encoding of a floating-point\nvalue. The float value\u2019s bit-level representation\nis preserved", "intBitsToFloat", "Returns a floating-point value corresponding to\na signed or unsigned integer encoding of a\nfloating-point value. If a NaN is passed in, it will\nnot signal, and the resulting value is unspecified.\nIf an Inf is passed in, the resulting value is the\ncorresponding Inf. If a subnormal number is\npassed in, the result might be flushed to 0.\nOtherwise, the bit-level representation\nis preserved", "fma", "Computes and returns a * b + c. In uses where\nthe return value is eventually consumed by a\nvariable declared as precise:\n\u2022 fma() is considered a single operation,\n  whereas the expression a * b + c consumed\n  by a variable declared precise is considered\n  two operations.\n\u2022 The precision of fma() can differ from the\n  precision of the expression a * b + c.\n\u2022 fma() will be computed with the same\n  precision as any other fma() consumed by a\n  precise variable, giving invariant results for\n  the same input values of a, b, and c.\nOtherwise, in the absence of precise\nconsumption, there are no special constraints on\nthe number of operations or difference in\nprecision between fma() and the expression a * b + c", "frexp", "Splits x into a floating-point significand in the\nrange [0.5,1.0], and an integral exponent of two,\nsuch that x = significant \u00b7 pow(2, exponent)\n\nThe significand is returned by the function and\nthe exponent is returned in the parameter exp.\nFor a floating-point value of zero, the significand\nand exponent are both zero\n\nIf an implementation supports signed zero, an\ninput value of minus zero should return a\nsignificand of minus zero. For a floating-point\nvalue that is an infinity or is not a number, the\nresults are undefined\n\nIf the input x is a vector, this operation is\nperformed in a component-wise manner; the\nvalue returned by the function and the value\nwritten to exp are vectors with the same number\nof components as x", "ldexp", "Builds a floating-point number from x and the\ncorresponding integral exponent of two in exp,\nreturning: significant \u00b7 pow(2, exponent)\n\nIf this product is too large to be represented in\nthe floating-point type, the result is undefined\n\nIf exp is greater than +128 (single-precision) or\n+1024 (double-precision), the value returned is\nundefined. If exp is less than -126 (singleprecision) or -1022 (double-precision), the value\nreturned may be flushed to zero. Additionally,\nsplitting the value into a significand and\nexponent using frexp() and then reconstructing\na floating-point value using ldexp() should yield\nthe original input for zero and all finite nonsubnormal values.\nIf the input x is a vector, this operation is\nperformed in a component-wise manner; the\nvalue passed in exp and returned by the\nfunction are vectors with the same number of\ncomponents as x", "packUnorm2x16", "First, converts each component of the\nnormalized floating-point value v into 16-bit\n(2x16) or 8-bit (4x8) integer values. Then, the\nresults are packed into the returned 32-bit\nunsigned integer.\n\nThe conversion for component c of v to fixed\npoint is done as follows:\n\nround(clamp(c, 0, +1) * 65535.0)\n\nThe first component of the vector will be written\nto the least significant bits of the output; the last\ncomponent will be written to the most\nsignificant bits.", "packSnorm2x16", "First, converts each component of the\nnormalized floating-point value v into 16-bit\n(2x16) or 8-bit (4x8) integer values. Then, the\nresults are packed into the returned 32-bit\nunsigned integer.\n\nThe conversion for component c of v to fixed\npoint is done as follows:\n\nround(clamp(c, -1, +1) * 32767.0)\n\nThe first component of the vector will be written\nto the least significant bits of the output; the last\ncomponent will be written to the most\nsignificant bits.", "packUnorm4x8", "First, converts each component of the\nnormalized floating-point value v into 16-bit\n(2x16) or 8-bit (4x8) integer values. Then, the\nresults are packed into the returned 32-bit\nunsigned integer.\n\nThe conversion for component c of v to fixed\npoint is done as follows:\n\nround(clamp(c, 0, +1) * 255.0)\n\nThe first component of the vector will be written\nto the least significant bits of the output; the last\ncomponent will be written to the most\nsignificant bits.", "packSnorm4x8", "First, converts each component of the\nnormalized floating-point value v into 16-bit\n(2x16) or 8-bit (4x8) integer values. Then, the\nresults are packed into the returned 32-bit\nunsigned integer.\n\nThe conversion for component c of v to fixed\npoint is done as follows:\n\nround(clamp(c, -1, +1) * 127.0)\n\nThe first component of the vector will be written\nto the least significant bits of the output; the last\ncomponent will be written to the most\nsignificant bits.", "unpackUnorm2x16", "First, unpacks a single 32-bit unsigned integer p\ninto a pair of 16-bit unsigned integers, a pair of\n16-bit signed integers, four 8-bit unsigned\nintegers, or four 8-bit signed integers,\nrespectively. Then, each component is converted\nto a normalized floating-point value to generate\nthe returned two- or four-component vector.\n\nThe conversion for unpacked fixed-point value f\nto floating-point is done as follows:\n\nunpackUnorm2x16: f / 65535.0\n\nThe first component of the returned vector will\nbe extracted from the least significant bits of the\ninput; the last component will be extracted from\nthe most significant bits.", "unpackSnorm2x16", "First, unpacks a single 32-bit unsigned integer p\ninto a pair of 16-bit unsigned integers, a pair of\n16-bit signed integers, four 8-bit unsigned\nintegers, or four 8-bit signed integers,\nrespectively. Then, each component is converted\nto a normalized floating-point value to generate\nthe returned two- or four-component vector.\n\nThe conversion for unpacked fixed-point value f\nto floating-point is done as follows:\n\nunpackSnorm2x16: clamp(f / 32767.0, -1, +1)\n\nThe first component of the returned vector will\nbe extracted from the least significant bits of the\ninput; the last component will be extracted from\nthe most significant bits.", "unpackUnorm4x8", "First, unpacks a single 32-bit unsigned integer p\ninto a pair of 16-bit unsigned integers, a pair of\n16-bit signed integers, four 8-bit unsigned\nintegers, or four 8-bit signed integers,\nrespectively. Then, each component is converted\nto a normalized floating-point value to generate\nthe returned two- or four-component vector.\n\nThe conversion for unpacked fixed-point value f\nto floating-point is done as follows:\n\nf / 255.0\n\nThe first component of the returned vector will\nbe extracted from the least significant bits of the\ninput; the last component will be extracted from\nthe most significant bits.", "unpackSnorm4x8", "First, unpacks a single 32-bit unsigned integer p\ninto a pair of 16-bit unsigned integers, a pair of\n16-bit signed integers, four 8-bit unsigned\nintegers, or four 8-bit signed integers,\nrespectively. Then, each component is converted\nto a normalized floating-point value to generate\nthe returned two- or four-component vector.\n\nThe conversion for unpacked fixed-point value f\nto floating-point is done as follows:\n\nclamp(f / 127.0, -1, +1)\n\nThe first component of the returned vector will\nbe extracted from the least significant bits of the\ninput; the last component will be extracted from\nthe most significant bits.", "packHalf2x16", "Returns an unsigned integer obtained by\nconverting the components of a two-component\nfloating-point vector to the 16-bit floating-point\nrepresentation of the API, and then packing\nthese two 16-bit integers into a 32-bit unsigned\ninteger.\n\nThe first vector component specifies the 16 least-\nsignificant bits of the result; the second\ncomponent specifies the 16 most-significant bits", "unpackHalf2x16", "Returns a two-component floating-point vector\nwith components obtained by unpacking a 32-bit\nunsigned integer into a pair of 16-bit values,\ninterpreting those values as 16-bit floating-point\nnumbers according to the API, and converting\nthem to 32-bit floating-point values.\n\nThe first component of the vector is obtained\nfrom the 16 least-significant bits of v; the second\ncomponent is obtained from the 16 mostsignificant bits of v", "packDouble2x32", "Returns a double-precision value obtained by\npacking the components of v into a 64-bit value.\nIf an IEEE 754 Inf or NaN is created, it will not\nsignal, and the resulting floating-point value is\nunspecified. Otherwise, the bit-level\nrepresentation of v is preserved. The first vector\ncomponent specifies the 32 least significant bits;\nthe second component specifies the 32 most\nsignificant bits", "unpackDouble2x32", "Returns a two-component unsigned integer\nvector representation of v. The bit-level\nrepresentation of v is preserved. The first\ncomponent of the vector contains the 32 least\nsignificant bits of the double; the second\ncomponent consists of the 32 most significant\nbits", "length", "Returns the length of vector x", "distance", "Returns the distance between p0 and p1, i.e., length(p0 - p1)", "dot", "Returns the dot product of x and y, i.e., x0 \u00b7 y0 + x1 \u00b7 y1 + ...", "cross", "Returns the cross product of x and y, i.e.,\n(x1 \u00b7 y2 - y1 \u00b7 x2, x2 \u00b7 y0 - y2 \u00b7 x0, x0 \u00b7 y1 - y0 \u00b7 x1)", "normalize", "Returns a vector in the same direction as x but\nwith a length of 1, i.e. x / length(x)", "ftransform", "Available only when using the compatibility\nprofile. For core OpenGL, use invariant.\nFor vertex shaders only. This function will\nensure that the incoming vertex value will be\ntransformed in a way that produces exactly the\nsame result as would be produced by OpenGL\u2019s\nfixed functionality transform. It is intended to\nbe used to compute gl_Position, e.g.\n\ngl_Position = ftransform()\n\nThis function should be used, for example, when\nan application is rendering the same geometry\nin separate passes, and one pass uses the fixed\nfunctionality path to render and another pass\nuses programmable shaders", "faceforward", "If dot(Nref, I) < 0 return N, otherwise return -N", "reflect", "For the incident vector I and surface orientation\nN, returns the reflection direction: I - 2 \u00b7 dot(N, I) \u00b7 N.\nN must already be normalized in order to\nachieve the desired result", "refract", "For the incident vector I and surface normal N,\nand the ratio of indices of refraction eta, return\nthe refraction vector. The result is computed by\nthe refraction equation", "matrixCompMult", "Multiply matrix x by matrix y component-wise,\ni.e., result[i][j] is the scalar product of x[i][j] and\ny[i][j].\n\nNote: to get linear algebraic matrix\nmultiplication, use the multiply operator (*)", "outerProduct", "Treats the first parameter c as a column vector\n(matrix with one column) and the second\nparameter r as a row vector (matrix with one\nrow) and does a linear algebraic matrix multiply\nc * r, yielding a matrix whose number of rows is\nthe number of components in c and whose\nnumber of columns is the number of\ncomponents in r.\n", "transpose", "Returns a matrix that is the transpose of m.\nThe input matrix m is not modified", "determinant", "Returns the determinant of m", "inverse", "Returns a matrix that is the inverse of m. The\ninput matrix m is not modified. The values in the\nreturned matrix are undefined if m is singular\nor poorly-conditioned (nearly singular)", "lessThan", "Returns the component-wise compare of x < y", "lessThanEqual", "Returns the component-wise compare of x <= y", "greaterThan", "Returns the component-wise compare of x > y", "greaterThanEqual", "Returns the component-wise compare of x >= y", "equal", "Returns the component-wise compare of x == y", "notEqual", "Returns the component-wise compare of x != y", "any", "Returns true if any component of x is true", "all", "Returns true only if all components of x are true", "not", "Returns the component-wise logical complement of x", "uaddCarry", "Adds 32-bit unsigned integers x and y, returning\nthe sum modulo 232. The value carry is set to\nzero if the sum was less than 232, or one\notherwise", "usubBorrow", "Subtracts the 32-bit unsigned integer y from x,\nreturning the difference if non-negative, or 232\nplus the difference otherwise. The value borrow\nis set to zero if x \u2265 y, or one otherwise", "umulExtended", "Multiplies 32-bit unsigned or signed integers x\nand y, producing a 64-bit result. The 32 least-\nsignificant bits are returned in lsb. The 32 most-\nsignificant bits are returned in msb", "bitfieldExtract", "Extracts bits [offset, offset + bits - 1] from value,\nreturning them in the least significant bits of the\nresult.\n\nFor unsigned data types, the most significant bits\nof the result will be set to zero. For signed data\ntypes, the most significant bits will be set to the\nvalue of bit offset + bits - 1.\n\nIf bits is zero, the result will be zero. The result\nwill be undefined if offset or bits is negative, or if\nthe sum of offset and bits is greater than the\nnumber of bits used to store the operand. Note\nthat for vector versions of bitfieldExtract(), a\nsingle pair of offset and bits values is shared for\nall components", "bitfieldInsert", "Inserts the bits least significant bits of insert into\nbase.\n\nThe result will have bits [offset, offset + bits - 1]\ntaken from bits [0, bits - 1] of insert, and all other\nbits taken directly from the corresponding bits\nof base. If bits is zero, the result will simply be\nbase. The result will be undefined if offset or bits\nis negative, or if the sum of offset and bits is\ngreater than the number of bits used to store the\noperand.\nNote that for vector versions of bitfieldInsert(),\na single pair of offset and bits values is shared\nfor all components", "bitfieldReverse", "Reverses the bits of value. The bit numbered n of\nthe result will be taken from bit (bits - 1) - n of\nvalue, where bits is the total number of bits used\nto represent value", "bitCount", "Returns the number of one bits in the binary\nrepresentation of value", "findLSB", "Returns the bit number of the least significant\none bit in the binary representation of value. If\nvalue is zero, -1 will be returned", "findMSB", "Returns the bit number of the most significant\nbit in the binary representation of value.\n\nFor positive integers, the result will be the bit\nnumber of the most significant one bit. For\nnegative integers, the result will be the bit\nnumber of the most significant zero bit. For a\nvalue of zero or negative one, -1 will be\nreturned", "textureSize", "Returns the dimensions of level lod (if present)\nfor the texture bound to sampler, as described in\nsection 11.1.3.4 \"Texture Queries\" of the OpenGL\nSpecification.\nThe components in the return value are filled in,\nin order, with the width, height, and depth of the\ntexture.\n\nFor the array forms, the last component of the\nreturn value is the number of layers in the\ntexture array, or the number of cubes in the\ntexture cube map array", "textureQueryLod", "Returns the mipmap array(s) that would be\naccessed in the x component of the return value.\n\nReturns the computed level-of-detail relative to\nthe base level in the y component of the return\nvalue.\n\nIf called on an incomplete texture, the results\nare undefined.", "textureQueryLevels", "Returns the number of mipmap levels accessible\nin the texture associated with sampler, as\ndefined in the OpenGL Specification.\n\nThe value zero will be returned if no texture or\nan incomplete texture is associated with\nsampler.\n\nAvailable in all shader stages", "textureSamples", "Returns the number of samples of the texture or\ntextures bound to sampler", "texture", "Use the texture coordinate P to do a texture\nlookup in the texture currently bound to\nsampler.\n\nFor shadow forms: When compare is present, it\nis used as Dref and the array layer comes from\nthe last component of P. When compare is not\npresent, the last component of P is used as Dref\nand the array layer comes from the second to\nlast component of P. (The second component of\nP is unused for 1D shadow lookups)\n\nFor non-shadow forms: the array layer comes\nfrom the last component of P", "textureProj", "Do a texture lookup with projection. The texture\ncoordinates consumed from P, not including the\nlast component of P, are divided by the last\ncomponent of P to form projected coordinates P'.\nThe resulting third component of P in the\nshadow forms is used as D. The third\ncomponent of P is ignored when sampler has\ntype gsampler2D and P has type vec4. After\nthese values are computed, texture lookup\nproceeds as in texture", "textureLod", "Do a texture lookup as in texture but with\nexplicit level-of-detail; lod specifies \u03bbbase] and\nsets the partial derivatives as follows:\n(See section 8.14 \"Texture Minification\" and\nequations 8.4-8.6 of the OpenGL Specification)", "textureOffset", "Do a texture lookup as in texture but with offset\nadded to the (u,v,w) texel coordinates before\nlooking up each texel. The offset value must be a\nconstant expression. A limited range of offset\nvalues are supported; the minimum and\nmaximum offset values are implementation-\ndependent and given by\ngl_MinProgramTexelOffset and\ngl_MaxProgramTexelOffset, respectively.\n\nNote that offset does not apply to the layer\ncoordinate for texture arrays. This is explained\nin detail in section 8.14.2 \"Coordinate Wrapping\nand Texel Selection\" of the OpenGL\nSpecification, where offset is (\u03b4u, \u03b4v\n, \u03b4w).\nNote that texel offsets are also not supported for\ncube maps", "texelFetch", "Use integer texture coordinate P to lookup a\nsingle texel from sampler. The array layer comes\nfrom the last component of P for the array\nforms. The level-of-detail lod (if present) is as\ndescribed in sections 11.1.3.2 \"Texel Fetches\"\nand 8.14.1 \"Scale Factor and Level of Detail\" of\nthe OpenGL Specification", "texelFetchOffset", "Fetch a single texel as in texelFetch, offset by\noffset as described in textureOffset", "textureProjOffset", "Do a projective texture lookup as described in\ntextureProj, offset by offset as described in textureOffset", "textureLodOffset", "Do an offset texture lookup with explicit level-of-\ndetail. See textureLod and textureOffset", "textureProjLod", "Do a projective texture lookup with explicit\nlevel-of-detail. See textureProj and textureLod", "textureProjLodOffset", "Do an offset projective texture lookup with\nexplicit level-of-detail. See textureProj,\ntextureLod, and textureOffset.", "textureGrad", "Do a texture lookup as in texture but with\nexplicit gradients as shown below. The partial\nderivatives of P are with respect to window x\nand window y. For the cube version, the partial\nderivatives of P are assumed to be in the\ncoordinate system used before texture\ncoordinates are projected onto the appropriate\ncube face", "textureGradOffset", "Do a texture lookup with both explicit gradient\nand offset, as described in textureGrad and textureOffset", "textureProjGrad", "\"Do a texture lookup both projectively, as\ndescribed in textureProj, and with explicit\ngradient as described in textureGrad. The\npartial derivatives dPdx and dPdy are assumed\nto be already projected", "textureProjGradOffset", "Do a texture lookup projectively and with\nexplicit gradient as described in\ntextureProjGrad, as well as with offset, as\ndescribed in textureOffset", "textureGather", "Returns the value\n\nvec4(Sample_i0_j1(P, base).comp,\n  Sample_i1_j1(P, base).comp,\n  Sample_i1_j0(P, base).comp,\n  Sample_i0_j0(P, base).comp)\n\nIf specified, the value of comp must be a\nconstant integer expression with a value of 0, 1,\n2, or 3, identifying the x, y, z, or w post-swizzled\ncomponent of the four-component vector\nlookup result for each texel, respectively. If\ncomp is not specified, it is treated as 0, selecting\nthe x component of each texel to generate the result", "textureGatherOffset", "Perform a texture gather operation as in\ntextureGather by offset as described in\ntextureOffset except that the offset can be\nvariable (non constant) and the implementation-\ndependent minimum and maximum offset\nvalues are given by\nMIN_PROGRAM_TEXTURE_GATHER_OFFSET and\nMAX_PROGRAM_TEXTURE_GATHER_OFFSET, respectively", "textureGatherOffsets", "Operate identically to textureGatherOffset\nexcept that offsets is used to determine the\nlocation of the four texels to sample. Each of the\nfour texels is obtained by applying the\ncorresponding offset in offsets as a (u, v)\ncoordinate offset to P, identifying the four-texel\nLINEAR footprint, and then selecting the texel i0\nj0 of that footprint. The specified values in offsets\nmust be constant integral expressions", "texture1D", "Same as texture, except only available in the compatibility profile", "texture1DProj", "Same as texture, except only available in the compatibility profile", "texture1DLod", "Same as texture, except only available in the compatibility profile", "texture1DProjLod", "Same as texture, except only available in the compatibility profile", "texture2D", "Same as texture, except only available in the compatibility profile", "texture2DProj", "Same as texture, except only available in the compatibility profile", "texture2DLod", "Same as texture, except only available in the compatibility profile", "texture2DProjLod", "Same as texture, except only available in the compatibility profile", "texture3D", "Same as texture, except only available in the compatibility profile", "texture3DProj", "Same as texture, except only available in the compatibility profile", "texture3DLod", "Same as texture, except only available in the compatibility profile", "texture3DProjLod", "Same as texture, except only available in the compatibility profile", "textureCube", "Same as texture, except only available in the compatibility profile", "textureCubeLod", "Same as texture, except only available in the compatibility profile", "shadow1D", "Same as texture, except only available in the compatibility profile", "shadow2D", "Same as texture, except only available in the compatibility profile", "shadow1DProj", "Same as texture, except only available in the compatibility profile", "shadow2DProj", "Same as texture, except only available in the compatibility profile", "shadow1DLod", "Same as texture, except only available in the compatibility profile", "shadow2DLod", "Same as texture, except only available in the compatibility profile", "shadow1DProjLod", "Same as texture, except only available in the compatibility profile", "shadow2DProjLod", "Same as texture, except only available in the compatibility profile", "atomicCounterIncrement", "Atomically\n\n1. increments the counter for c, and\n2. returns its value prior to the increment\n   operation", "atomicCounterDecrement", "Atomically\n\n1. decrements the counter for c, and\n2. returns the value resulting from the\n   decrement operation", "atomicCounter", "Returns the counter value for c", "atomicCounterAdd", "Atomically\n\n1. adds the value of data to the counter for c, and\n2. returns its value prior to the operation", "atomicCounterSubtract", "Atomically\n1. subtracts the value of data from the counter\n   for c, and\n2. returns its value prior to the operation", "atomicCounterMin", "Atomically\n\n1. sets the counter for c to the minimum of the\n   value of the counter and the value of data, and\n2. returns the value prior to the operation", "atomicCounterMax", "Atomically\n\n1. sets the counter for c to the maximum of the\n   value of the counter and the value of data, and\n2. returns the value prior to the operation", "atomicCounterAnd", "Atomically\n\n1. sets the counter for c to the bitwise AND of\n   the value of the counter and the value of\n   data, and\n2. returns the value prior to the operation", "atomicCounterOr", "Atomically\n\n1. sets the counter for c to the bitwise OR of the\n   value of the counter and the value of data, and\n2. returns the value prior to the operation", "atomicCounterXor", "Atomically\n\n1. sets the counter for c to the bitwise XOR of\n   the value of the counter and the value of\n   data, and\n2. returns the value prior to the operation", "atomicCounterExchange", "Atomically\n\n1. sets the counter value for c to the value of\n   data, and\n2. returns its value prior to the operation", "atomicCounterCompSwap", "Atomically\n\n1. compares the value of compare and the\n   counter value for c\n2. if the values are equal, sets the counter value\n   for c to the value of data, and\n3. returns its value prior to the operation", "atomicAdd", "Computes a new value by adding the value of\ndata to the contents mem", "atomicMin", "Computes a new value by taking the minimum\nof the value of data and the contents of mem", "atomicMax", "Computes a new value by taking the maximum\nof the value of data and the contents of mem", "atomicAnd", "Computes a new value by performing a bit-wise\nAND of the value of data and the contents of mem", "atomicOr", "Computes a new value by performing a bit-wise\nOR of the value of data and the contents of mem", "atomicXor", "Computes a new value by performing a bit-wise\nEXCLUSIVE OR of the value of data and the\ncontents of mem", "atomicExchange", "Computes a new value by simply copying the\nvalue of data", "atomicCompSwap", "Compares the value of compare and the contents\nof mem. If the values are equal, the new value is\ngiven by data; otherwise, it is taken from the\noriginal contents of mem", "imageSize", "Returns the dimensions of the image or images\nbound to image. For arrayed images, the last\ncomponent of the return value will hold the size\nof the array. Cube images only return the\ndimensions of one face, and the number of\ncubes in the cube map array, if arrayed.\nNote: The qualification readonly writeonly\naccepts a variable qualified with readonly,\nwriteonly, both, or neither. It means the formal\nargument will be used for neither reading nor\nwriting to the underlying memory", "imageSamples", "Returns the number of samples of the image or\nimages bound to image", "imageLoad", "Loads the texel at the coordinate P from the\nimage unit image (in IMAGE_PARAMS). For\nmultisample loads, the sample number is given\nby sample. When image, P, and sample identify a\nvalid texel, the bits used to represent the\nselected texel in memory are converted to a\nvec4, ivec4, or uvec4 in the manner described\nin section 8.26 \"Texture Image Loads and Stores\"\nof the OpenGL Specification and returned", "imageStore", "Stores data into the texel at the coordinate P\nfrom the image specified by image. For\nmultisample stores, the sample number is given\nby sample. When image, P, and sample identify a\nvalid texel, the bits used to represent data are\nconverted to the format of the image unit in the\nmanner described in section 8.26 \"Texture\nImage Loads and Stores\" of the OpenGL\nSpecification and stored to the specified texel", "imageAtomicAdd", "Computes a new value by adding the value of\ndata to the contents of the selected texel", "imageAtomicMin", "Computes a new value by taking the minimum\nof the value of data and the contents of the\nselected texel", "imageAtomicMax", "Computes a new value by taking the maximum\nof the value data and the contents of the selected texel", "imageAtomicAnd", "Computes a new value by performing a bit-wise\nAND of the value of data and the contents of the\nselected texel", "imageAtomicOr", "Computes a new value by performing a bit-wise\nOR of the value of data and the contents of the\nselected texel", "imageAtomicXor", "Computes a new value by performing a bit-wise\nEXCLUSIVE OR of the value of data and the\ncontents of the selected texel", "imageAtomicExchange", "Computes a new value by simply copying the\nvalue of data", "imageAtomicCompSwap", "Compares the value of compare and the contents\nof the selected texel. If the values are equal, the\nnew value is given by data; otherwise, it is taken\nfrom the original value loaded from the texel", "EmitStreamVertex", "Emits the current values of output variables to\nthe current output primitive on stream stream.\nThe argument to stream must be a constant\nintegral expression. On return from this call, the\nvalues of all output variables are undefined.\nCan only be used if multiple output streams are\nsupported", "EndStreamPrimitive", "Completes the current output primitive on\nstream stream and starts a new one. The\nargument to stream must be a constant integral\nexpression. No vertex is emitted.\nCan only be used if multiple output streams\nare supported", "EmitVertex", "Emits the current values of output variables to\nthe current output primitive. When multiple\noutput streams are supported, this is equivalent\nto calling EmitStreamVertex(0).\nOn return from this call, the values of output\nvariables are undefined", "EndPrimitive", "Completes the current output primitive and\nstarts a new one. When multiple output streams\nare supported, this is equivalent to calling\nEndStreamPrimitive(0).\nNo vertex is emitted", "dFdx", "Returns either dFdxFine(p) or dFdxCoarse(p),\nbased on implementation choice, presumably\nwhichever is the faster, or by whichever is\nselected in the API through quality-versus-speed\nhints", "dFdy", "Returns either dFdyFine(p) or dFdyCoarse(p),\nbased on implementation choice, presumably\nwhichever is the faster, or by whichever is\nselected in the API through quality-versus-speed\nhints", "dFdxFine", "Returns the partial derivative of p with respect\nto the window x coordinate. Will use local\ndifferencing based on the value of p for the\ncurrent fragment and its immediate neighbor(s)", "dFdyFine", "Returns the partial derivative of p with respect\nto the window y coordinate. Will use local\ndifferencing based on the value of p for the\ncurrent fragment and its immediate neighbor(s)", "dFdxCoarse", "Returns the partial derivative of p with respect\nto the window x coordinate. Will use local\ndifferencing based on the value of p for the\ncurrent fragment\u2019s neighbors, and will possibly,\nbut not necessarily, include the value of p for the\ncurrent fragment. That is, over a given area, the\nimplementation can x compute derivatives in\nfewer unique locations than would be allowed\nfor dFdxFine(p)", "dFdyCoarse", "Returns the partial derivative of p with respect\nto the window y coordinate. Will use local\ndifferencing based on the value of p for the\ncurrent fragment\u2019s neighbors, and will possibly,\nbut not necessarily, include the value of p for the\ncurrent fragment. That is, over a given area, the\nimplementation can compute y derivatives in\nfewer unique locations than would be allowed\nfor dFdyFine(p)", "fwidth", "Returns abs(dFdx(p)) + abs(dFdy(p))", "fwidthFine", "Returns abs(dFdxFine(p)) + abs(dFdyFine(p))", "fwidthCoarse", "Returns abs(dFdxCoarse(p)) + abs(dFdyCoarse(p))", "interpolateAtCentroid", "Returns the value of the input interpolant\nsampled at a location inside both the pixel and\nthe primitive being processed. The value\nobtained would be the same value assigned to\nthe input variable if declared with the centroid\nqualifier", "interpolateAtSample", "Returns the value of the input interpolant\nvariable at the location of sample number\nsample. If multisample buffers are not available,\nthe input variable will be evaluated at the center\nof the pixel. If sample sample does not exist, the\nposition used to interpolate the input variable is\nundefined", "interpolateAtOffset", "Returns the value of the input interpolant\nvariable sampled at an offset from the center of\nthe pixel specified by offset. The two floating-\npoint components of offset, give the offset in\npixels in the x and y directions, respectively.\nAn offset of (0, 0) identifies the center of the\npixel. The range and granularity of offsets\nsupported by this function is implementationdependent", "noise1", "Returns a 1D noise value based on the input\nvalue x\n\nDeprecated starting with version\n4.4 of GLSL", "noise2", "Returns a 2D noise value based on the input\nvalue x\n\nDeprecated starting with version\n4.4 of GLSL", "noise3", "Returns a 3D noise value based on the input\nvalue x\n\nDeprecated starting with version\n4.4 of GLSL", "noise4", "Returns a 4D noise value based on the input\nvalue x\n\nDeprecated starting with version\n4.4 of GLSL", "barrier", "For any given static instance of barrier(), all\ntessellation control shader invocations for a\nsingle input patch must enter it before any will\nbe allowed to continue beyond it, or all compute\nshader invocations for a single workgroup must\nenter it before any will continue beyond it", "memoryBarrier", "Control the ordering of memory transactions\nissued by a single shader invocation", "memoryBarrierAtomicCounter", "Control the ordering of accesses to atomic-\ncounter variables issued by a single shader invocation", "memoryBarrierBuffer", "Control the ordering of memory transactions to\nbuffer variables issued within a single shader invocation", "memoryBarrierShared", "Control the ordering of memory transactions to\nshared variables issued within a single shader\ninvocation, as viewed by other invocations in\nthe same workgroup.\n\nOnly available in compute shaders", "memoryBarrierImage", "Control the ordering of memory transactions to\nimages issued within a single shader invocation", "groupMemoryBarrier", "Control the ordering of all memory transactions\nissued within a single shader invocation, as\nviewed by other invocations in the same\nworkgroup.\n\nOnly available in compute shaders", "subpassLoad", "Read from a subpass input, from the implicit\nlocation (x, y, layer) of the current fragment\ncoordinate", "anyInvocation", "Returns true if and only if value is true for at\nleast one active invocation in the group", "allInvocations", "Returns true if and only if value is true for all\nactive invocations in the group", "allInvocationsEqual", "Returns true if value is the same for all active\ninvocations in the group"};
        HashMap<String, String> identifiersMap = new HashMap<String, String>(identifiers.length / 2);
        for (int i = 0; i < identifiers.length; i += 2) {
            identifiersMap.put(identifiers[i], identifiers[i + 1]);
        }
        definition.setIdentifiers(identifiersMap);
        HashMap<String, Integer> tokenRegexStrings = new HashMap<String, Integer>();
        tokenRegexStrings.put("[ \\t]*#[ \\t]*[a-zA-Z_]+", 6);
        tokenRegexStrings.put("[ \\t]*#[ \\t]*version.+", 6);
        tokenRegexStrings.put("L?\\\"(\\\\.|[^\\\"])*\\\"", 3);
        tokenRegexStrings.put("\\'\\\\?[^\\']\\'", 4);
        tokenRegexStrings.put("0[xX][0-9a-fA-F]+[uU]?[lL]?[lL]?", 2);
        tokenRegexStrings.put("0[0-7]+[Uu]?[lL]?[lL]?", 2);
        tokenRegexStrings.put("[+-]?([0-9]+([.][0-9]*)?|[.][0-9]+)([eE][+-]?[0-9]+)?[fF]?", 2);
        tokenRegexStrings.put("[+-]?[0-9]+[Uu]?[lL]?[lL]?", 2);
        tokenRegexStrings.put("[a-zA-Z_][a-zA-Z0-9_]*", 7);
        tokenRegexStrings.put("[\\[\\]\\{\\}\\!\\%\\^\\&\\*\\(\\)\\-\\+\\=\\~\\|\\<\\>\\?\\/\\;\\,\\.]", 5);
        definition.setTokenRegexStrings(tokenRegexStrings);
        definition.setCommentStart("/*");
        definition.setCommentEnd("*/");
        definition.setSingleLineComment("//");
        definition.setAutoIndentation(true);
        definition.setName("GLSL");
        return definition;
    }
}

