/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.color;

import foundry.veil.api.client.color.Color;
import org.jetbrains.annotations.Contract;

public interface Colorc {
    @Contract(pure=true)
    public float red();

    @Contract(pure=true)
    public float green();

    @Contract(pure=true)
    public float blue();

    @Contract(pure=true)
    public float alpha();

    @Contract(pure=true)
    default public int redInt() {
        return (int)(this.red() * 255.0f);
    }

    @Contract(pure=true)
    default public int greenInt() {
        return (int)(this.green() * 255.0f);
    }

    @Contract(pure=true)
    default public int blueInt() {
        return (int)(this.blue() * 255.0f);
    }

    @Contract(pure=true)
    default public int alphaInt() {
        return (int)(this.alpha() * 255.0f);
    }

    @Contract(pure=true)
    default public int rgb() {
        return ((int)(this.red() * 255.0f) & 0xFF) << 16 | ((int)(this.green() * 255.0f) & 0xFF) << 8 | (int)(this.blue() * 255.0f) & 0xFF;
    }

    @Contract(pure=true)
    default public int argb() {
        return ((int)(this.alpha() * 255.0f) & 0xFF) << 24 | ((int)(this.red() * 255.0f) & 0xFF) << 16 | ((int)(this.green() * 255.0f) & 0xFF) << 8 | (int)(this.blue() * 255.0f) & 0xFF;
    }

    @Contract(pure=true)
    default public float minComponent() {
        return Math.min(this.red(), Math.min(this.green(), this.blue()));
    }

    @Contract(pure=true)
    default public float maxComponent() {
        return Math.max(this.red(), Math.max(this.green(), this.blue()));
    }

    @Contract(pure=true)
    default public float hue() {
        float min = this.minComponent();
        float max = this.maxComponent();
        float hue = this.red() == max ? 60.0f * (this.green() - this.blue()) / (max - min) : (this.green() == max ? 60.0f * (2.0f + (this.blue() - this.red()) / (max - min)) : 60.0f * (4.0f + (this.red() - this.green()) / (max - min)));
        if ((hue %= 360.0f) < 0.0f) {
            hue += 360.0f;
        }
        return hue;
    }

    @Contract(pure=true)
    default public float saturation() {
        float max;
        float min = this.minComponent();
        if (min == (max = this.maxComponent())) {
            return 0.0f;
        }
        float luminance = this.luminance();
        if ((double)luminance <= 0.5) {
            return (max - min) / (max + min);
        }
        return (max - min) / (2.0f - max - min);
    }

    @Contract(pure=true)
    default public float luminance() {
        return (this.minComponent() + this.maxComponent()) / 2.0f;
    }

    @Contract(pure=true)
    default public Color lerp(Colorc other, float delta, Color store) {
        return store.set(this.red() + (other.red() - this.red()) * delta, this.green() + (other.green() - this.green()) * delta, this.blue() + (other.blue() - this.blue()) * delta, this.alpha() + (other.alpha() - this.alpha()) * delta);
    }

    @Contract(pure=true)
    default public Color mix(Colorc color, float amount, Color store) {
        return store.set(this.red() * (1.0f - amount) + color.red() * amount, this.green() * (1.0f - amount) + color.green() * amount, this.blue() * (1.0f - amount) + color.blue() * amount, this.alpha() * (1.0f - amount) + color.alpha() * amount);
    }

    @Contract(pure=true)
    default public Color lighten(float amount, Color store) {
        return this.mix(Color.WHITE, amount, store);
    }

    @Contract(pure=true)
    default public Color darken(float amount, Color store) {
        return this.mix(Color.BLACK, amount, store);
    }

    @Contract(pure=true)
    default public Color invert(Color store) {
        float max = Math.max(1.0f, this.maxComponent());
        return store.set(max - this.red(), max - this.green(), max - this.blue());
    }

    @Contract(pure=true)
    default public Color grayscale(Color store) {
        return this.setHSV(0.0f, 1.0f, this.luminance(), store);
    }

    @Contract(pure=true)
    default public Color sepia(Color store) {
        float red = this.red();
        float green = this.green();
        float blue = this.blue();
        return store.set(red * 0.393f + green * 0.769f + blue * 0.189f, red * 0.349f + green * 0.686f + blue * 0.168f, red * 0.272f + green * 0.534f + blue * 0.131f);
    }

    @Contract(pure=true)
    default public Color setHue(float hue, Color store) {
        return this.setHSV(hue, this.saturation(), this.luminance(), store);
    }

    @Contract(pure=true)
    default public Color setSaturation(float saturation, Color store) {
        return this.setHSV(this.hue(), saturation, this.luminance(), store);
    }

    @Contract(pure=true)
    default public Color setLuminance(float luminance, Color store) {
        return this.setHSV(this.hue(), this.saturation(), luminance, store);
    }

    @Contract(pure=true)
    default public Color setHSV(float hue, float saturation, float luminance, Color store) {
        if (saturation <= 0.0f) {
            return store.set(luminance, luminance, luminance);
        }
        hue /= 360.0f;
        if ((hue %= 1.0f) < 0.0f) {
            hue += 1.0f;
        }
        saturation = Math.min(saturation, 1.0f);
        luminance = luminance < 0.0f ? 0.0f : Math.min(luminance, 1.0f);
        float temp1 = (double)luminance < 0.5 ? luminance * (1.0f + saturation) : luminance + saturation - luminance * saturation;
        float temp2 = 2.0f * luminance - temp1;
        float tempR = hue + 0.33333334f;
        float tempG = hue;
        float tempB = hue - 0.33333334f;
        if (tempR < 0.0f) {
            tempR += 1.0f;
        } else if (tempR > 1.0f) {
            tempR -= 1.0f;
        }
        if (tempG < 0.0f) {
            tempG += 1.0f;
        } else if (tempG > 1.0f) {
            tempG -= 1.0f;
        }
        if (tempB < 0.0f) {
            tempB += 1.0f;
        } else if (tempB > 1.0f) {
            tempB -= 1.0f;
        }
        if (6.0 * (double)tempR < 1.0) {
            store.red(temp2 + (temp1 - temp2) * 6.0f * tempR);
        } else if (2.0 * (double)tempR < 1.0) {
            store.red(temp1);
        } else if (3.0 * (double)tempR < 2.0) {
            store.red(temp2 + (temp1 - temp2) * (0.6666667f - tempR) * 6.0f);
        }
        if (6.0 * (double)tempG < 1.0) {
            store.green(temp2 + (temp1 - temp2) * 6.0f * tempG);
        } else if (2.0 * (double)tempG < 1.0) {
            store.green(temp1);
        } else if (3.0 * (double)tempG < 2.0) {
            store.green(temp2 + (temp1 - temp2) * (0.6666667f - tempG) * 6.0f);
        }
        if (6.0 * (double)tempB < 1.0) {
            store.blue(temp2 + (temp1 - temp2) * 6.0f * tempB);
        } else if (2.0 * (double)tempB < 1.0) {
            store.blue(temp1);
        } else if (3.0 * (double)tempB < 2.0) {
            store.blue(temp2 + (temp1 - temp2) * (0.6666667f - tempB) * 6.0f);
        }
        return store;
    }
}

