/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import foundry.veil.Veil;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4080;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_7654;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CodecReloadListener<T>
extends class_4080<Map<class_2960, T>> {
    protected final Codec<T> codec;
    protected final class_7654 converter;
    private final class_7225.class_7874 registries;

    public CodecReloadListener(Codec<T> codec, class_7654 converter) {
        this(codec, converter, null);
    }

    public CodecReloadListener(Codec<T> codec, class_7654 converter, @Nullable class_7225.class_7874 registries) {
        this.codec = codec;
        this.converter = converter;
        this.registries = registries;
    }

    @NotNull
    protected Map<class_2960, T> prepare(@NotNull class_3300 resourceManager, @NotNull class_3695 profilerFiller) {
        HashMap data = new HashMap();
        JsonOps ops = this.registries != null ? class_6903.method_46632((DynamicOps)JsonOps.INSTANCE, (class_7225.class_7874)this.registries) : JsonOps.INSTANCE;
        Map resources = this.converter.method_45113(resourceManager);
        for (Map.Entry entry : resources.entrySet()) {
            class_2960 location = (class_2960)entry.getKey();
            class_2960 id = this.converter.method_45115(location);
            try {
                BufferedReader reader = ((class_3298)entry.getValue()).method_43039();
                try {
                    JsonElement element = JsonParser.parseReader((Reader)reader);
                    DataResult result = this.codec.parse((DynamicOps)ops, (Object)element);
                    if (result.error().isPresent()) {
                        throw new JsonSyntaxException(((DataResult.Error)result.error().get()).message());
                    }
                    if (data.put(id, result.result().orElseThrow()) == null) continue;
                    throw new IllegalStateException("Duplicate data file ignored with ID " + String.valueOf(id));
                }
                finally {
                    if (reader == null) continue;
                    ((Reader)reader).close();
                }
            }
            catch (Exception e) {
                Veil.LOGGER.error("Couldn't parse data file {} from {}", new Object[]{id, location, e});
            }
        }
        return data;
    }
}

