/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil;

import com.mojang.blaze3d.systems.RenderSystem;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.molang.VeilMolang;
import foundry.veil.impl.client.imgui.VeilImGui;
import foundry.veil.impl.client.imgui.VeilImGuiImpl;
import foundry.veil.platform.VeilPlatform;
import gg.moonflower.molangcompiler.api.MolangCompiler;
import java.util.ServiceLoader;
import net.minecraft.class_2960;
import org.jetbrains.annotations.ApiStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Veil {
    public static final String MODID = "veil";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Veil");
    public static final boolean DEBUG;
    public static final boolean IMGUI;
    public static final boolean VERBOSE_SHADER_ERRORS;
    public static boolean RENDERDOC;
    private static final VeilPlatform PLATFORM;
    public static final boolean SODIUM;
    public static final boolean IRIS;

    @ApiStatus.Internal
    public static void init() {
        LOGGER.info("Veil is initializing.");
        if (DEBUG) {
            LOGGER.info("Veil Debug Enabled");
        }
        if (!IMGUI) {
            LOGGER.info("ImGui Disabled");
        }
        VeilMolang.set(MolangCompiler.create((int)1, (ClassLoader)Veil.class.getClassLoader()));
    }

    public static void withImGui(Runnable task) {
        if (!RenderSystem.isOnRenderThreadOrInit()) {
            LOGGER.error("Called Veil#withImGui() on another thread");
            return;
        }
        if (VeilRenderSystem.hasImGui()) {
            VeilImGui imGui = VeilImGuiImpl.get();
            imGui.start();
            task.run();
            imGui.stop();
        }
    }

    public static class_2960 veilPath(String path) {
        return class_2960.method_60655((String)MODID, (String)path);
    }

    public static VeilPlatform platform() {
        return PLATFORM;
    }

    static {
        PLATFORM = ServiceLoader.load(VeilPlatform.class).findFirst().orElseThrow(() -> new RuntimeException("Veil expected platform implementation"));
        SODIUM = PLATFORM.isModLoaded("sodium");
        IRIS = PLATFORM.isModLoaded("iris");
        DEBUG = System.getProperty("veil.debug") != null;
        IMGUI = System.getProperty("veil.disableImgui") == null;
        VERBOSE_SHADER_ERRORS = System.getProperty("veil.verboseShaderErrors") != null;
    }
}

