/*
 * Decompiled with CFR 0.152.
 */
package de.nexusrealms.sirenssong.entity;

import de.nexusrealms.sirenssong.entity.SirensEntities;
import de.nexusrealms.sirenssong.item.SirensItems;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3857;

public class PocketOceanEntity
extends class_3857 {
    private static final int MAX_BLOCKS = 400;
    private static final int DELAY_TICKS = 1;
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private static final Predicate<class_2680> CAN_PLACE = blockState -> blockState.method_26215() || blockState.method_26204() == class_2246.field_10477 || blockState.method_26204() == class_2246.field_10214 || blockState.method_26204() == class_2246.field_10479 || blockState.method_26227().method_39360((class_3611)class_3612.field_15909);
    public static final List<class_2338> WATERS = new ArrayList<class_2338>(400);

    public PocketOceanEntity(class_1299<? extends class_3857> entityType, class_1937 world) {
        super(entityType, world);
    }

    public PocketOceanEntity(class_1937 world, class_1309 owner) {
        super(SirensEntities.POCKET_OCEAN, owner, world);
    }

    protected class_1792 method_16942() {
        return SirensItems.POCKET_OCEAN;
    }

    protected void method_7488(class_239 hitResult) {
        super.method_7488(hitResult);
        if (!this.method_37908().method_8608()) {
            class_2338 blockPos = new class_2338((int)hitResult.method_17784().field_1352, (int)hitResult.method_17784().field_1351, (int)hitResult.method_17784().field_1350);
            this.fillAreaWithBlocks((class_3218)this.method_37908(), blockPos);
            this.method_31472();
        }
    }

    private void fillAreaWithBlocks(final class_3218 world, final class_2338 startPos) {
        final LinkedList<class_2338> queue = new LinkedList<class_2338>();
        queue.add(startPos);
        final int[] blocksPlaced = new int[]{0};
        Runnable placeBlockTask = new Runnable(){

            @Override
            public void run() {
                if (!queue.isEmpty() && blocksPlaced[0] < 400) {
                    class_2338 pos = (class_2338)queue.poll();
                    if (pos != null && CAN_PLACE.test(world.method_8320(pos)) && pos.method_10264() <= startPos.method_10264() + 2) {
                        boolean hasNeighbor = false;
                        for (class_2350 direction : class_2350.values()) {
                            class_2338 neighborPos = pos.method_10093(direction);
                            if (world.method_8320(neighborPos).method_26215()) continue;
                            hasNeighbor = true;
                            break;
                        }
                        if (hasNeighbor) {
                            world.method_8503().execute(() -> {
                                world.method_8501(pos, class_2246.field_10382.method_9564());
                                blocksPlaced2[0] = blocksPlaced[0] + 1;
                                WATERS.add(pos);
                                for (class_2350 direction : class_2350.values()) {
                                    class_2338 offsetPos;
                                    if (!(Math.random() < 0.5) || !CAN_PLACE.test(world.method_8320(offsetPos = pos.method_10093(direction))) || offsetPos.method_10264() > startPos.method_10264() + 5) continue;
                                    queue.add(offsetPos);
                                }
                            });
                        }
                    }
                    PocketOceanEntity.this.scheduler.schedule(this, 20L, TimeUnit.MILLISECONDS);
                } else {
                    PocketOceanEntity.this.scheduler.shutdown();
                }
            }
        };
        this.scheduler.schedule(() -> world.method_8503().execute(() -> {
            WATERS.forEach(blockPos -> world.method_8501(blockPos, class_2246.field_10124.method_9564()));
            WATERS.clear();
        }), 30L, TimeUnit.SECONDS);
        this.scheduler.schedule(placeBlockTask, 20L, TimeUnit.MILLISECONDS);
    }
}

