/*
 * Decompiled with CFR 0.152.
 */
package de.nexusrealms.riftname;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.DynamicOps;
import de.nexusrealms.riftname.Riftname;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_7225;
import org.ladysnake.cca.api.v3.component.sync.AutoSyncedComponent;

public class NameComponent
implements AutoSyncedComponent {
    private Map<UUID, Either<class_2561, String>> tags = new HashMap<UUID, Either<class_2561, String>>();
    private Map<UUID, List<class_124>> formattings = new HashMap<UUID, List<class_124>>();
    private Map<UUID, String> nickNames = new HashMap<UUID, String>();
    private Map<UUID, class_5251> hexColors = new HashMap<UUID, class_5251>();

    public void readFromNbt(class_2487 nbtCompound, class_7225.class_7874 wrapperLookup) {
        this.tags = (Map)Riftname.Codecs.PLAYER_TAG_CODEC.parse((DynamicOps)class_2509.field_11560, (Object)nbtCompound.method_10562("tags")).getOrThrow();
        this.formattings = (Map)Riftname.Codecs.PLAYER_FORMATTING_CODEC.parse((DynamicOps)class_2509.field_11560, (Object)nbtCompound.method_10562("formattings")).getOrThrow();
        this.nickNames = (Map)Riftname.Codecs.PLAYER_NICK_NAME_CODEC.parse((DynamicOps)class_2509.field_11560, (Object)nbtCompound.method_10562("nicknames")).getOrThrow();
        this.hexColors = (Map)Riftname.Codecs.PLAYER_TEXT_COLOR_CODEC.parse((DynamicOps)class_2509.field_11560, (Object)nbtCompound.method_10562("hexcolors")).getOrThrow();
    }

    public void writeToNbt(class_2487 nbtCompound, class_7225.class_7874 wrapperLookup) {
        nbtCompound.method_10566("tags", (class_2520)Riftname.Codecs.PLAYER_TAG_CODEC.encodeStart((DynamicOps)class_2509.field_11560, this.tags).getOrThrow());
        nbtCompound.method_10566("formattings", (class_2520)Riftname.Codecs.PLAYER_FORMATTING_CODEC.encodeStart((DynamicOps)class_2509.field_11560, this.formattings).getOrThrow());
        nbtCompound.method_10566("nicknames", (class_2520)Riftname.Codecs.PLAYER_NICK_NAME_CODEC.encodeStart((DynamicOps)class_2509.field_11560, this.nickNames).getOrThrow());
        nbtCompound.method_10566("hexcolors", (class_2520)Riftname.Codecs.PLAYER_TEXT_COLOR_CODEC.encodeStart((DynamicOps)class_2509.field_11560, this.hexColors).getOrThrow());
    }

    public class_2561 getFormattedName(class_2561 name, UUID uuid) {
        String nick = this.nickNames.get(uuid);
        class_5250 tag = null;
        Either<class_2561, String> either = this.tags.get(uuid);
        boolean shouldFormatTag = false;
        if (either != null) {
            if (either.left().isPresent()) {
                tag = (class_5250)either.left().get();
            } else if (either.right().isPresent()) {
                tag = class_2561.method_43470((String)((String)either.right().get()));
                shouldFormatTag = true;
            }
        }
        class_2583 nameStyle = class_2583.field_24360;
        if (this.formattings.containsKey(uuid)) {
            List<class_124> formattingList = this.formattings.get(uuid);
            nameStyle = nameStyle.method_27705(formattingList.toArray(new class_124[0]));
        }
        if (this.hexColors.containsKey(uuid)) {
            nameStyle = nameStyle.method_27703(this.hexColors.get(uuid));
        }
        class_2561 newname = nick != null ? class_2561.method_43470((String)nick) : name;
        ((class_5250)newname).method_10862(nameStyle);
        if (tag != null) {
            tag = class_2561.method_43470((String)"[").method_10862(tag.method_10866()).method_10852((class_2561)tag).method_27693("] ").method_10862(tag.method_10866());
            if (shouldFormatTag) {
                tag.method_10862(nameStyle);
            }
            return tag.method_10852(newname);
        }
        return newname;
    }

    public void setNick(class_3222 player, String nick) {
        this.nickNames.put(player.method_5667(), nick);
    }

    public void clearNick(class_3222 player) {
        this.nickNames.remove(player.method_5667());
    }

    public void setHexColor(class_3222 player, class_5251 color) {
        this.hexColors.put(player.method_5667(), color);
    }

    public void clearHexColor(class_3222 player) {
        this.hexColors.remove(player.method_5667());
    }

    public void addFormatting(class_3222 player, class_124 formatting) {
        this.formattings.merge(player.method_5667(), new ArrayList<class_124>(List.of(formatting)), (oldlist, newlist) -> {
            oldlist.addAll(newlist);
            return oldlist;
        });
    }

    public void clearFormattings(class_3222 player) {
        this.formattings.remove(player.method_5667());
    }

    public void clearTag(class_3222 player) {
        this.tags.remove(player.method_5667());
    }

    public boolean clearStyleFromTag(class_3222 player) {
        Either<class_2561, String> either = this.tags.get(player.method_5667());
        if (either != null) {
            either.ifLeft(text -> this.setTag(player, (Either<class_2561, String>)Either.right((Object)text.getString())));
            return either.left().isPresent();
        }
        return false;
    }

    public void setTag(class_3222 player, Either<class_2561, String> tag) {
        this.tags.put(player.method_5667(), tag);
    }
}

