/*
 * Decompiled with CFR 0.152.
 */
package de.nexusrealms.riftbone;

import de.nexusrealms.riftbone.LegacyGraveEntity;
import de.nexusrealms.riftbone.Riftbone;
import de.nexusrealms.riftbone.SoulboundHandler;
import de.nexusrealms.riftbone.TrinketsCompat;
import java.util.ArrayList;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1277;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1313;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1707;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3908;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import org.jetbrains.annotations.NotNull;

public class GraveEntity
extends class_1297 {
    private static final class_2940<Optional<UUID>> OWNER = class_2945.method_12791(GraveEntity.class, (class_2941)class_2943.field_13313);
    private final class_1277 inventory = new class_1277(this, 54){

        public class_1799 method_5441(int slot) {
            class_1799 stack = super.method_5441(slot);
            stack.method_57381(Riftbone.SAVED_SLOT);
            return stack;
        }

        public class_1799 method_5434(int slot, int amount) {
            class_1799 stack = super.method_5441(slot);
            stack.method_57381(Riftbone.SAVED_SLOT);
            return stack;
        }
    };

    public GraveEntity(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    public GraveEntity(class_1657 entity) {
        super(Riftbone.GRAVE, entity.method_37908());
        this.field_6011.method_12778(OWNER, Optional.of(entity.method_5667()));
        this.method_5665((class_2561)class_2561.method_43470((String)(entity.method_5477().getString() + "'s grave")));
        this.placeItemsInGrave(entity);
        this.method_5719((class_1297)entity);
        TrinketsCompat.onGraveSpawn(entity);
    }

    public GraveEntity(LegacyGraveEntity legacyGraveEntity) {
        super(Riftbone.GRAVE, legacyGraveEntity.method_37908());
        this.field_6011.method_12778(OWNER, (Object)((Optional)legacyGraveEntity.method_5841().method_12789(LegacyGraveEntity.OWNER)));
        this.method_5665(legacyGraveEntity.method_5797());
        legacyGraveEntity.graveInventory.field_5828.forEach(arg_0 -> ((class_1277)this.inventory).method_5491(arg_0));
        this.method_5719(legacyGraveEntity);
    }

    private void addStack(class_1657 player, class_1799 stack, int slot) {
        if (!SoulboundHandler.isSoulbound(stack, player)) {
            stack.method_57379(Riftbone.SAVED_SLOT, (Object)slot);
            this.inventory.method_5491(stack);
        }
    }

    private void placeItemsInGrave(class_1657 entity) {
        for (int i = 0; i < entity.method_31548().method_5439(); ++i) {
            this.addStack(entity, entity.method_31548().method_5438(i), i);
        }
        TrinketsCompat.addTrinketsToGrave(this.inventory, entity);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        builder.method_56912(OWNER, Optional.empty());
    }

    protected void method_5749(class_2487 nbt) {
        class_5455 registries = this.method_56673();
        this.inventory.method_7659(nbt.method_10554("inventory", 10), (class_7225.class_7874)registries);
        if (nbt.method_10545("owner")) {
            this.field_6011.method_12778(OWNER, Optional.of(nbt.method_25926("owner")));
        }
    }

    protected void method_5652(class_2487 nbt) {
        class_5455 registries = this.method_56673();
        nbt.method_10566("inventory", (class_2520)this.inventory.method_7660((class_7225.class_7874)registries));
        if (((Optional)this.field_6011.method_12789(OWNER)).isPresent()) {
            nbt.method_25927("owner", (UUID)((Optional)this.field_6011.method_12789(OWNER)).get());
        }
    }

    public boolean method_5863() {
        return true;
    }

    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        if (!this.method_37908().method_8608()) {
            if (!this.method_37908().method_8450().method_8355(Riftbone.OWNER_ONLY_LOOTING) || this.isOwner(player.method_5667())) {
                if (player.method_5715()) {
                    this.quickLoot(player);
                    return class_1269.field_5812;
                }
                this.method_37908().method_8396(null, this.method_24515(), class_3417.field_17604, class_3419.field_15245, 1.0f, 1.0f);
                player.method_17355((class_3908)new GraveScreenHandlerFactory(this));
                return class_1269.field_5812;
            }
            this.method_37908().method_8396(null, this.method_24515(), class_3417.field_14808, class_3419.field_15245, 1.0f, 1.0f);
            return class_1269.field_5814;
        }
        return class_1269.field_5811;
    }

    public void method_5773() {
        double d;
        super.method_5773();
        this.field_6014 = this.method_23317();
        this.field_6036 = this.method_23318();
        this.field_5969 = this.method_23321();
        class_243 vec3d = this.method_18798();
        float f = this.method_5751() - 0.11111111f;
        if (this.method_5799() && this.method_5861(class_3486.field_15517) > (double)f) {
            this.applyWaterBuoyancy();
        } else if (this.method_5771() && this.method_5861(class_3486.field_15518) > (double)f) {
            this.applyLavaBuoyancy();
        } else if (!this.method_5740()) {
            this.method_18799(this.method_18798().method_1031(0.0, -0.04, 0.0));
        }
        if (!this.method_37908().field_9236 && this.field_6012 % 100 == 0 && this.inventory.method_5442()) {
            this.method_37908().method_8396(null, this.method_24515(), class_3417.field_15210, class_3419.field_15245, 1.0f, 1.0f);
            this.method_5768();
        }
        if (this.method_37908().field_9236) {
            this.field_5960 = false;
        } else {
            boolean bl = this.field_5960 = !this.method_37908().method_8587((class_1297)this, this.method_5829().method_1011(1.0E-7));
            if (this.field_5960) {
                this.method_5632(this.method_23317(), (this.method_5829().field_1322 + this.method_5829().field_1325) / 2.0, this.method_23321());
            }
        }
        if (!this.method_24828() || this.method_18798().method_37268() > (double)1.0E-5f || (this.field_6012 + this.method_5628()) % 4 == 0) {
            this.method_5784(class_1313.field_6308, this.method_18798());
            float g = 0.98f;
            if (this.method_24828()) {
                g = this.method_37908().method_8320(new class_2338(this.method_31477(), this.method_31478() - 1, this.method_31479())).method_26204().method_9499() * 0.98f;
            }
            if (this.method_23318() <= -64.0) {
                this.method_23327(this.method_23317(), -64.0, this.method_23321());
            }
            this.method_18799(this.method_18798().method_18805((double)g, 0.98, (double)g));
            if (this.method_24828()) {
                class_243 vec3d2 = this.method_18798();
                if (vec3d2.field_1351 < 0.0) {
                    this.method_18799(vec3d2.method_18805(1.0, -0.5, 1.0));
                }
            }
        }
        boolean bl = class_3532.method_15357((double)this.field_6014) != class_3532.method_15357((double)this.method_23317()) || class_3532.method_15357((double)this.field_6036) != class_3532.method_15357((double)this.method_23318()) || class_3532.method_15357((double)this.field_5969) != class_3532.method_15357((double)this.method_23321());
        int i = bl ? 2 : 40;
        this.field_6007 |= this.method_5876();
        if (!this.method_37908().field_9236 && (d = this.method_18798().method_1020(vec3d).method_1027()) > 0.01) {
            this.field_6007 = true;
        }
    }

    private boolean isOwner(UUID uuid) {
        if (((Optional)this.field_6011.method_12789(OWNER)).isEmpty()) {
            return false;
        }
        UUID uuid1 = (UUID)((Optional)this.field_6011.method_12789(OWNER)).get();
        return uuid1.equals(uuid);
    }

    private void quickLoot(class_1657 player) {
        if (this.method_37908().method_8450().method_8355(Riftbone.QUICK_LOOTING_ALLOWED) && (!this.method_37908().method_8450().method_8355(Riftbone.OWNER_ONLY_QUICK_LOOTING) || this.isOwner(player.method_5667()))) {
            ArrayList unslotted = new ArrayList();
            class_1661 playerInventory = player.method_31548();
            this.inventory.field_5828.forEach(stack -> {
                if (!TrinketsCompat.handleQuickLoot(stack, unslotted, player)) {
                    if (stack.method_57826(Riftbone.SAVED_SLOT)) {
                        int slot = (Integer)stack.method_57824(Riftbone.SAVED_SLOT);
                        stack.method_57381(Riftbone.SAVED_SLOT);
                        if (playerInventory.method_5438(slot).method_7960() || class_1542.method_24017((class_1799)stack, (class_1799)playerInventory.method_5438(slot))) {
                            playerInventory.method_7367(slot, stack);
                        } else {
                            unslotted.add(stack);
                        }
                    } else {
                        unslotted.add(stack);
                    }
                }
            });
            unslotted.forEach(stack -> playerInventory.method_32338(stack, false));
            this.method_5768();
            this.method_37908().method_8396(null, this.method_24515(), class_3417.field_15210, class_3419.field_15245, 1.0f, 1.0f);
        } else {
            this.method_37908().method_8396(null, this.method_24515(), class_3417.field_14808, class_3419.field_15245, 1.0f, 1.0f);
        }
    }

    public boolean method_5733() {
        return true;
    }

    protected class_1297.class_5799 method_33570() {
        return class_1297.class_5799.field_28630;
    }

    private void applyWaterBuoyancy() {
        class_243 vec3d = this.method_18798();
        this.method_18800(vec3d.field_1352 * (double)0.99f, vec3d.field_1351 + (double)(vec3d.field_1351 < (double)0.06f ? 5.0E-4f : 0.0f), vec3d.field_1350 * (double)0.99f);
    }

    private void applyLavaBuoyancy() {
        class_243 vec3d = this.method_18798();
        this.method_18800(vec3d.field_1352 * (double)0.95f, vec3d.field_1351 + (double)(vec3d.field_1351 < (double)0.06f ? 5.0E-4f : 0.0f), vec3d.field_1350 * (double)0.95f);
    }

    private static class GraveScreenHandlerFactory
    implements class_3908 {
        private final GraveEntity entity;

        private GraveScreenHandlerFactory(GraveEntity entity) {
            this.entity = entity;
        }

        public class_2561 method_5476() {
            return this.entity.method_5476();
        }

        @NotNull
        public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
            return class_1707.method_19247((int)syncId, (class_1661)inv, (class_1263)this.entity.inventory);
        }
    }
}

