/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.server;

import com.google.common.base.Preconditions;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.server.CameraInstance;
import io.github.mortuusars.exposure.world.camera.CameraId;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import org.jetbrains.annotations.Nullable;

public class CameraInstances {
    private static final Map<CameraId, CameraInstance> INSTANCES = new HashMap<CameraId, CameraInstance>();

    @Nullable
    public static CameraInstance get(CameraId id) {
        if (id.uuid().equals(class_156.field_25140)) {
            return null;
        }
        return INSTANCES.get(id);
    }

    public static Optional<CameraInstance> getOptional(CameraId id) {
        if (id.uuid().equals(class_156.field_25140)) {
            return Optional.empty();
        }
        return Optional.ofNullable(INSTANCES.get(id));
    }

    @Nullable
    public static CameraInstance get(class_1799 stack) {
        return CameraInstances.get(CameraId.ofStack(stack));
    }

    public static Optional<CameraInstance> getOptional(class_1799 stack) {
        return CameraInstances.getOptional(CameraId.ofStack(stack));
    }

    public static CameraInstance getOrThrow(CameraId id) {
        @Nullable CameraInstance instance = CameraInstances.get(id);
        Preconditions.checkState((instance != null ? 1 : 0) != 0, (String)"No Camera Instance with id '%s' found.", (Object)id);
        return instance;
    }

    public static void ifPresent(CameraId id, Consumer<CameraInstance> instanceConsumer) {
        @Nullable CameraInstance instance = CameraInstances.get(id);
        if (instance != null) {
            instanceConsumer.accept(instance);
        }
    }

    public static void ifPresent(class_1799 stack, Consumer<CameraInstance> instanceConsumer) {
        @Nullable CameraId id = (CameraId)stack.method_57824(Exposure.DataComponents.CAMERA_ID);
        if (id != null) {
            CameraInstances.ifPresent(id, instanceConsumer);
        }
    }

    public static void add(CameraId id, CameraInstance instance) {
        INSTANCES.put(id, instance);
    }

    public static void createOrUpdate(CameraId id, Consumer<CameraInstance> instanceConsumer) {
        CameraInstance instance = INSTANCES.computeIfAbsent(id, uuid -> new CameraInstance(id));
        instanceConsumer.accept(instance);
    }

    public static boolean canReleaseShutter(CameraId id) {
        return CameraInstances.getOptional(id).map(cameraInstance -> !cameraInstance.isWaitingForProjection()).orElse(true);
    }
}

