/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.network.handler;

import com.mojang.logging.LogUtils;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.ExposureClient;
import io.github.mortuusars.exposure.client.camera.CameraClient;
import io.github.mortuusars.exposure.client.capture.palettizer.Palettizer;
import io.github.mortuusars.exposure.client.capture.saving.ExposureUploader;
import io.github.mortuusars.exposure.client.capture.template.CaptureTemplate;
import io.github.mortuusars.exposure.client.capture.template.CaptureTemplates;
import io.github.mortuusars.exposure.client.gui.screen.FilmFrameInspectScreen;
import io.github.mortuusars.exposure.client.gui.screen.PhotographScreen;
import io.github.mortuusars.exposure.client.image.Image;
import io.github.mortuusars.exposure.client.image.TrichromeImage;
import io.github.mortuusars.exposure.client.sound.UniqueSoundManager;
import io.github.mortuusars.exposure.client.sound.instance.ShutterTickingSoundInstance;
import io.github.mortuusars.exposure.client.task.ExportExposuresTask;
import io.github.mortuusars.exposure.client.task.ExposureRetrieveTask;
import io.github.mortuusars.exposure.client.util.Minecrft;
import io.github.mortuusars.exposure.data.ColorPalette;
import io.github.mortuusars.exposure.data.ColorPalettes;
import io.github.mortuusars.exposure.network.packet.clientbound.CameraStandStopControllingS2CP;
import io.github.mortuusars.exposure.network.packet.clientbound.CaptureStartDebugRGBS2CP;
import io.github.mortuusars.exposure.network.packet.clientbound.CaptureStartS2CP;
import io.github.mortuusars.exposure.network.packet.clientbound.CreateChromaticExposureS2CP;
import io.github.mortuusars.exposure.network.packet.clientbound.ExportS2CP;
import io.github.mortuusars.exposure.network.packet.clientbound.ExposureDataChangedS2CP;
import io.github.mortuusars.exposure.network.packet.clientbound.ShaderApplyS2CP;
import io.github.mortuusars.exposure.network.packet.clientbound.ShowExposureCommandS2CP;
import io.github.mortuusars.exposure.network.packet.clientbound.UniqueSoundPlayShutterTickingS2CP;
import io.github.mortuusars.exposure.util.UnixTimestamp;
import io.github.mortuusars.exposure.util.cycles.task.Result;
import io.github.mortuusars.exposure.util.cycles.task.Task;
import io.github.mortuusars.exposure.world.camera.ExposureType;
import io.github.mortuusars.exposure.world.camera.capture.CaptureParameters;
import io.github.mortuusars.exposure.world.entity.CameraStandEntity;
import io.github.mortuusars.exposure.world.item.PhotographItem;
import io.github.mortuusars.exposure.world.item.util.ItemAndStack;
import io.github.mortuusars.exposure.world.level.storage.ExposureData;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.class_1113;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_437;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import org.slf4j.Logger;

public class ClientPacketsHandler {
    private static final Logger LOGGER = LogUtils.getLogger();

    public static void applyShader(ShaderApplyS2CP packet) {
        packet.shaderLocation().ifPresentOrElse(shader -> Minecrft.get().field_1773.method_3168(shader), () -> Minecrft.get().field_1773.method_3207());
    }

    public static void showExposure(ShowExposureCommandS2CP packet) {
        if (packet.negative()) {
            FilmFrameInspectScreen screen = new FilmFrameInspectScreen(packet.frames());
            Minecrft.get().method_1507((class_437)screen);
            return;
        }
        ArrayList<ItemAndStack<PhotographItem>> photographs = new ArrayList<ItemAndStack<PhotographItem>>(packet.frames().stream().map(frame -> {
            class_1799 photographStack = new class_1799((class_1935)Exposure.Items.PHOTOGRAPH.get());
            photographStack.method_57379(Exposure.DataComponents.PHOTOGRAPH_FRAME, frame);
            return new ItemAndStack(photographStack);
        }).toList());
        Collections.reverse(photographs);
        PhotographScreen screen = new PhotographScreen(photographs);
        Minecrft.get().method_1507((class_437)screen);
    }

    public static void exportExposures(ExportS2CP packet) {
        ExportExposuresTask.start(packet.ids(), packet.size(), packet.look());
    }

    public static void stopExportTask() {
        if (!ExportExposuresTask.stopCurrentTask()) {
            Minecrft.player().method_7353((class_2561)class_2561.method_43471((String)"task.exposure.export.not_running").method_27692(class_124.field_1061), false);
        }
    }

    public static void clearRenderingCache() {
        ExposureClient.imageRenderer().clearCache();
        ExposureClient.renderedExposures().clearCache();
    }

    public static void exposureDataChanged(ExposureDataChangedS2CP packet) {
        ExposureClient.exposureStore().refresh(packet.id());
        ExposureClient.imageRenderer().clearCacheOf(packet.id());
        ExposureClient.renderedExposures().clearCacheOf(packet.id());
    }

    public static void createChromaticExposure(CreateChromaticExposureS2CP packet) {
        if (packet.id().isEmpty()) {
            LOGGER.error("Cannot create chromatic exposure: identifier is empty.");
            return;
        }
        if (packet.layers().size() != 3) {
            LOGGER.error("Cannot create chromatic exposure: 3 layers required. Provided: '{}'.", (Object)packet.layers().size());
            return;
        }
        class_6880<ColorPalette> colorPalette = ColorPalettes.getDefault(Minecrft.registryAccess());
        ColorPalette palette = (ColorPalette)colorPalette.comp_349();
        class_2960 paletteId = ((class_5321)colorPalette.method_40230().orElseThrow()).method_29177();
        ExposureClient.cycles().addParallelTask(new ExposureRetrieveTask(packet.layers(), 20000).then(Result::unwrap).thenAsync(layers -> new TrichromeImage((Image)layers.get(0), (Image)layers.get(1), (Image)layers.get(2))).thenAsync(Palettizer.DITHERED.palettizeAndClose(palette)).thenAsync(img -> new ExposureData(img.width(), img.height(), img.pixels(), paletteId, new ExposureData.Tag(ExposureType.COLOR, Minecrft.player().method_5820(), UnixTimestamp.Seconds.now(), false, false))).acceptAsync(ExposureUploader.upload(packet.id())));
    }

    public static void startCapture(CaptureStartS2CP packet) {
        Task<?> captureTask = CaptureTemplates.getOrThrow(packet.templateId()).createTask(packet.captureParameters());
        ExposureClient.cycles().enqueueTask(captureTask);
    }

    public static void startDebugRGBCapture(CaptureStartDebugRGBS2CP packet) {
        CaptureTemplate template = CaptureTemplates.getOrThrow(packet.templateId());
        for (CaptureParameters captureParameters : packet.captureProperties()) {
            Task<?> captureTask = template.createTask(captureParameters);
            ExposureClient.cycles().enqueueTask(captureTask);
        }
    }

    public static void shutterOpened() {
        if (CameraClient.viewfinder() != null) {
            CameraClient.viewfinder().overlay().startDrawingShutter();
        }
    }

    public static void playShutterTickingSound(UniqueSoundPlayShutterTickingS2CP packet) {
        class_1297 entity = Minecrft.player().method_37908().method_8469(packet.entityId());
        if (entity != null) {
            ShutterTickingSoundInstance instance = new ShutterTickingSoundInstance(entity, packet.cameraId(), Exposure.SoundEvents.SHUTTER_TICKING.get(), entity.method_5634(), packet.volume(), packet.pitch(), packet.durationTicks());
            UniqueSoundManager.play(packet.cameraId().toString(), (class_1113)instance);
        }
    }

    public static void stopControllingCameraStand(CameraStandStopControllingS2CP packet) {
        class_1297 class_12972;
        if (Minecrft.get().field_1719 != Minecrft.player() && (class_12972 = Minecrft.level().method_8469(packet.standId())) instanceof CameraStandEntity) {
            CameraStandEntity stand = (CameraStandEntity)class_12972;
            stand.stopControlling();
            CameraClient.setCameraEntity((class_1297)Minecrft.player());
        }
    }
}

