/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.client.image.modifier;

import com.google.common.base.Preconditions;
import io.github.mortuusars.exposure.client.image.CensoredImage;
import io.github.mortuusars.exposure.client.image.CroppedImage;
import io.github.mortuusars.exposure.client.image.Image;
import io.github.mortuusars.exposure.client.image.ResizedImage;
import io.github.mortuusars.exposure.client.image.modifier.pixel.AgedHSBEffect;
import io.github.mortuusars.exposure.client.image.modifier.pixel.BlackAndWhiteEffect;
import io.github.mortuusars.exposure.client.image.modifier.pixel.ColorBalanceEffect;
import io.github.mortuusars.exposure.client.image.modifier.pixel.ContrastEffect;
import io.github.mortuusars.exposure.client.image.modifier.pixel.ExposureEffect;
import io.github.mortuusars.exposure.client.image.modifier.pixel.HSBEffect;
import io.github.mortuusars.exposure.client.image.modifier.pixel.LevelsEffect;
import io.github.mortuusars.exposure.client.image.modifier.pixel.NegativeEffect;
import io.github.mortuusars.exposure.client.image.modifier.pixel.NegativeFilmEffect;
import io.github.mortuusars.exposure.client.image.modifier.pixel.NoiseEffect;
import io.github.mortuusars.exposure.util.Rect2i;
import io.github.mortuusars.exposure.world.camera.ColorChannel;
import io.github.mortuusars.exposure.world.camera.film.properties.HSB;
import io.github.mortuusars.exposure.world.camera.film.properties.Levels;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.class_3532;

public interface ImageEffect {
    public static final ImageEffect EMPTY = new Instance("", Function.identity());
    public static final ImageEffect CENSORED = new Instance("censored", CensoredImage::new);
    public static final ImageEffect NEGATIVE = new NegativeEffect();
    public static final ImageEffect NEGATIVE_FILM = new NegativeFilmEffect();
    public static final ImageEffect AGED = new AgedHSBEffect(14264419, 0.65f, 40, 255);
    public static final ImageEffect BLACK_AND_WHITE = new BlackAndWhiteEffect(0.299f, 0.587f, 0.114f);

    public String getIdentifier();

    public Image modify(Image var1);

    public static ImageEffect exposure(float exposure) {
        return exposure != 1.0f ? new ExposureEffect(exposure) : EMPTY;
    }

    public static ImageEffect contrast(float contrast) {
        return contrast != 0.0f ? new ContrastEffect(contrast) : EMPTY;
    }

    public static ImageEffect noise(float noise) {
        return noise != 0.0f ? new NoiseEffect(class_3532.method_15363((float)noise, (float)0.0f, (float)1.0f)) : EMPTY;
    }

    public static ImageEffect levels(Levels levels) {
        return !levels.equals(Levels.EMPTY) ? new LevelsEffect(levels) : EMPTY;
    }

    public static ImageEffect hsb(HSB hsb) {
        return ImageEffect.hsb(hsb.hue(), hsb.saturation(), hsb.brightness());
    }

    public static ImageEffect hsb(float hue, float saturation, float brightness) {
        return hue != 0.0f || saturation != 0.0f || brightness != 0.0f ? new HSBEffect(hue, saturation, brightness) : EMPTY;
    }

    public static ImageEffect colorBalance(float r, float g, float b) {
        return new ColorBalanceEffect(r, g, b);
    }

    public static ImageEffect singleChannelBlackAndWhite(ColorChannel colorChannel) {
        return switch (colorChannel) {
            default -> throw new MatchException(null, null);
            case ColorChannel.RED -> new BlackAndWhiteEffect(1.0f, 0.05f, 0.05f);
            case ColorChannel.GREEN -> new BlackAndWhiteEffect(0.05f, 1.0f, 0.05f);
            case ColorChannel.BLUE -> new BlackAndWhiteEffect(0.05f, 0.05f, 1.0f);
        };
    }

    public static ImageEffect composite(ImageEffect ... modifiers) {
        if (modifiers.length == 0) {
            return EMPTY;
        }
        return new Composite(modifiers);
    }

    public static Function<Image, Image> chain(ImageEffect ... modifiers) {
        return ImageEffect.composite(modifiers)::modify;
    }

    public static ImageEffect optional(boolean condition, ImageEffect modifier) {
        return condition ? modifier : EMPTY;
    }

    public static ImageEffect optional(boolean condition, Supplier<ImageEffect> supplier) {
        return condition ? supplier.get() : EMPTY;
    }

    public static <T> ImageEffect optional(Function<T, ImageEffect> modifier, Optional<T> optional) {
        return optional.map(modifier).orElse(EMPTY);
    }

    public record Composite(ImageEffect[] modifiers) implements ImageEffect
    {
        @Override
        public Image modify(Image image) {
            for (ImageEffect modifier : this.modifiers) {
                image = modifier.modify(image);
            }
            return image;
        }

        @Override
        public String getIdentifier() {
            return Arrays.stream(this.modifiers).filter(filter -> !filter.equals(EMPTY)).map(ImageEffect::getIdentifier).collect(Collectors.joining("_"));
        }
    }

    public record Instance(String identifier, Function<Image, Image> processingFunction) implements ImageEffect
    {
        @Override
        public Image modify(Image image) {
            return this.processingFunction.apply(image);
        }

        @Override
        public String getIdentifier() {
            return this.identifier;
        }
    }

    public static interface Resize
    extends ImageEffect {
        public static ImageEffect to(int width, int height) {
            return new Instance("resized-%sx%s".formatted(width, height), image -> new ResizedImage((Image)image, width, height));
        }

        public static ImageEffect to(int size) {
            return Resize.to(size, size);
        }

        public static ImageEffect multiplier(int multiplier) {
            Preconditions.checkArgument((multiplier > 0 ? 1 : 0) != 0, (Object)"multiplier should be larger than 0.");
            return new Instance("resized-%sx".formatted(multiplier), image -> new ResizedImage((Image)image, image.width() * multiplier, image.height() * multiplier));
        }
    }

    public static interface Crop
    extends ImageEffect {
        public static final ImageEffect SQUARE_CENTER = new Instance("crop-square", image -> {
            int smallerSide = Math.min(image.width(), image.height());
            int x = (image.width() - smallerSide) / 2;
            int y = (image.height() - smallerSide) / 2;
            return new CroppedImage((Image)image, new Rect2i(x, y, smallerSide, smallerSide));
        });

        public static ImageEffect factor(double factor) {
            if (factor == 1.0) {
                return EMPTY;
            }
            double clampedFactor = Math.min(1.0, factor);
            return new Instance("crop-factor-" + String.format("%,.4f", clampedFactor), image -> {
                int newWidth = (int)((double)image.width() * clampedFactor);
                int newHeight = (int)((double)image.height() * clampedFactor);
                int x = (image.width() - newWidth) / 2;
                int y = (image.height() - newHeight) / 2;
                return new CroppedImage((Image)image, new Rect2i(x, y, newWidth, newHeight));
            });
        }

        public static ImageEffect factor(float factor) {
            return Crop.factor((double)factor);
        }
    }
}

